/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.builder;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.query.IAdvisorNode;
import org.eclipse.buckminster.core.query.IComponentQuery;
import org.eclipse.buckminster.core.query.builder.AdvisorNodeBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;

public class ComponentQueryBuilder
implements IComponentQuery {
    private final ArrayList<AdvisorNodeBuilder> advisorNodes = new ArrayList();
    private final ComponentRequestBuilder rootRequest = new ComponentRequestBuilder();
    private Documentation documentation;
    private Map<String, String> properties;
    private URL contextURL;
    private String propertiesURL;
    private String resourceMapURL;
    private String shortDesc;

    public AdvisorNodeBuilder addAdvisorNode() {
        AdvisorNodeBuilder node = new AdvisorNodeBuilder();
        this.advisorNodes.add(node);
        return node;
    }

    public void addAdvisorNode(AdvisorNodeBuilder node) {
        this.advisorNodes.add(node);
    }

    public void clear() {
        this.rootRequest.clear();
        this.advisorNodes.clear();
        this.contextURL = null;
        this.properties = null;
        this.propertiesURL = null;
        this.resourceMapURL = null;
        this.documentation = null;
        this.shortDesc = null;
    }

    public ComponentQuery createComponentQuery() {
        return new ComponentQuery(this);
    }

    public List<AdvisorNodeBuilder> getAdvisoryNodes() {
        return this.advisorNodes;
    }

    @Override
    public URL getContextURL() {
        return this.contextURL;
    }

    @Override
    public Map<String, String> getDeclaredProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public AdvisorNodeBuilder getNodeByCriteria(Pattern pattern, String componentType, Filter filter) {
        for (AdvisorNodeBuilder node : this.advisorNodes) {
            if (!Trivial.equalsAllowNull((Object)node.getNamePattern(), (Object)pattern) || !Trivial.equalsAllowNull((Object)node.getComponentTypeID(), (Object)componentType) || !Trivial.equalsAllowNull((Object)node.getFilter(), (Object)filter)) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getPropertiesURL() {
        return this.propertiesURL;
    }

    @Override
    public String getResourceMapURL() {
        return this.resourceMapURL;
    }

    @Override
    public ComponentRequest getRootRequest() {
        return this.rootRequest.createComponentRequest();
    }

    public ComponentRequestBuilder getRootRequestBuilder() {
        return this.rootRequest;
    }

    @Override
    public String getShortDesc() {
        return this.shortDesc;
    }

    public void initFrom(IComponentQuery query) {
        this.clear();
        for (IAdvisorNode iAdvisorNode : query.getAdvisoryNodes()) {
            AdvisorNodeBuilder bld = new AdvisorNodeBuilder();
            bld.initFrom(iAdvisorNode);
            this.advisorNodes.add(bld);
        }
        Map<String, String> map = query.getDeclaredProperties();
        if (map.size() > 0) {
            this.properties = new HashMap<String, String>(map);
        }
        this.contextURL = query.getContextURL();
        this.propertiesURL = query.getPropertiesURL();
        this.resourceMapURL = query.getResourceMapURL();
        this.rootRequest.initFrom(query.getRootRequest());
        this.documentation = query.getDocumentation();
        this.shortDesc = query.getShortDesc();
    }

    public void removeAdvisorNode(AdvisorNodeBuilder node) {
        this.advisorNodes.remove(node);
    }

    public final void setContextURL(URL contextURL) {
        this.contextURL = contextURL;
    }

    public void setDocumentation(Documentation documentation) {
        this.documentation = documentation;
    }

    public void setPlatformAgnostic(boolean flag) {
        if (!flag) {
            if (this.properties == null) {
                return;
            }
            this.properties.remove("target.os");
            this.properties.remove("target.ws");
            this.properties.remove("target.arch");
            this.properties.remove("target.nl");
            if (this.properties.size() == 0) {
                this.properties = null;
            }
        } else {
            Map<String, String> props = this.getDeclaredProperties();
            props.put("target.os", "*");
            props.put("target.ws", "*");
            props.put("target.arch", "*");
            props.put("target.nl", "*");
        }
    }

    public final void setPropertiesURL(String propertiesURL) {
        this.propertiesURL = propertiesURL;
    }

    public final void setResourceMapURL(String resourceMapURL) {
        this.resourceMapURL = resourceMapURL;
    }

    public final void setRootRequest(IComponentRequest rootRequest) {
        this.rootRequest.initFrom(rootRequest);
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }
}

