/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.query.parser;

import java.net.URL;
import java.util.Map;
import org.eclipse.buckminster.core.common.parser.DocumentationHandler;
import org.eclipse.buckminster.core.common.parser.PropertyManagerHandler;
import org.eclipse.buckminster.core.cspec.parser.ComponentRequestHandler;
import org.eclipse.buckminster.core.query.builder.ComponentQueryBuilder;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.query.parser.AdvisorNodeHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ComponentQueryHandler
extends PropertyManagerHandler {
    private final URL contextURL;
    private DocumentationHandler documentationHandler;
    private AdvisorNodeHandler advisorNodeHandler;
    private final ComponentQueryBuilder builder = new ComponentQueryBuilder();

    public ComponentQueryHandler(AbstractHandler parent, URL contextURL) {
        super(parent, "componentQuery");
        this.contextURL = contextURL;
    }

    @Override
    public void childPopped(ChildHandler child) throws SAXException {
        if (child == this.advisorNodeHandler) {
            this.builder.addAdvisorNode(this.advisorNodeHandler.getAdvisorNodeBuilder());
        } else if (child == this.documentationHandler) {
            this.builder.setDocumentation(this.documentationHandler.createDocumentation());
        } else {
            super.childPopped(child);
        }
    }

    @Override
    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        ChildHandler ch;
        if ("rootRequest".equals(localName)) {
            ch = new ComponentRequestHandler((AbstractHandler)this, this.builder.getRootRequestBuilder());
        } else if ("advisorNode".equals(localName)) {
            if (this.advisorNodeHandler == null) {
                this.advisorNodeHandler = new AdvisorNodeHandler((AbstractHandler)this);
            }
            ch = this.advisorNodeHandler;
        } else if ("documentation".equals(localName)) {
            if (this.documentationHandler == null) {
                this.documentationHandler = new DocumentationHandler((AbstractHandler)this);
            }
            ch = this.documentationHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public ComponentQuery getComponentQuery() throws SAXException {
        return this.builder.createComponentQuery();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.builder.getDeclaredProperties();
    }

    public void handleAttributes(Attributes attrs) throws SAXException {
        this.builder.clear();
        this.builder.setContextURL(this.contextURL);
        this.builder.setPropertiesURL(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"properties"));
        this.builder.setResourceMapURL(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"resourceMap"));
        this.builder.setShortDesc(ComponentQueryHandler.getOptionalStringValue((Attributes)attrs, (String)"shortDesc"));
    }
}

