/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.reader;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.materializer.MaterializerEndPoint;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.AbstractReader;
import org.eclipse.buckminster.core.reader.IFileReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.download.ICache;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class URLFileReader
extends AbstractReader
implements IFileReader {
    private final URI uri;
    private IFileInfo fileInfo;

    protected URLFileReader(IReaderType readerType, ProviderMatch rInfo, URI uri) throws CoreException {
        super(readerType, rInfo);
        this.uri = uri;
        this.fileInfo = null;
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws CoreException, IOException {
        InputStream input = null;
        try {
            input = this.open(monitor);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        finally {
            IOUtils.close((Closeable)input);
        }
    }

    @Override
    public IFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public File getLocation() throws CoreException {
        return FileUtils.getFile(this.getURL());
    }

    public final URI getURI() {
        return this.uri;
    }

    @Override
    public void materialize(IPath location, Resolution resolution, MaterializationContext ctx, IProgressMonitor monitor) throws CoreException {
        File destFile;
        MaterializerEndPoint unpacker;
        InputStream in;
        block7: {
            URL url = this.getURL();
            IConnectContext cctx = this.getConnectContext();
            monitor.beginTask(null, 1000);
            monitor.subTask(NLS.bind((String)Messages.Copying_from_0, (Object)url));
            in = null;
            IFileInfo[] fiHandle = new IFileInfo[1];
            in = DownloadManager.getCache().open(url, cctx, null, fiHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800));
            this.fileInfo = fiHandle[0];
            unpacker = MaterializerEndPoint.create(location, this.fileInfo.getRemoteName(), resolution, ctx);
            destFile = unpacker.getFinalDestination().toFile();
            if (!destFile.toURI().toURL().equals(url)) break block7;
            IOUtils.close((Closeable)in);
            monitor.done();
            return;
        }
        try {
            try {
                File destDir = destFile.getParentFile();
                if (destDir != null && !destDir.isDirectory()) {
                    FileUtils.createDirectory(destDir, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
                }
                unpacker.unpack(in, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)in);
        monitor.done();
    }

    @Override
    public InputStream open(IProgressMonitor monitor) throws CoreException, IOException {
        ICache cache = DownloadManager.getCache();
        IFileInfo[] fiHandle = new IFileInfo[1];
        InputStream input = cache.open(this.getURL(), this.getConnectContext(), null, fiHandle, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800));
        this.fileInfo = fiHandle[0];
        return input;
    }

    @Override
    public final <T> T readFile(IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        T t;
        monitor.beginTask(null, 100);
        InputStream input = null;
        try {
            input = this.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
            t = consumer.consumeStream(this, this.getURL().toString(), input, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            monitor.done();
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        monitor.done();
        return t;
    }

    public String toString() {
        return this.uri.toString();
    }

    protected URL getURL() throws CoreException {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }
}

