/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.resolver;

import java.util.List;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.model.BillOfMaterials;
import org.eclipse.buckminster.core.metadata.model.UnresolvedNode;
import org.eclipse.buckminster.core.resolver.IResolver;
import org.eclipse.buckminster.core.resolver.IResolverFactory;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolutionContext;
import org.eclipse.buckminster.core.resolver.ResolverDecision;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.resolver.ResolverFactoryMaintainer;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class MainResolver
implements IResolver {
    private static final int MAX_ITERATIONS = 8;
    private final ResolutionContext context;
    private boolean recursiveResolve = true;

    public MainResolver(ResolutionContext context) {
        this.context = context;
    }

    @Override
    public ResolutionContext getContext() {
        return this.context;
    }

    @Override
    public boolean isRecursiveResolve() {
        return this.recursiveResolve;
    }

    @Override
    public ResolverDecision logDecision(ComponentRequest request, ResolverDecisionType decisionType, Object ... args) {
        return this.context.logDecision(request, decisionType, args);
    }

    @Override
    public ResolverDecision logDecision(ResolverDecisionType decisionType, Object ... args) {
        return this.context.logDecision(decisionType, args);
    }

    @Override
    public BillOfMaterials resolve(ComponentRequest request, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = this.context.getNodeQuery(request);
        BillOfMaterials bom = BillOfMaterials.create(new UnresolvedNode(query.getQualifiedDependency()), this.context.getComponentQuery());
        return this.resolveRemaining(bom, monitor);
    }

    @Override
    public BillOfMaterials resolve(IProgressMonitor monitor) throws CoreException {
        return this.resolve(this.context.getComponentQuery().getExpandedRootRequest(this.context), monitor);
    }

    @Override
    public BillOfMaterials resolveRemaining(BillOfMaterials bom, IProgressMonitor monitor) throws CoreException {
        if (bom.isFullyResolved(this.context)) {
            return bom;
        }
        this.context.addTagInfo(bom.getRequest(), bom.getQuery().getTagInfo());
        IResolverFactory[] resolverFactories = ResolverFactoryMaintainer.getInstance().getActiveResolverFactories();
        int numFactories = resolverFactories.length;
        if (numFactories == 1) {
            IResolverFactory factory = resolverFactories[0];
            this.logDecision(ResolverDecisionType.USING_RESOLVER, factory.getId());
            bom = factory.createResolver(this.context).resolveRemaining(bom, monitor);
        } else {
            monitor.beginTask(null, numFactories * 100);
            boolean continueOnError = this.context.isContinueOnError();
            boolean silentStatus = this.context.isSilentStatus();
            this.context.setContinueOnError(true);
            this.context.setSilentStatus(true);
            try {
                IStatus status;
                IResolver[] resolvers = new IResolver[numFactories];
                int idx = 0;
                while (idx < numFactories) {
                    resolvers[idx] = resolverFactories[idx].createResolver(this.context);
                    ++idx;
                }
                int iteration = 0;
                while (iteration < 8) {
                    BillOfMaterials bomAtIterationStart = bom;
                    int idx2 = 0;
                    while (idx2 < numFactories) {
                        IResolver resolver = resolvers[idx2];
                        this.logDecision(ResolverDecisionType.USING_RESOLVER, resolverFactories[idx2].getId());
                        resolver.setRecursiveResolve(this.recursiveResolve);
                        BillOfMaterials newBom = resolver.resolveRemaining(bom, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                        if (!bom.contentEqual(newBom)) {
                            if (idx2 == 0) {
                                bomAtIterationStart = bom;
                            }
                            bom = newBom;
                            if (!this.recursiveResolve || bom.isFullyResolved(this.context)) {
                                iteration = 8;
                                break;
                            }
                        }
                        ++idx2;
                    }
                    if (bomAtIterationStart.equals(bom)) break;
                    ++iteration;
                }
                if (!continueOnError && !bom.isFullyResolved(this.context) && (status = this.context.getStatus()).getSeverity() == 4) {
                    List<ComponentRequest> unresolvedList = bom.getUnresolvedList();
                    int top = unresolvedList.size();
                    if (top == 0) {
                        throw new CoreException(status);
                    }
                    StringBuilder bld = new StringBuilder();
                    bld.append(Messages.Unable_to_resolve);
                    int idx3 = 0;
                    while (idx3 < top) {
                        if (idx3 > 0) {
                            bld.append(", ");
                        }
                        unresolvedList.get(idx3).toString(bld);
                        ++idx3;
                    }
                    throw BuckminsterException.fromMessage((String)bld.toString(), (Object[])new Object[0]);
                }
            }
            finally {
                this.context.setContinueOnError(continueOnError);
                this.context.setSilentStatus(silentStatus);
                monitor.done();
            }
        }
        return bom;
    }

    @Override
    public void setRecursiveResolve(boolean flag) {
        this.recursiveResolve = flag;
    }
}

