/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.Messages;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.common.model.ExpandingProperties;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.version.IQualifierGenerator;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractQualifierGenerator
extends AbstractExtension
implements IQualifierGenerator {
    protected IInstallableUnit obtainFromReferenceRepo(IComponentIdentifier identifier, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)2000);
        try {
            VersionRange range;
            IActionContext ctx = AbstractActor.getActiveContext();
            if (ctx == null) {
                return null;
            }
            Map<String, ? extends Object> props = ctx.getProperties();
            IMetadataRepository repo = this.getReferenceRepository(props, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1990));
            if (repo == null) {
                return null;
            }
            String id = identifier.getName();
            if ("eclipse.feature".equals(identifier.getComponentTypeID())) {
                id = String.valueOf(id) + ".feature.group";
            }
            if ((range = VersionHelper.unqualifiedRange(identifier.getVersion())) == null) {
                return null;
            }
            Iterator iter = repo.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id, (VersionRange)range)), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10)).iterator();
            IInstallableUnit iInstallableUnit = iter.hasNext() ? (IInstallableUnit)iter.next() : null;
            return iInstallableUnit;
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    synchronized IMetadataRepository getReferenceRepository(Map<String, ? extends Object> props, IProgressMonitor monitor) throws CoreException {
        Object refURIVal = props.get("buckminster.reference.repository");
        if (!(refURIVal instanceof String)) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return null;
        }
        String expanded = ExpandingProperties.expand(props, (String)refURIVal, 0);
        URI refURI = URLUtils.normalizeToURI((String)expanded, (boolean)true);
        IProvisioningAgent p2Agent = CorePlugin.getDefault().getResolverAgent();
        IMetadataRepositoryManager mdrManager = (IMetadataRepositoryManager)p2Agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        try {
            return mdrManager.loadRepository(refURI, monitor);
        }
        catch (ProvisionException e) {
            CorePlugin.getLogger().error(NLS.bind((String)Messages.Unable_to_load_reference_repo_0, (Object)refURI.toString()), new Object[0]);
            throw e;
        }
    }
}

