/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.core.version;

import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.builder.ResolutionBuilder;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;

public final class ProviderMatch
implements Comparable<ProviderMatch> {
    private IComponentType componentType;
    private final Provider originalProvider;
    private Provider provider;
    private final ProviderScore providerScore;
    private final NodeQuery query;
    private VersionMatch versionMatch;
    private Map<String, String> matcherMap;
    private String repositoryURI;

    public ProviderMatch(Provider provider, IComponentType componentType, VersionMatch versionMatch, NodeQuery query) {
        this(provider, componentType, versionMatch, ProviderScore.PREFERRED, query);
    }

    public ProviderMatch(Provider provider, IComponentType componentType, VersionMatch versionMatch, ProviderScore providerScore, NodeQuery query) {
        this.provider = provider;
        this.originalProvider = provider;
        this.componentType = componentType;
        this.versionMatch = versionMatch == null ? VersionMatch.DEFAULT : versionMatch;
        this.providerScore = providerScore;
        this.query = query;
    }

    @Override
    public int compareTo(ProviderMatch o) {
        int versionCompare = this.query.compare(this.versionMatch, o.getVersionMatch());
        return versionCompare == 0 ? this.providerScore.compareTo(o.getProviderScore()) : versionCompare;
    }

    public CSpecBuilder createCSpec() {
        CSpecBuilder bld = new CSpecBuilder();
        ComponentRequest request = this.query.getComponentRequest();
        bld.setName(request.getName());
        bld.setComponentTypeID(request.getComponentTypeID());
        bld.setVersion(this.versionMatch.getVersion());
        return bld;
    }

    public ResolutionBuilder createResolution(CSpecBuilder cspecBuilder, boolean unpack) throws CoreException {
        ResolutionBuilder resBld = new ResolutionBuilder(cspecBuilder);
        NodeQuery nq = this.getNodeQuery();
        resBld.setMaterializable(true);
        resBld.setComponentTypeId(this.getComponentType().getId());
        resBld.getRequest().initFrom(nq.getComponentRequest());
        resBld.setAttributes(nq.getRequiredAttributes());
        resBld.setProvider(this.getProvider());
        resBld.setVersionMatch(this.getVersionMatch());
        resBld.setRepository(this.getRepositoryURI());
        resBld.setUnpack(unpack);
        return resBld;
    }

    public String getComponentName() {
        return this.query.getComponentRequest().getName();
    }

    public IComponentType getComponentType() {
        return this.componentType;
    }

    public IConnectContext getConnectContext() {
        IConnectContext cctx = this.provider.getConnectContext(this.query.getProperties());
        if (cctx == null) {
            cctx = this.getNodeQuery().getComponentQuery().getConnectContext();
        }
        return cctx;
    }

    public Map<String, String> getMatcherMap() {
        return this.matcherMap;
    }

    public NodeQuery getNodeQuery() {
        return this.query;
    }

    public Provider getOriginalProvider() {
        return this.originalProvider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public final ProviderScore getProviderScore() {
        return this.providerScore;
    }

    public NodeQuery getQuery() {
        return this.query;
    }

    public IComponentReader getReader(IProgressMonitor monitor) throws CoreException {
        return this.getReaderType().getReader(this, monitor);
    }

    public IReaderType getReaderType() throws CoreException {
        return this.provider.getReaderType();
    }

    public synchronized String getRepositoryURI() {
        if (this.repositoryURI == null) {
            this.repositoryURI = this.provider.getURI(this.query.getProperties());
        }
        return this.repositoryURI;
    }

    public String getUniqueKey() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.provider.getId());
        bld.append('[');
        ComponentRequest rq = this.query.getComponentRequest();
        bld.append(rq.getName());
        String type = rq.getComponentTypeID();
        if (type != null) {
            bld.append(':');
            bld.append(type);
        }
        this.versionMatch.toString(bld);
        bld.append(']');
        return bld.toString();
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        return this.provider.getVersionConverter();
    }

    public VersionMatch getVersionMatch() {
        return this.versionMatch;
    }

    public void setComponentType(IComponentType componentType) {
        this.componentType = componentType;
    }

    public void setMatcherMap(Map<String, String> matcherMap) {
        this.matcherMap = matcherMap;
    }

    public synchronized void setProvider(Provider provider) {
        this.provider = provider;
        this.repositoryURI = null;
    }

    public synchronized void setRepositoryURI(String repositoryURI) {
        this.repositoryURI = repositoryURI;
    }

    public void setVersionMatch(VersionMatch versionMatch) {
        this.versionMatch = versionMatch;
    }

    public String toString() {
        return this.getUniqueKey();
    }
}

