/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.cvspkg.internal;

import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.buckminster.cvspkg.Messages;
import org.eclipse.buckminster.cvspkg.internal.CVSReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderSandbox;

public class CVSSession
implements Closeable {
    private final ICVSRepositoryLocation location;
    private final String moduleName;
    private Session readerSession;

    public CVSSession(String repositoryURI) throws CoreException {
        StringTokenizer tokenizer = new StringTokenizer(repositoryURI, ",");
        try {
            String module;
            String repo = tokenizer.nextToken();
            this.location = CVSReaderType.getLocationFromString(repo);
            String string = module = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            if (module != null && module.startsWith("/")) {
                module = module.substring(1);
            }
            this.moduleName = module;
        }
        catch (NoSuchElementException e) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.repository_URI_not_in_0_format, (Object)("<" + Messages.cvs_root + ">,<" + Messages.cvs_module + ">")), (Object[])new Object[0]);
        }
    }

    @Override
    public synchronized void close() {
        if (this.readerSession != null) {
            this.readerSession.close();
            this.readerSession = null;
        }
    }

    public String getFilePrefix() {
        StringBuilder bld = new StringBuilder(this.location.getRootDirectory());
        bld.append('/');
        if (this.moduleName != null) {
            bld.append(this.moduleName);
            bld.append('/');
        }
        return bld.toString();
    }

    public final ICVSRepositoryLocation getLocation() {
        return this.location;
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public String getRepository() {
        String repoURI = this.location.getLocation(false);
        if (this.moduleName == null) {
            return repoURI;
        }
        return String.valueOf(repoURI) + '/' + this.moduleName;
    }

    synchronized Session getReaderSession(IProgressMonitor monitor) throws CoreException {
        if (this.readerSession == null) {
            ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            this.readerSession = new Session(this.getLocation(), root, false);
            this.readerSession.open(monitor, false);
        }
        return this.readerSession;
    }

    RemoteFolderSandbox getSandbox(CVSTag tag) {
        return new RemoteFolderSandbox(null, this.getLocation(), this.getModuleName(), tag);
    }
}

