/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.actor.IllegalPrerequisiteException;
import org.eclipse.buckminster.core.actor.MissingPrerequisiteException;
import org.eclipse.buckminster.core.actor.MissingPropertyException;
import org.eclipse.buckminster.core.cspec.model.Action;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.jarprocessor.Messages;
import org.eclipse.buckminster.jarprocessor.RecursiveConditioner;
import org.eclipse.buckminster.jarprocessor.RecursivePacker;
import org.eclipse.buckminster.jarprocessor.RecursiveUnpacker;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class JarProcessorActor
extends AbstractActor {
    public static final String ACTOR_ID = "jarProcessor";
    public static final String ALIAS_JAR_FOLDER = "jar.folder";
    public static final String PROP_COMMAND = "command";
    public static final String COMMAND_REPACK = "repack";
    public static final String COMMAND_PACK = "pack";
    public static final String COMMAND_UNPACK = "unpack";
    private IActionContext context;

    protected IStatus internalPerform(IActionContext ctx, IProgressMonitor monitor) throws CoreException {
        this.context = ctx;
        try {
            block14: {
                Action action = ctx.getAction();
                IPath outputPath = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)action, (boolean)false);
                IPath jarFolder = null;
                CSpec cspec = action.getCSpec();
                for (Prerequisite preq : action.getPrerequisites()) {
                    if (ALIAS_JAR_FOLDER.equals(preq.getAlias())) {
                        Attribute rt = preq.getReferencedAttribute(cspec, (IModelCache)ctx);
                        if (rt == null) continue;
                        jarFolder = AbstractActor.getSingleAttributePath((IActionContext)ctx, (Attribute)rt, (boolean)true);
                        continue;
                    }
                    throw new IllegalPrerequisiteException(action, preq.getName());
                }
                if (jarFolder == null) {
                    throw new MissingPrerequisiteException(action, (Object)ALIAS_JAR_FOLDER);
                }
                Map props = ctx.getProperties();
                String command = (String)props.get(PROP_COMMAND);
                if (command == null) {
                    throw new MissingPropertyException(action, (Object)PROP_COMMAND);
                }
                if (!jarFolder.hasTrailingSeparator()) {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)org.eclipse.buckminster.core.Messages.input_of_action_0_must_be_folder, (Object)action.getQualifiedName()), (Object[])new Object[0]);
                }
                if (!outputPath.hasTrailingSeparator()) {
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)org.eclipse.buckminster.core.Messages.output_of_action_0_must_be_folder, (Object)action.getQualifiedName()), (Object[])new Object[0]);
                }
                File outputDir = outputPath.toFile().getAbsoluteFile();
                outputDir.mkdirs();
                try {
                    if (COMMAND_REPACK.equals(command)) {
                        this.repackJars(jarFolder.toFile(), outputDir);
                        break block14;
                    }
                    if (COMMAND_PACK.equals(command)) {
                        this.packJars(jarFolder.toFile(), outputDir, props);
                        break block14;
                    }
                    if (COMMAND_UNPACK.equals(command)) {
                        this.unpackJars(jarFolder.toFile(), outputDir, props);
                        break block14;
                    }
                    throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.action_0_does_not_recognize_command_1, (Object)action.getQualifiedName(), (Object)command), (Object[])new Object[0]);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.context = null;
        }
    }

    private File getTempDir() {
        return new File((String)this.context.getProperties().get("buckminster.temp"));
    }

    private void packJars(File inputDir, File outputDir, Map<String, ? extends Object> props) throws CoreException, IOException {
        File[] files;
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (file.isDirectory()) {
                File childOutputDir = new File(outputDir, name);
                childOutputDir.mkdir();
                this.packJars(file, childOutputDir, props);
            } else if (!name.endsWith(".jar")) {
                FileUtils.copyFile((File)file, (File)outputDir, (String)name, null);
            } else {
                RecursivePacker rpacker = new RecursivePacker(this.getTempDir(), null, true);
                rpacker.pack(file, outputDir, true);
            }
            ++n2;
        }
    }

    private void repackJars(File inputDir, File outputDir) throws CoreException, IOException {
        File[] files;
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (file.isDirectory()) {
                File childOutputDir = new File(outputDir, name);
                childOutputDir.mkdir();
                this.repackJars(file, childOutputDir);
            } else if (name.endsWith(".jar")) {
                RecursiveConditioner rcond = new RecursiveConditioner(this.getTempDir(), null);
                rcond.condition(file, new File(outputDir, name));
            } else {
                FileUtils.copyFile((File)file, (File)outputDir, (String)name, null);
            }
            ++n2;
        }
    }

    private void unpackJars(File inputDir, File outputDir, Map<String, ? extends Object> props) throws CoreException {
        File[] files;
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName();
            if (file.isDirectory()) {
                File childOutputDir = new File(outputDir, name);
                childOutputDir.mkdir();
                this.unpackJars(file, childOutputDir, props);
            } else if (name.endsWith(".pack.gz")) {
                RecursiveUnpacker unpacker = new RecursiveUnpacker(this.getTempDir(), null);
                unpacker.unpack(file, outputDir, true);
            } else {
                FileUtils.copyFile((File)file, (File)outputDir, (String)name, null);
            }
            ++n2;
        }
    }
}

