/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.jarprocessor.ProducerThread;
import org.eclipse.buckminster.jarprocessor.RecursivePack200;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;

public class RecursiveUnpacker
extends RecursivePack200 {
    static boolean isJarMagic(byte[] magic) {
        return magic[0] == 80 && magic[1] == 75 && magic[2] >= 1 && magic[2] < 8 && magic[3] == magic[2] + 1;
    }

    public RecursiveUnpacker(File tempDir, List<String> defaultArgs) {
        super(tempDir, defaultArgs);
    }

    private void nestedUnpack(InputStream input, OutputStream unpacked) throws IOException {
        ZipEntry entry;
        ZipInputStream jarIn;
        final BufferedInputStream bufferedInput = new BufferedInputStream(input);
        bufferedInput.mark(4);
        byte[] magic = new byte[4];
        if (bufferedInput.read(magic, 0, 4) != 4) {
            throw new IOException("Unable to read packed file magic");
        }
        bufferedInput.reset();
        if (RecursiveUnpacker.isJarMagic(magic)) {
            jarIn = new ZipInputStream(bufferedInput);
        } else {
            ProducerThread jarPumper = new ProducerThread("Unpack200 jarPumper"){

                @Override
                protected void internalRun(OutputStream writer) throws Exception {
                    RecursiveUnpacker.this.unpack(new RecursivePack200.NonClosingInputStream(bufferedInput), writer);
                }
            };
            jarPumper.start();
            jarIn = new ZipInputStream(jarPumper.getReaderStream());
        }
        ZipOutputStream jarOut = new ZipOutputStream(unpacked);
        while ((entry = jarIn.getNextEntry()) != null) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                jarOut.putNextEntry(RecursiveUnpacker.createEntry(entry));
                continue;
            }
            String jarName = null;
            InflaterInputStream packedInput = null;
            if (name.endsWith(".pack.gz")) {
                jarName = name.substring(0, name.length() - ".pack.gz".length());
                packedInput = new GZIPInputStream(new RecursivePack200.NonClosingInputStream(jarIn));
            } else if (name.endsWith(".pack")) {
                jarName = name.substring(0, name.length() - ".pack".length());
                packedInput = jarIn;
            }
            if (packedInput != null) {
                Buckminster.getLogger().debug("Unpacker: Recursive unpack of %s", new Object[]{name});
                jarOut.putNextEntry(RecursiveUnpacker.createEntry(entry, jarName));
                this.nestedUnpack(packedInput, jarOut);
                continue;
            }
            jarOut.putNextEntry(RecursiveUnpacker.createEntry(entry));
            IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut, null);
        }
        jarOut.finish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unpack(File packedFile, File destFolder, boolean retainPacked) throws CoreException {
        boolean sharedFolder;
        if (destFolder == null) {
            sharedFolder = true;
            destFolder = packedFile.getParentFile();
        } else {
            sharedFolder = destFolder.equals(packedFile.getParentFile());
        }
        String fileName = packedFile.getAbsolutePath();
        String name = packedFile.getName();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                GZIPInputStream input = new GZIPInputStream(new FileInputStream(packedFile));
                try {
                    try (FileOutputStream output = new FileOutputStream(new File(destFolder, name.substring(0, name.length() - ".pack.gz".length())));){
                        this.nestedUnpack(input, output);
                        if (sharedFolder) {
                            if (!retainPacked) {
                                packedFile.delete();
                            }
                        } else if (retainPacked) {
                            FileUtils.copyFile((File)packedFile, (File)destFolder, (String)name, null);
                        }
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    ((InputStream)input).close();
                    throw throwable;
                }
                ((InputStream)input).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw BuckminsterException.fromMessage((Throwable)e, (String)"Unable to condition %s", (Object[])new Object[]{fileName});
        }
    }
}

