/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.impl.Parser;
import org.osgi.framework.ServiceReference;

abstract class FilterImpl
implements Filter,
Comparable<FilterImpl> {
    static final int LESS = 4;
    static final int PRESENT = 5;
    static final int SUBSTRING = 6;
    static final int AND = 7;
    static final int OR = 8;
    static final int NOT = 9;
    private final int op;
    static final int EQUAL = 1;
    static final int APPROX = 2;
    static final int GREATER = 3;
    private final String attr;

    static String approxString(String input) {
        boolean changed = false;
        char[] output = input.toCharArray();
        int cursor = 0;
        int i = 0;
        int length = output.length;
        while (i < length) {
            char c = output[i];
            if (Character.isWhitespace(c)) {
                changed = true;
            } else {
                output[cursor] = c;
                ++cursor;
            }
            ++i;
        }
        return changed ? new String(output, 0, cursor) : input;
    }

    static String encodeValue(String value) {
        int inlen = value.length();
        char[] output = null;
        int cursor = 0;
        int i = 0;
        while (i < inlen) {
            char c = value.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    if (output == null) {
                        output = new char[inlen << 2];
                        if (i > 0) {
                            value.getChars(0, i, output, 0);
                            cursor = i;
                        }
                    }
                    output[cursor++] = 92;
                }
            }
            if (output != null) {
                output[cursor++] = c;
            }
            ++i;
        }
        return output == null ? value : new String(output, 0, cursor);
    }

    FilterImpl(int operation, String attr) {
        this.op = operation;
        this.attr = attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsultedAttributes(Map<String, String[]> propertyChoices) {
        String stringValue = this.getValueAsString();
        Map<String, String[]> map = propertyChoices;
        synchronized (map) {
            int top;
            String[] choices = propertyChoices.get(this.getAttr());
            if (choices == null) {
                String[] stringArray;
                String string = this.getAttr();
                if (stringValue == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = stringValue;
                }
                propertyChoices.put(string, stringArray);
                return;
            }
            if (stringValue == null) {
                return;
            }
            int idx = top = choices.length;
            while (--idx >= 0) {
                if (!stringValue.equals(choices[idx])) continue;
                return;
            }
            String[] newChoices = new String[top + 1];
            System.arraycopy(choices, 0, newChoices, 0, top);
            newChoices[top] = stringValue;
            propertyChoices.put(this.getAttr(), newChoices);
        }
    }

    @Override
    public Filter addFilterWithAnd(Filter subFilter) {
        return subFilter == null ? this : this.addFilter((FilterImpl)subFilter, 7);
    }

    @Override
    public Filter addFilterWithOr(Filter subFilter) {
        return subFilter == null ? this : this.addFilter((FilterImpl)subFilter, 8);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FilterImpl && this.compareTo((FilterImpl)obj) == 0 || obj instanceof Filter && this.toString().equals(obj.toString());
    }

    public int getOp() {
        return this.op;
    }

    public int hashCode() {
        return 11 * this.toString().hashCode();
    }

    public boolean match(Dictionary properties) {
        return this.match(properties, false);
    }

    public boolean match(ServiceReference<?> reference) {
        return this.match0(reference == null ? Collections.emptyMap() : new ServiceReferenceMap(reference));
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.match(dictionary, true);
    }

    @Override
    public boolean matchCase(Map<String, ? extends Object> properties) {
        return this.match0(properties == null ? Collections.emptyMap() : properties);
    }

    public boolean matches(Map<String, ? extends Object> properties) {
        return this.match0((Map<String, ? extends Object>)(properties == null ? Collections.emptyMap() : new CaseInsensitiveMap<Object>(properties)));
    }

    @Override
    public Filter stripFilter(Filter subFilter) {
        return this.equals(subFilter) ? null : this;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        this.toString(bld);
        return bld.toString();
    }

    FilterImpl addFilter(FilterImpl subFilter, int operator) {
        int cmp = this.compareTo(subFilter);
        if (cmp == 0) {
            return this;
        }
        ArrayList<FilterImpl> filters = new ArrayList<FilterImpl>(2);
        filters.add(this);
        filters.add(subFilter);
        return Parser.normalize(filters, operator);
    }

    final boolean compare(Object value1) {
        if (value1 == null) {
            return false;
        }
        if (value1 instanceof Collection) {
            Iterator iterator = ((Collection)value1).iterator();
            while (iterator.hasNext()) {
                if (!this.compare(iterator.next())) continue;
                return true;
            }
            return false;
        }
        if (value1 instanceof Object[]) {
            Object[] array = (Object[])value1;
            int i = 0;
            int size = array.length;
            while (i < size) {
                if (this.compare(array[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.internalCompare(value1);
    }

    String getAttr() {
        return this.attr;
    }

    FilterImpl[] getFilterImpls() {
        return new FilterImpl[]{this};
    }

    String getValueAsString() {
        return null;
    }

    boolean internalCompare(Object value) {
        return false;
    }

    int internalCompareTo(FilterImpl o) {
        int cmp;
        int n = this.op > o.op ? 1 : (cmp = this.op < o.op ? -1 : 0);
        if (cmp == 0) {
            if (this.attr == null) {
                if (o.attr != null) {
                    cmp = -1;
                }
            } else {
                cmp = o.attr == null ? 1 : this.attr.compareTo(o.attr);
            }
        }
        return cmp;
    }

    abstract boolean match0(Map<String, ? extends Object> var1);

    abstract void toString(StringBuilder var1);

    private boolean match(Dictionary dictionary, boolean caseSensitive) {
        AbstractMap props = null;
        if (dictionary instanceof Map) {
            props = (DictionaryMap)((Object)dictionary);
            if (!caseSensitive) {
                props = new CaseInsensitiveMap<Object>(props);
            }
        } else {
            props = dictionary == null ? Collections.emptyMap() : new DictionaryMap(dictionary, caseSensitive);
        }
        return this.match0(props);
    }

    private static class CaseInsensitiveMap<V>
    extends AbstractMap<String, V> {
        private final Map<String, String> lowerCaseMap;
        private final Map<String, ? extends V> map;

        CaseInsensitiveMap(Map<String, ? extends V> map) {
            int top = map.size();
            HashMap<String, String> lcMap = null;
            for (String key : map.keySet()) {
                String lowKey;
                if (key == (lowKey = key.toLowerCase(Locale.ENGLISH))) continue;
                if (lcMap == null) {
                    lcMap = new HashMap<String, String>(top);
                }
                if (lcMap.put(lowKey, key) == null && !map.containsKey(lowKey)) continue;
                throw new IllegalArgumentException("case variants of key: " + lowKey);
            }
            this.lowerCaseMap = lcMap;
            this.map = map;
        }

        @Override
        public Set<Map.Entry<String, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public V get(Object key) {
            String realKey;
            String stringKey = ((String)key).toLowerCase(Locale.ENGLISH);
            if (this.lowerCaseMap != null && (realKey = this.lowerCaseMap.get(stringKey)) != null) {
                stringKey = realKey;
            }
            return this.map.get(stringKey);
        }
    }

    private static class DictionaryMap
    extends HashMap<String, Object> {
        private final boolean caseSensitive;

        DictionaryMap(Dictionary<String, ? extends Object> dictionary, boolean caseSensitive) {
            super(dictionary.size());
            Enumeration<String> keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Object value = dictionary.get(key);
                if (!caseSensitive) {
                    String lowKey = key.toLowerCase(Locale.ENGLISH);
                    if (this.containsKey(lowKey)) {
                        throw new IllegalArgumentException("case variants of key: " + lowKey);
                    }
                    key = lowKey;
                }
                this.put(key, value);
            }
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.caseSensitive ? super.get(key) : super.get(((String)key).toLowerCase(Locale.ENGLISH));
        }
    }

    private static class ServiceReferenceMap
    extends AbstractMap<String, Object> {
        private final ServiceReference<?> reference;

        ServiceReferenceMap(ServiceReference<?> reference) {
            this.reference = reference;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.reference.getProperty((String)key);
        }
    }
}

