/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ui.actions;

import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Version;

public abstract class SelectionHelper {
    public static CSpec selectionChanged(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection s = (IStructuredSelection)selection;
        if (s.size() != 1) {
            return null;
        }
        Object first = s.getFirstElement();
        try {
            Resolution res = null;
            if (first instanceof IPluginModelBase) {
                res = SelectionHelper.getResolution((IPluginModelBase)first);
            } else if (first instanceof IPluginBase) {
                res = SelectionHelper.getResolution((IPluginBase)first);
            } else if (first instanceof BundleSpecification) {
                res = SelectionHelper.getResolution((BundleSpecification)first);
            }
            if (res != null) {
                return res.getCSpec();
            }
        }
        catch (CoreException e) {
            CorePlugin.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
        }
        return null;
    }

    private static Resolution getResolution(BundleSpecification spec) throws CoreException {
        org.eclipse.osgi.service.resolver.VersionRange osgiRange = spec.getVersionRange();
        VersionRange range = osgiRange == null ? null : new VersionRange(osgiRange.toString());
        ComponentRequest cr = new ComponentRequest(spec.getName(), "osgi.bundle", range);
        return WorkspaceInfo.getResolution((ComponentRequest)cr, (boolean)false);
    }

    private static Resolution getResolution(IPluginBase base) throws CoreException {
        return WorkspaceInfo.getResolution((ComponentIdentifier)new ComponentIdentifier(base.getId(), "osgi.bundle", org.eclipse.equinox.p2.metadata.Version.parseVersion((String)base.getVersion())));
    }

    private static Resolution getResolution(IPluginModelBase model) throws CoreException {
        BundleDescription bundleDesc = model.getBundleDescription();
        if (bundleDesc == null) {
            return null;
        }
        Version ov = bundleDesc.getVersion();
        org.eclipse.equinox.p2.metadata.Version v = ov == null ? null : org.eclipse.equinox.p2.metadata.Version.createOSGi((int)ov.getMajor(), (int)ov.getMinor(), (int)ov.getMicro(), (String)ov.getQualifier());
        return WorkspaceInfo.getResolution((ComponentIdentifier)new ComponentIdentifier(bundleDesc.getSymbolicName(), "osgi.bundle", v));
    }
}

