/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.reader.AbstractRemoteReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversion.ISvnEntryHelper;
import org.eclipse.buckminster.subversion.Messages;
import org.eclipse.buckminster.subversion.SvnExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class GenericRemoteReader<SVNENTRY, REVISION>
extends AbstractRemoteReader {
    protected final ISubversionSession<SVNENTRY, REVISION> session;
    private final SVNENTRY[] topEntries;

    protected GenericRemoteReader(IReaderType readerType, ProviderMatch provider, IProgressMonitor monitor) throws CoreException {
        super(readerType, provider);
        VersionMatch vm = provider.getVersionMatch();
        VersionSelector branchOrTag = vm.getBranchOrTag();
        this.session = this.getSession(provider.getRepositoryURI(), branchOrTag, vm.getNumericRevision(), vm.getTimestamp(), provider.getNodeQuery().getContext());
        this.topEntries = this.getTopEntries(monitor);
        if (this.topEntries.length == 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_find_artifacts_at_0, this.session), (Object[])new Object[0]);
        }
    }

    public final void close() {
        this.session.close();
    }

    public final String toString() {
        return this.session.toString();
    }

    protected abstract void fetchRemoteFile(URI var1, REVISION var2, OutputStream var3, IProgressMonitor var4) throws Exception;

    protected abstract ISubversionSession<SVNENTRY, REVISION> getSession(String var1, VersionSelector var2, long var3, Date var5, RMContext var6) throws CoreException;

    protected abstract SVNENTRY[] getTopEntries(IProgressMonitor var1) throws CoreException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final FileHandle innerGetContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        FileHandle fileHandle;
        Logger logger = CorePlugin.getLogger();
        IPath path = Path.fromPortableString((String)fileName);
        String topEntry = path.segment(0);
        boolean found = false;
        SVNENTRY[] SVNENTRYArray = this.topEntries;
        int n = this.topEntries.length;
        int n2 = 0;
        while (n2 < n) {
            SVNENTRY dirEntry = SVNENTRYArray[n2];
            if (topEntry.equals(this.session.getSvnEntryHelper().getEntryPath(dirEntry))) {
                found = true;
                break;
            }
            ++n2;
        }
        URI url = this.session.getSVNUrl(fileName);
        String key = this.storeInCache(fileName);
        if (!found) {
            throw new FileNotFoundException(key);
        }
        FileOutputStream output = null;
        File destFile = null;
        try {
            logger.debug("Reading remote file %s", new Object[]{key});
            destFile = this.createTempFile();
            output = new FileOutputStream(destFile);
            REVISION revision = this.session.getRevision();
            this.fetchRemoteFile(url, revision, output, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
            IOUtils.close((Closeable)output);
            if (destFile.length() == 0L && !this.remoteFileExists(url, revision, monitor)) {
                logger.debug("Remote file not found: %s", new Object[]{key});
                throw new FileNotFoundException(url.toString());
            }
            FileHandle fh = new FileHandle(fileName, destFile, true);
            destFile = null;
            fileHandle = fh;
        }
        catch (CoreException e) {
            try {
                throw e;
                catch (IOException e2) {
                    throw e2;
                }
                catch (OperationCanceledException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    Throwable rootCause = SvnExceptionHandler.getRootCause(e4);
                    if (SvnExceptionHandler.hasSvnException(rootCause)) {
                        logger.debug("Remote file not found: %s", new Object[]{key});
                        throw new FileNotFoundException(key);
                    }
                    if (e4 instanceof RuntimeException) {
                        throw (RuntimeException)e4;
                    }
                    IOException ioe = new IOException(rootCause.getMessage());
                    ioe.initCause(rootCause);
                    throw ioe;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(output);
                if (destFile != null) {
                    destFile.delete();
                }
                monitor.done();
                throw throwable;
            }
        }
        IOUtils.close((Closeable)output);
        if (destFile != null) {
            destFile.delete();
        }
        monitor.done();
        return fileHandle;
    }

    protected final void innerGetMatchingRootFiles(Pattern pattern, List<FileHandle> files, IProgressMonitor monitor) throws CoreException, IOException {
        ArrayList<String> names = null;
        ISvnEntryHelper<SVNENTRY> helper = this.session.getSvnEntryHelper();
        SVNENTRY[] SVNENTRYArray = this.topEntries;
        int n = this.topEntries.length;
        int n2 = 0;
        while (n2 < n) {
            SVNENTRY dirEntry = SVNENTRYArray[n2];
            String fileName = helper.getEntryPath(dirEntry);
            if (pattern.matcher(fileName).matches()) {
                if (names == null) {
                    names = new ArrayList<String>();
                }
                names.add(fileName);
            }
            ++n2;
        }
        if (names == null) {
            return;
        }
        if (names.size() == 1) {
            files.add(this.innerGetContents((String)names.get(0), monitor));
        } else {
            monitor.beginTask(null, names.size() * 100);
            for (String name : names) {
                files.add(this.innerGetContents(name, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100)));
            }
            monitor.done();
        }
    }

    protected final void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        ISvnEntryHelper<SVNENTRY> helper = this.session.getSvnEntryHelper();
        SVNENTRY[] SVNENTRYArray = this.topEntries;
        int n = this.topEntries.length;
        int n2 = 0;
        while (n2 < n) {
            SVNENTRY dirEntry = SVNENTRYArray[n2];
            String fileName = helper.getEntryPath(dirEntry);
            if (helper.getEntryKind(dirEntry) == 2 && !fileName.endsWith("/")) {
                fileName = String.valueOf(fileName) + '/';
            }
            files.add(fileName);
            ++n2;
        }
    }

    protected abstract boolean remoteFileExists(URI var1, REVISION var2, IProgressMonitor var3) throws CoreException;

    protected abstract String storeInCache(String var1) throws CoreException;
}

