/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class RegExFilter
extends ViewerFilter {
    private Pattern pattern;
    private boolean invert;

    public RegExFilter(String regex, boolean invert) {
        this.invert = invert;
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.pattern == null) {
            return true;
        }
        if (element instanceof BOMNode) {
            BOMNode node = (BOMNode)element;
            Matcher mat = this.pattern.matcher(node.getRequest().getName());
            if (this.invert) {
                return !mat.find();
            }
            return mat.find();
        }
        return true;
    }
}

