/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.ui.dependency.visualizer.connections.ConnectionCategory;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.IRelationshipProvider;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.provider.internal.ShortesPathCalculation;
import org.eclipse.zest.core.viewers.EntityConnectionData;

public class AllPathsToRootRelationshipProvider
implements IRelationshipProvider {
    @Override
    public Map<EntityConnectionData, ConnectionCategory> getInterestingRelationships(BOMNode root, BOMNode currentSelection, Object[] connections) {
        HashMap<EntityConnectionData, ConnectionCategory> relationships = new HashMap<EntityConnectionData, ConnectionCategory>();
        List nodes = root.getChildren();
        for (BOMNode bomNode : nodes) {
            List<BOMNode> path = ShortesPathCalculation.calculatePath(bomNode, currentSelection);
            if (path.size() <= 1) continue;
            EntityConnectionData data = new EntityConnectionData((Object)root, (Object)bomNode);
            relationships.put(data, ConnectionCategory.PATH_TO_ROOT);
            int i = 0;
            while (i < path.size() - 1) {
                data = new EntityConnectionData((Object)path.get(i + 1), (Object)path.get(i));
                relationships.put(data, ConnectionCategory.PATH_TO_ROOT);
                ++i;
            }
        }
        return relationships;
    }
}

