/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.WorkspaceInfo;
import org.eclipse.buckminster.ui.JobListener;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractCSpecAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    private CSpec selectedComponent;
    private IAdaptable selection;

    public CSpec fetchCSpec(IProgressMonitor progressMonitor) {
        if (this.selectedComponent != null) {
            return this.selectedComponent;
        }
        if (this.selection != null) {
            if (WorkspaceInfo.isFullyInitialized() || Job.getJobManager().isSuspended()) {
                this.selectedComponent = (CSpec)this.selection.getAdapter(CSpec.class);
                progressMonitor.done();
            } else {
                JobListener listener = new JobListener(progressMonitor);
                Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
                this.selectedComponent = (CSpec)this.selection.getAdapter(CSpec.class);
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
            }
        }
        return this.selectedComponent;
    }

    protected abstract void run(CSpec var1, Shell var2);

    public void run(IAction action) {
        if (this.activePart == null) {
            return;
        }
        IWorkbenchPartSite site = this.activePart.getSite();
        Shell shell = site.getShell();
        if (this.selectedComponent == null) {
            this.run(shell);
        } else {
            this.run(this.selectedComponent, shell);
        }
    }

    protected void run(Shell shell) {
        MessageDialog.openInformation((Shell)shell, null, (String)Messages.no_component_is_selected);
    }

    public void selectionChanged(IAction action, ISelection _selection) {
        this.selectedComponent = null;
        if (!(_selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection s = (IStructuredSelection)_selection;
        if (s.size() != 1) {
            return;
        }
        Object first = s.getFirstElement();
        if (first instanceof IAdaptable) {
            if (WorkspaceInfo.isFullyInitialized()) {
                this.selectedComponent = (CSpec)((IAdaptable)first).getAdapter(CSpec.class);
                action.setEnabled(this.selectedComponent != null);
            } else {
                action.setEnabled(true);
            }
            this.selection = (IAdaptable)first;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    protected void setSelectedComponent(CSpec cspec) {
        this.selectedComponent = cspec;
    }
}

