/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.model.PathAlreadyDefinedException;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.AttributesTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.PathWrapper;
import org.eclipse.buckminster.ui.editor.cspec.PathsTable;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ArtifactsTable
extends AttributesTable<ArtifactBuilder> {
    private Text basePathText;
    private List<PathWrapper> paths = new ArrayList<PathWrapper>();
    private SimpleTableEditor<PathWrapper> pathsEditor;

    public ArtifactsTable(CSpecEditor editor, List<ArtifactBuilder> data, CSpecBuilder cspec, boolean readOnly) {
        super(editor, data, cspec, readOnly);
    }

    @Override
    public void enableFields(boolean enabled) {
        super.enableFields(enabled);
        this.basePathText.setEnabled(enabled);
        this.pathsEditor.setEnabled(enabled);
    }

    @Override
    public void fillStack(Composite stackComposite) {
        this.addStackMapping(Messages.general, this.createGeneralStackLayer(stackComposite));
        this.addStackMapping(Messages.documentation, this.createDocumentationStackLayer(stackComposite));
    }

    @Override
    protected ArtifactBuilder createNewRow() {
        return this.getCSpecBuilder().createArtifactBuilder();
    }

    @Override
    protected void refreshRow(ArtifactBuilder builder) {
        super.refreshRow(builder);
        IPath basePath = builder.getBase();
        this.basePathText.setText(TextUtils.notNullString((Object)(basePath == null ? null : basePath.toOSString())));
        CSpecEditorUtils.copyAndSortItems(builder.getPaths(), this.paths);
        this.pathsEditor.refresh();
    }

    @Override
    protected void setRowValues(ArtifactBuilder builder) throws ValidatorException {
        super.setRowValues(builder);
        String basePathString = UiUtils.trimmedValue(this.basePathText);
        IPath basePath = null;
        if (basePathString != null) {
            basePath = Path.fromOSString((String)basePathString);
        }
        builder.setBase(basePath);
        Set pathSet = builder.getPaths();
        if (pathSet != null) {
            builder.getPaths().clear();
        }
        for (PathWrapper path : this.paths) {
            IPath p = path.getPath();
            if (p == null) continue;
            try {
                builder.addPath(p);
            }
            catch (PathAlreadyDefinedException e) {
                throw new ValidatorException(e.getMessage());
            }
        }
    }

    private Control createGeneralStackLayer(Composite stackComposite) {
        Composite geComposite = new Composite(stackComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        geComposite.setLayout((Layout)layout);
        EditorUtils.createHeaderLabel(geComposite, Messages.general, 2);
        UiUtils.createGridLabel(geComposite, Messages.name_with_colon, 1, 0, 0);
        this.setNameText(UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0));
        UiUtils.createGridLabel(geComposite, Messages.public_with_colon, 1, 0, 0);
        this.setPublicCheck(UiUtils.createCheckButton(geComposite, null, this.isReadOnly(), null));
        UiUtils.createGridLabel(geComposite, Messages.base_path_with_colon, 1, 0, 0);
        this.basePathText = UiUtils.createGridText(geComposite, 1, 0, this.isReadOnly(), 0);
        this.basePathText.addModifyListener((ModifyListener)this.FIELD_LISTENER);
        UiUtils.createEmptyLabel(geComposite);
        UiUtils.createEmptyLabel(geComposite);
        Label label = UiUtils.createGridLabel(geComposite, Messages.paths_with_colon, 1, 0, 0);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        PathsTable phTable = new PathsTable(this.paths, this.isReadOnly());
        phTable.addTableModifyListener(this.FIELD_LISTENER);
        this.pathsEditor = new SimpleTableEditor<PathWrapper>(geComposite, phTable, null, Messages.artifact_path_with_dash, null, null, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.pathsEditor.setLayoutData(gridData);
        geComposite.setData("focusControl", (Object)this.getNameText());
        return geComposite;
    }
}

