/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.IGenerator;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GeneratorBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.AttributeAlreadyDefinedException;
import org.eclipse.buckminster.core.cspec.model.GeneratorAlreadyDefinedException;
import org.eclipse.buckminster.core.ctype.AbstractComponentType;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.parser.IParser;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.core.version.VersionType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.SaveRunnable;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ArtifactType;
import org.eclipse.buckminster.ui.editor.EditorUtils;
import org.eclipse.buckminster.ui.editor.IDerivedEditorInput;
import org.eclipse.buckminster.ui.editor.cspec.ActionsTable;
import org.eclipse.buckminster.ui.editor.cspec.AllAttributesView;
import org.eclipse.buckminster.ui.editor.cspec.ArtifactsTable;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.editor.cspec.DependenciesTable;
import org.eclipse.buckminster.ui.editor.cspec.GeneratorsTable;
import org.eclipse.buckminster.ui.editor.cspec.GroupsTable;
import org.eclipse.buckminster.ui.general.editor.ITableModifyListener;
import org.eclipse.buckminster.ui.general.editor.TableModifyEvent;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableEditor;
import org.eclipse.buckminster.ui.general.editor.structured.FieldModifyEvent;
import org.eclipse.buckminster.ui.general.editor.structured.IActivator;
import org.eclipse.buckminster.ui.general.editor.structured.IFieldModifyListener;
import org.eclipse.buckminster.ui.general.editor.structured.OnePageTableEditor;
import org.eclipse.buckminster.ui.internal.CSpecEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.EditorPart;

public class CSpecEditor
extends EditorPart
implements IEditorMatchingStrategy {
    private static final String SAVEABLE_CSPEC_NAME = "buckminster.cspec";
    private CSpecBuilder cspec;
    private List<ActionBuilder> actionBuilders = new ArrayList<ActionBuilder>();
    private Map<ActionBuilder, List<ActionArtifactBuilder>> actionArtifactBuilders = new HashMap<ActionBuilder, List<ActionArtifactBuilder>>();
    private List<ArtifactBuilder> artifactBuilders = new ArrayList<ArtifactBuilder>();
    private List<GroupBuilder> groupBuilders = new ArrayList<GroupBuilder>();
    private List<ComponentRequestBuilder> dependencyBuilders = new ArrayList<ComponentRequestBuilder>();
    private List<GeneratorBuilder> generatorBuilders = new ArrayList<GeneratorBuilder>();
    private CompoundModifyListener compoundModifyListener;
    private boolean hasChanges = false;
    private boolean mute = false;
    private boolean needsRefresh = false;
    private boolean readOnly = true;
    private CTabFolder tabFolder;
    private CTabItem mainTab;
    private CTabItem actionsTab;
    private CTabItem artifactsTab;
    private CTabItem groupsTab;
    private CTabItem attributesTab;
    private CTabItem dependenciesTab;
    private CTabItem generatorsTab;
    private CTabItem documentationTab;
    private CTabItem xmlTab;
    private Text componentName;
    private Combo componentType;
    private Text versionString;
    private Combo versionType;
    private ActionsTable actionsTable;
    private OnePageTableEditor<ActionBuilder> actionsEditor;
    private OnePageTableEditor<ArtifactBuilder> artifactsEditor;
    private OnePageTableEditor<GroupBuilder> groupsEditor;
    private AllAttributesView attributesView;
    private SimpleTableEditor<ComponentRequestBuilder> dependenciesEditor;
    private SimpleTableEditor<GeneratorBuilder> generatorsEditor;
    private Text shortDesc;
    private Text documentation;
    private Text xml;
    private Button externalSaveAsButton;

    public void createPartControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        topComposite.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(topComposite, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainTab = new CTabItem(this.tabFolder, 0);
        this.mainTab.setText(Messages.main);
        this.mainTab.setControl(this.getMainTabControl(this.tabFolder));
        this.mainTab.setData((Object)CSpecEditorTab.MAIN);
        this.actionsTab = new CTabItem(this.tabFolder, 0);
        this.actionsTab.setText(Messages.actions);
        this.actionsTab.setControl(this.getActionsTabControl((Composite)this.tabFolder));
        this.actionsTab.setData((Object)CSpecEditorTab.ACTIONS);
        this.artifactsTab = new CTabItem(this.tabFolder, 0);
        this.artifactsTab.setText(Messages.artifacts);
        this.artifactsTab.setControl(this.getArtifactsTabControl((Composite)this.tabFolder));
        this.artifactsTab.setData((Object)CSpecEditorTab.ARTIFACTS);
        this.groupsTab = new CTabItem(this.tabFolder, 0);
        this.groupsTab.setText(Messages.groups);
        this.groupsTab.setControl(this.getGroupsTabControl((Composite)this.tabFolder));
        this.groupsTab.setData((Object)CSpecEditorTab.GROUPS);
        this.attributesTab = new CTabItem(this.tabFolder, 0);
        this.attributesTab.setText(Messages.all_attributes);
        this.attributesTab.setControl(this.getAttributesTabControl((Composite)this.tabFolder));
        this.attributesTab.setData((Object)CSpecEditorTab.ATTRIBUTES);
        this.dependenciesTab = new CTabItem(this.tabFolder, 0);
        this.dependenciesTab.setText(Messages.dependencies);
        this.dependenciesTab.setControl(this.getDependenciesTabControl((Composite)this.tabFolder));
        this.dependenciesTab.setData((Object)CSpecEditorTab.DEPENDENCIES);
        this.generatorsTab = new CTabItem(this.tabFolder, 0);
        this.generatorsTab.setText(Messages.generators);
        this.generatorsTab.setControl(this.getGeneratorsTabControl((Composite)this.tabFolder));
        this.generatorsTab.setData((Object)CSpecEditorTab.GENERATORS);
        this.documentationTab = new CTabItem(this.tabFolder, 0);
        this.documentationTab.setText(Messages.documentation);
        this.documentationTab.setControl(this.getDocumentationTabControl((Composite)this.tabFolder));
        this.documentationTab.setData((Object)CSpecEditorTab.DOCUMENTATION);
        this.xmlTab = new CTabItem(this.tabFolder, 0);
        this.xmlTab.setText(Messages.xml_content);
        this.xmlTab.setControl(this.getXMLTabControl((Composite)this.tabFolder));
        this.xmlTab.setData((Object)CSpecEditorTab.XML);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private final IActivator ACTIONS_ACTIVATOR = new IActivator(){

                @Override
                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.ACTIONS);
                }
            };
            private final IActivator ARTIFACTS_ACTIVATOR = new IActivator(){

                @Override
                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.ARTIFACTS);
                }
            };
            private final IActivator GROUPS_ACTIVATOR = new IActivator(){

                @Override
                public void activate() {
                    CSpecEditor.this.switchTab(CSpecEditorTab.GROUPS);
                }
            };
            private CTabItem lastTab;
            {
                this.lastTab = CSpecEditor.this.mainTab;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.lastTab != e.item) {
                    if (this.lastTab == CSpecEditor.this.actionsTab && !CSpecEditor.this.actionsEditor.save(this.ACTIONS_ACTIVATOR)) {
                        return;
                    }
                    if (this.lastTab == CSpecEditor.this.artifactsTab && !CSpecEditor.this.artifactsEditor.save(this.ARTIFACTS_ACTIVATOR)) {
                        return;
                    }
                    if (this.lastTab == CSpecEditor.this.groupsTab && !CSpecEditor.this.groupsEditor.save(this.GROUPS_ACTIVATOR)) {
                        return;
                    }
                }
                if (CSpecEditor.this.mainTab == e.item) {
                    CSpecEditor.this.componentName.setFocus();
                } else if (CSpecEditor.this.actionsTab == e.item) {
                    CSpecEditor.this.actionsEditor.setFocus();
                } else if (CSpecEditor.this.artifactsTab == e.item) {
                    CSpecEditor.this.artifactsEditor.setFocus();
                } else if (CSpecEditor.this.groupsTab == e.item) {
                    CSpecEditor.this.groupsEditor.setFocus();
                } else if (CSpecEditor.this.attributesTab == e.item) {
                    CSpecEditor.this.attributesView.setFocus();
                } else if (CSpecEditor.this.dependenciesTab == e.item) {
                    CSpecEditor.this.dependenciesEditor.setFocus();
                } else if (CSpecEditor.this.generatorsTab == e.item) {
                    CSpecEditor.this.generatorsEditor.setFocus();
                } else if (CSpecEditor.this.documentationTab == e.item) {
                    CSpecEditor.this.shortDesc.setFocus();
                } else if (CSpecEditor.this.xmlTab == e.item) {
                    if (!CSpecEditor.this.commitChanges()) {
                        MessageDialog.openWarning((Shell)CSpecEditor.this.getSite().getShell(), null, (String)Messages.xml_content_was_not_updated_due_to_errors);
                    } else {
                        CSpecEditor.this.xml.setText(CSpecEditor.this.getCSpecXML());
                    }
                }
                this.lastTab = (CTabItem)e.item;
            }
        });
        this.createActionButtons(topComposite);
    }

    public void doExternalSaveAs() {
        if (!this.commitChanges()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.cspec"});
        String location = dlg.open();
        if (location == null) {
            return;
        }
        this.saveToPath((IPath)new Path(location));
    }

    public void doSave(IProgressMonitor monitor) {
        if (!this.commitChanges()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath((Object)input) : ((IPathEditorInput)input).getPath();
        this.saveToPath(path);
    }

    public void doSaveAs() {
        IFile original;
        if (!this.commitChanges()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return;
        }
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        if (dialog.open() == 1) {
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        this.saveToPath(file.getLocation());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ILocationProvider || input instanceof IPathEditorInput || input instanceof IURIEditorInput || input instanceof CSpecEditorInput)) {
            throw new PartInitException(Messages.invalid_input);
        }
        this.setSite((IWorkbenchPartSite)site);
        if (input instanceof IURIEditorInput) {
            try {
                input = EditorUtils.getExternalFileEditorInput((IURIEditorInput)input, ArtifactType.CSPEC);
            }
            catch (Exception e) {
                throw new PartInitException(Messages.unable_to_open_editor, (Throwable)e);
            }
        }
        FileInputStream stream = null;
        try {
            try {
                this.cspec = new CSpecBuilder();
                if (input instanceof CSpecEditorInput) {
                    this.readOnly = true;
                    this.cspec.initFrom(((CSpecEditorInput)input).getCSpec());
                } else {
                    IPath path = input instanceof ILocationProvider ? ((ILocationProvider)input).getPath(input) : ((IPathEditorInput)input).getPath();
                    this.readOnly = !SAVEABLE_CSPEC_NAME.equalsIgnoreCase(path.lastSegment());
                    File file = path.toFile();
                    if (file.length() != 0L) {
                        String systemId = file.toString();
                        stream = new FileInputStream(file);
                        IParser parser = CorePlugin.getDefault().getParserFactory().getCSpecParser(true);
                        this.cspec.initFrom((ICSpecData)parser.parse(systemId, (InputStream)stream));
                    }
                }
                this.needsRefresh = true;
                if (this.componentName != null) {
                    this.refreshValues();
                }
                this.setInputWithNotify((IEditorInput)input);
                this.setPartName(String.valueOf(input.getName()) + (this.readOnly ? Messages.read_only_in_paranthesis : ""));
            }
            catch (Exception e) {
                throw new PartInitException(BuckminsterException.wrap((Throwable)e).getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(stream);
            throw throwable;
        }
        IOUtils.close((Closeable)stream);
        this.compoundModifyListener = new CompoundModifyListener();
    }

    public boolean isDirty() {
        return this.hasChanges;
    }

    public boolean isSaveAsAllowed() {
        return !this.readOnly;
    }

    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        IEditorPart part = (IEditorPart)editorRef.getPart(false);
        if (part != null && (editorInput = part.getEditorInput()) != null) {
            IEditorInput originalEditorInput;
            if (editorInput.equals(input)) {
                return true;
            }
            if (editorInput instanceof IDerivedEditorInput && (originalEditorInput = ((IDerivedEditorInput)editorInput).getOriginalInput()).equals(input)) {
                return true;
            }
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.componentName.setEnabled(enabled);
        this.componentType.setEnabled(enabled);
        this.versionString.setEnabled(enabled);
        this.versionType.setEnabled(enabled);
        this.actionsEditor.setEnabled(enabled);
        this.artifactsEditor.setEnabled(enabled);
        this.groupsEditor.setEnabled(enabled);
        this.dependenciesEditor.setEnabled(enabled);
        this.generatorsEditor.setEnabled(enabled);
        this.shortDesc.setEnabled(enabled);
        this.documentation.setEnabled(enabled);
    }

    public void setFocus() {
        this.tabFolder.setFocus();
        if (this.needsRefresh) {
            this.refreshValues();
        }
    }

    Map<ActionBuilder, List<ActionArtifactBuilder>> getActionArtifactBuilders() {
        return this.actionArtifactBuilders;
    }

    List<ActionBuilder> getActionBuilders() {
        return this.actionBuilders;
    }

    OnePageTableEditor<ActionBuilder> getActionsEditor() {
        return this.actionsEditor;
    }

    ActionsTable getActionsTable() {
        return this.actionsTable;
    }

    List<ArtifactBuilder> getArtifactBuilders() {
        return this.artifactBuilders;
    }

    OnePageTableEditor<ArtifactBuilder> getArtifactsEditor() {
        return this.artifactsEditor;
    }

    String[] getAttributeNames(String excludeName) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (ActionBuilder actionBuilder : this.actionBuilders) {
            if (actionBuilder.getName() == null) continue;
            nameList.add(actionBuilder.getName());
        }
        for (List list : this.actionArtifactBuilders.values()) {
            for (ActionArtifactBuilder builder : list) {
                nameList.add(builder.getName());
            }
        }
        for (ArtifactBuilder artifactBuilder : this.artifactBuilders) {
            if (artifactBuilder.getName() == null) continue;
            nameList.add(artifactBuilder.getName());
        }
        for (GroupBuilder groupBuilder : this.groupBuilders) {
            if (groupBuilder.getName() == null) continue;
            nameList.add(groupBuilder.getName());
        }
        if (excludeName != null) {
            nameList.remove(excludeName);
        }
        String[] stringArray = nameList.toArray(new String[0]);
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return stringArray;
    }

    String[] getComponentNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ComponentRequestBuilder builder : this.dependencyBuilders) {
            if (builder.getName() == null) continue;
            list.add(builder.getName());
        }
        String[] array = list.toArray(new String[0]);
        Arrays.sort(array, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return array;
    }

    ComponentRequestBuilder getDependencyBuilder(String cname, String ctype, String rangeStr) {
        ctype = TextUtils.notEmptyString((String)cname);
        if (cname == null) {
            return null;
        }
        ctype = TextUtils.notEmptyString((String)ctype);
        VersionRange range = (rangeStr = TextUtils.notEmptyString((String)rangeStr)) == null ? null : new VersionRange(rangeStr);
        for (ComponentRequestBuilder builder : this.dependencyBuilders) {
            if (!cname.equals(builder.getName()) || ctype != null && !ctype.equals(builder.getComponentTypeID()) || range != null && !range.equals((Object)builder.getVersionRange())) continue;
            return builder;
        }
        return null;
    }

    List<ComponentRequestBuilder> getDependencyBuilders() {
        return this.dependencyBuilders;
    }

    List<GeneratorBuilder> getGeneratorBuilders() {
        return this.generatorBuilders;
    }

    List<GroupBuilder> getGroupBuilders() {
        return this.groupBuilders;
    }

    OnePageTableEditor<GroupBuilder> getGroupsEditor() {
        return this.groupsEditor;
    }

    void switchTab(CSpecEditorTab tab) {
        this.tabFolder.setSelection(tab.getSeqNum());
    }

    private void addToActionArtifactBuilderMap(ActionArtifactBuilder actionArtifactbuilder) {
        if (actionArtifactbuilder.getActionName() == null) {
            return;
        }
        ActionBuilder actionBuilder = this.findActionBuilder(actionArtifactbuilder.getActionName());
        if (actionBuilder != null) {
            List<ActionArtifactBuilder> list = this.actionArtifactBuilders.get(actionBuilder);
            if (list == null) {
                list = new ArrayList<ActionArtifactBuilder>();
                this.actionArtifactBuilders.put(actionBuilder, list);
            }
            list.add(actionArtifactbuilder);
        }
    }

    private boolean commitChanges() {
        if (this.actionsEditor.isVisible() && !this.actionsEditor.save()) {
            return false;
        }
        if (this.artifactsEditor.isVisible() && !this.artifactsEditor.save()) {
            return false;
        }
        if (this.groupsEditor.isVisible() && !this.groupsEditor.save()) {
            return false;
        }
        String name = UiUtils.trimmedValue(this.componentName);
        if (name == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)Messages.the_component_must_have_a_name);
            return false;
        }
        this.cspec.setName(name);
        String cType = this.componentType.getItem(this.componentType.getSelectionIndex());
        if (cType.length() == 0) {
            cType = null;
        }
        this.cspec.setComponentTypeID(cType);
        try {
            this.cspec.setVersion(VersionHelper.createVersion((String)this.versionType.getItem(this.versionType.getSelectionIndex()), (String)UiUtils.trimmedValue(this.versionString)));
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            Map attributesMap = this.cspec.getAttributes();
            if (attributesMap != null) {
                attributesMap.clear();
            }
            for (ActionBuilder actionBuilder : this.actionBuilders) {
                this.cspec.addAttribute((IAttribute)actionBuilder);
            }
            for (List list : this.actionArtifactBuilders.values()) {
                for (ActionArtifactBuilder item : list) {
                    this.cspec.addAttribute((IAttribute)item);
                }
            }
            for (ArtifactBuilder artifactBuilder : this.artifactBuilders) {
                this.cspec.addAttribute((IAttribute)artifactBuilder);
            }
            for (GroupBuilder groupBuilder : this.groupBuilders) {
                this.cspec.addAttribute((IAttribute)groupBuilder);
            }
        }
        catch (AttributeAlreadyDefinedException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            List dependencyList = this.cspec.getDependencyBuilders();
            if (dependencyList != null) {
                dependencyList.clear();
            }
            for (ComponentRequestBuilder componentRequestBuilder : this.dependencyBuilders) {
                this.cspec.addDependency((IComponentRequest)componentRequestBuilder);
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        try {
            Collection generators = this.cspec.getGeneratorList();
            if (generators.size() > 0) {
                generators.clear();
            }
            for (GeneratorBuilder generatorBuilder : this.generatorBuilders) {
                this.cspec.addGenerator((IGenerator)generatorBuilder);
            }
        }
        catch (GeneratorAlreadyDefinedException e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)e.getMessage());
            return false;
        }
        String doc = UiUtils.trimmedValue(this.shortDesc);
        this.cspec.setShortDesc(doc);
        doc = UiUtils.trimmedValue(this.documentation);
        try {
            this.cspec.setDocumentation(doc == null ? null : Documentation.parse((String)doc));
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)coreException.getMessage());
            return false;
        }
        try {
            this.cspec.createCSpec().verifyConsistency();
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), null, (String)coreException.getMessage());
            return false;
        }
        return true;
    }

    private void createActionButtons(Composite parent) {
        Composite allButtonsBox = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        allButtonsBox.setLayout((Layout)layout);
        allButtonsBox.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite pressButtonsBox = new Composite(allButtonsBox, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pressButtonsBox.setLayout((Layout)layout);
        pressButtonsBox.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.externalSaveAsButton = UiUtils.createPushButton(pressButtonsBox, Messages.external_save_as, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSpecEditor.this.doExternalSaveAs();
            }
        });
        this.externalSaveAsButton.setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private ActionBuilder findActionBuilder(String actionName) {
        for (ActionBuilder builder : this.actionBuilders) {
            if (!actionName.equals(builder.getName())) continue;
            return builder;
        }
        return null;
    }

    private Control getActionsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.actions);
        ActionsTable table = new ActionsTable(this, this.actionBuilders, this.actionArtifactBuilders, this.cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.compoundModifyListener);
        this.actionsEditor = new OnePageTableEditor<ActionBuilder>(tabComposite, table, false, 0);
        this.actionsTable = table;
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getArtifactsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.artifacts);
        ArtifactsTable table = new ArtifactsTable(this, this.artifactBuilders, this.cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.compoundModifyListener);
        this.artifactsEditor = new OnePageTableEditor<ArtifactBuilder>(tabComposite, table, false, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getAttributesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.all_attributes);
        this.attributesView = new AllAttributesView(tabComposite, 0, this);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private String getCSpecXML() {
        String cspecXML = "";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Utils.serialize((ISaxable)this.cspec.createCSpec(), (OutputStream)baos);
            cspecXML = baos.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cspecXML;
    }

    private Control getDependenciesTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.dependencies);
        DependenciesTable table = new DependenciesTable(this.dependencyBuilders, this.cspec, !this.isSaveAsAllowed());
        table.addTableModifyListener(this.compoundModifyListener);
        this.dependenciesEditor = new SimpleTableEditor<ComponentRequestBuilder>(tabComposite, table, null, Messages.cspec_editor_dependency, null, null, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getDocumentationTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.documentation);
        Composite descComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        descComposite.setLayout((Layout)layout);
        descComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        UiUtils.createGridLabel(descComposite, Messages.short_description_with_colon, 1, 0, 0);
        this.shortDesc = UiUtils.createGridText(descComposite, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.compoundModifyListener);
        Label label = UiUtils.createGridLabel(descComposite, Messages.documentation_with_colon, 1, 0, 0);
        label.setLayoutData((Object)new GridData(4, 1, false, false));
        this.documentation = UiUtils.createGridText(descComposite, 1, 0, (this.isSaveAsAllowed() ? 0 : 8) | 2 | 0x200, this.compoundModifyListener);
        this.documentation.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getGeneratorsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.generators);
        GeneratorsTable table = new GeneratorsTable(this, this.generatorBuilders, this.cspec, !this.isSaveAsAllowed());
        table.addTableModifyListener(this.compoundModifyListener);
        this.generatorsEditor = new SimpleTableEditor<GeneratorBuilder>(tabComposite, table, null, Messages.cspec_editor_generator, null, null, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getGroupsTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.groups);
        GroupsTable table = new GroupsTable(this, this.groupBuilders, this.cspec, !this.isSaveAsAllowed());
        table.addFieldModifyListener(this.compoundModifyListener);
        this.groupsEditor = new OnePageTableEditor<GroupBuilder>(tabComposite, table, false, 0);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getMainTabControl(CTabFolder parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite((Composite)parent, Messages.main);
        Composite nameComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginRight = 8;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = UiUtils.createGridLabel(nameComposite, Messages.component_name_with_colon, 1, 0, 0);
        int labelWidth = label.computeSize((int)-1, (int)-1).x + 5;
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = labelWidth;
        label.setLayoutData((Object)gridData);
        this.componentName = UiUtils.createGridText(nameComposite, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.compoundModifyListener);
        UiUtils.createGridLabel(nameComposite, Messages.component_type_with_colon, 1, 0, 0);
        this.componentType = UiUtils.createGridCombo(nameComposite, 1, 0, !this.isSaveAsAllowed(), null, null, 76);
        this.componentType.setItems(AbstractComponentType.getComponentTypeIDs((boolean)true));
        this.componentType.addModifyListener((ModifyListener)this.compoundModifyListener);
        Group versionGroup = new Group(tabComposite, 0);
        versionGroup.setText(Messages.version);
        layout = new GridLayout(2, false);
        versionGroup.setLayout((Layout)layout);
        versionGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Label versionLabel = UiUtils.createGridLabel((Composite)versionGroup, Messages.version_with_colon, 1, 0, 0);
        gridData = (GridData)versionLabel.getLayoutData();
        gridData.widthHint = labelWidth - layout.marginWidth - 3;
        versionLabel.setLayoutData((Object)gridData);
        this.versionString = UiUtils.createGridText((Composite)versionGroup, 1, 0, this.isSaveAsAllowed() ? 0 : 8, this.compoundModifyListener);
        UiUtils.createGridLabel((Composite)versionGroup, Messages.type_with_colon, 1, 0, 0);
        this.versionType = UiUtils.createGridCombo((Composite)versionGroup, 1, 0, !this.isSaveAsAllowed(), null, null, 76);
        List knownTypes = VersionHelper.getKnownTypes();
        int idx = knownTypes.size();
        String[] versionTypes = new String[idx];
        while (--idx >= 0) {
            versionTypes[idx] = ((VersionType)knownTypes.get(idx)).getId();
        }
        this.versionType.setItems(versionTypes);
        this.versionType.select(this.versionType.indexOf("OSGi"));
        this.versionType.addModifyListener((ModifyListener)this.compoundModifyListener);
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private Control getXMLTabControl(Composite parent) {
        Composite tabComposite = EditorUtils.getNamedTabComposite(parent, Messages.xml_content);
        Composite xmlComposite = new Composite(tabComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        xmlComposite.setLayout((Layout)layout);
        xmlComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.xml = UiUtils.createGridText(xmlComposite, 1, 0, 778, null);
        this.xml.setLayoutData((Object)new GridData(4, 4, true, true));
        return EditorUtils.getOptimizedControl(tabComposite);
    }

    private void refreshValues() {
        this.setDirty(false);
        this.mute = true;
        try {
            int n;
            AttributeBuilder[] attributeBuilderArray;
            this.componentName.setText(TextUtils.notNullString((Object)this.cspec.getName()));
            this.componentType.select(this.componentType.indexOf(TextUtils.notNullString((Object)this.cspec.getComponentTypeID())));
            Version version = this.cspec.getVersion();
            if (version == null) {
                this.versionString.setText("");
                this.versionType.select(this.versionType.indexOf("OSGi"));
            } else {
                this.versionString.setText(TextUtils.notNullString((Object)VersionHelper.getHumanReadable((Version)version)));
                this.versionType.select(this.versionType.indexOf(VersionHelper.getVersionType((Version)version).getId()));
            }
            this.actionBuilders.clear();
            this.actionArtifactBuilders.clear();
            this.artifactBuilders.clear();
            this.groupBuilders.clear();
            Map attributesMap = this.cspec.getAttributes();
            if (attributesMap != null) {
                AttributeBuilder[] builders = attributesMap.values().toArray(new AttributeBuilder[0]);
                Arrays.sort(builders, CSpecEditorUtils.getAttributeComparator());
                ArrayList<ActionArtifactBuilder> tmp_actionArtifactBuilders = new ArrayList<ActionArtifactBuilder>();
                attributeBuilderArray = builders;
                n = builders.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeBuilder attribute = attributeBuilderArray[n2];
                    if (attribute instanceof ActionBuilder) {
                        this.actionBuilders.add((ActionBuilder)attribute);
                    } else if (attribute instanceof ActionArtifactBuilder) {
                        tmp_actionArtifactBuilders.add((ActionArtifactBuilder)attribute);
                    } else if (attribute instanceof ArtifactBuilder) {
                        this.artifactBuilders.add((ArtifactBuilder)attribute);
                    } else if (attribute instanceof GroupBuilder) {
                        this.groupBuilders.add((GroupBuilder)attribute);
                    }
                    ++n2;
                }
                for (ActionArtifactBuilder builder : tmp_actionArtifactBuilders) {
                    this.addToActionArtifactBuilderMap(builder);
                }
            }
            this.dependencyBuilders.clear();
            Collection dependencies = this.cspec.getDependencies();
            if (dependencies != null) {
                ComponentRequestBuilder[] builders = dependencies.toArray(new ComponentRequestBuilder[0]);
                Arrays.sort(builders, CSpecEditorUtils.getComponentComparator());
                attributeBuilderArray = builders;
                n = builders.length;
                int n3 = 0;
                while (n3 < n) {
                    AttributeBuilder dependency = attributeBuilderArray[n3];
                    this.dependencyBuilders.add((ComponentRequestBuilder)dependency);
                    ++n3;
                }
            }
            this.generatorBuilders.clear();
            Collection generatorsSet = this.cspec.getGeneratorList();
            if (generatorsSet != null) {
                GeneratorBuilder[] generators = generatorsSet.toArray(new GeneratorBuilder[0]);
                Arrays.sort(generators, CSpecEditorUtils.getCSpecElementComparator());
                GeneratorBuilder[] generatorBuilderArray = generators;
                int n4 = generators.length;
                n = 0;
                while (n < n4) {
                    GeneratorBuilder generator = generatorBuilderArray[n];
                    this.generatorBuilders.add(generator);
                    ++n;
                }
            }
            this.shortDesc.setText(TextUtils.notNullString((Object)this.cspec.getShortDesc()));
            Documentation doc = this.cspec.getDocumentation();
            this.documentation.setText(TextUtils.notNullString((Object)(doc == null ? "" : doc.toString())));
            this.xml.setText(this.getCSpecXML());
            this.actionsEditor.refresh();
            this.artifactsEditor.refresh();
            this.groupsEditor.refresh();
            this.dependenciesEditor.refresh();
            this.generatorsEditor.refresh();
            this.needsRefresh = false;
        }
        finally {
            this.mute = false;
        }
    }

    private void saveToPath(IPath path) {
        try {
            SaveRunnable sr = new SaveRunnable((ISaxable)this.cspec.createCSpec(), path);
            this.getSite().getWorkbenchWindow().run(true, true, (IRunnableWithProgress)sr);
            this.setInputWithNotify(sr.getSavedInput());
            this.setDirty(false);
            this.setPartName(path.lastSegment());
            this.firePropertyChange(1);
        }
        catch (InvocationTargetException e) {
            CoreException t = BuckminsterException.wrap((Throwable)e);
            String msg = NLS.bind((String)Messages.unable_to_save_file_0, (Object)path);
            CorePlugin.getLogger().error((Throwable)t, msg, new Object[0]);
            ErrorDialog.openError((Shell)this.getSite().getShell(), null, (String)msg, (IStatus)t.getStatus());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setDirty(boolean flag) {
        if (this.readOnly || this.mute || this.hasChanges == flag) {
            return;
        }
        this.hasChanges = flag;
        this.firePropertyChange(257);
    }

    static enum CSpecEditorTab {
        MAIN(0),
        ACTIONS(1),
        ARTIFACTS(2),
        GROUPS(3),
        ATTRIBUTES(4),
        DEPENDENCIES(5),
        GENERATORS(6),
        DOCUMENTATION(6),
        XML(8);

        private int seqNum;

        private CSpecEditorTab(int seqNum) {
            this.seqNum = seqNum;
        }

        public int getSeqNum() {
            return this.seqNum;
        }
    }

    class CompoundModifyListener<T>
    implements ModifyListener,
    ITableModifyListener<T>,
    IFieldModifyListener {
        CompoundModifyListener() {
        }

        @Override
        public void modifyField(FieldModifyEvent e) {
            CSpecEditor.this.setDirty(true);
        }

        @Override
        public void modifyTable(TableModifyEvent<T> e) {
            CSpecEditor.this.setDirty(true);
        }

        public void modifyText(ModifyEvent e) {
            CSpecEditor.this.setDirty(true);
        }
    }
}

