/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.simple.ISimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.SimpleTableRowDialog;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SimpleTableEditor<T>
extends Composite {
    private final ISimpleTable<T> table;
    private final Image windowImage;
    private final String windowTitle;
    private final Image wizardImage;
    private final String helpURL;
    private TableViewer tableViewer;
    private Composite stackButtonComposite;
    private StackLayout stackButtonLayout;
    private Composite editButtonBox;
    private Composite viewButtonBox;
    private Button newButton;
    private Button editButton;
    private Button viewButton;
    private Button removeButton;
    private boolean enabled = true;

    public SimpleTableEditor(Composite parent, ISimpleTable<T> table, Image windowImage, String windowTitle, Image wizardImage, String helpURL, int style) {
        super(parent, style);
        this.table = table;
        this.windowImage = windowImage;
        this.windowTitle = windowTitle;
        this.wizardImage = wizardImage;
        this.helpURL = helpURL;
        this.initComposite();
    }

    public void refresh() {
        this.tableViewer.setInput(this.table);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enableDisableButtonGroup();
    }

    private void createButtonBox(Composite parent) {
        this.stackButtonComposite = new Composite(parent, 0);
        this.stackButtonComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.stackButtonLayout = new StackLayout();
        this.stackButtonLayout.marginWidth = 0;
        this.stackButtonLayout.marginHeight = 0;
        this.stackButtonComposite.setLayout((Layout)this.stackButtonLayout);
        this.editButtonBox = new Composite(this.stackButtonComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.editButtonBox.setLayout((Layout)gridLayout);
        this.editButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.newButton = UiUtils.createPushButton(this.editButtonBox, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.newRow();
            }
        });
        this.newButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.editButton = UiUtils.createPushButton(this.editButtonBox, Messages.edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.editRow(false);
            }
        });
        this.editButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.removeButton = UiUtils.createPushButton(this.editButtonBox, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.removeRow();
            }
        });
        this.removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.viewButtonBox = new Composite(this.stackButtonComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.viewButtonBox.setLayout((Layout)gridLayout);
        this.viewButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.viewButton = UiUtils.createPushButton(this.viewButtonBox, Messages.view, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleTableEditor.this.editRow(true);
            }
        });
        this.viewButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.enableDisableButtonGroup();
    }

    private void editRow(boolean readOnly) {
        SimpleTableRowDialog<T> dialog = new SimpleTableRowDialog<T>(this.getShell(), this.windowImage, this.windowTitle, this.wizardImage, this.helpURL, this.table, this.tableViewer.getTable().getSelectionIndex(), readOnly);
        if (dialog.open() == 0) {
            this.refresh();
        }
    }

    private void enableDisableButtonGroup() {
        boolean rowSelected;
        boolean bl = rowSelected = this.tableViewer.getTable().getSelectionIndex() >= 0;
        if (this.enabled && !this.table.isReadOnly()) {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(rowSelected);
            this.removeButton.setEnabled(rowSelected);
            this.stackButtonLayout.topControl = this.editButtonBox;
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.stackButtonLayout.topControl = this.viewButtonBox;
        }
        this.viewButton.setEnabled(rowSelected);
        this.stackButtonComposite.layout();
    }

    private void initComposite() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Table tbl = new Table((Composite)this, 68356);
        tbl.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int tableIdx = 0;
        int idx = 0;
        while (idx < this.table.getColumns()) {
            if (this.table.getColumnWeights()[idx] > 0) {
                TableColumn tableColumn = new TableColumn(tbl, 16384, tableIdx);
                tableColumn.setText(this.table.getColumnHeaders()[idx]);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.table.getColumnWeights()[idx], true));
                ++tableIdx;
            }
            ++idx;
        }
        tbl.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        tbl.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(tbl);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setInput(this.table);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SimpleTableEditor.this.enableDisableButtonGroup();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SimpleTableEditor.this.tableViewer.getTable().getSelectionIndex() >= 0) {
                    SimpleTableEditor.this.editRow(!SimpleTableEditor.this.enabled || SimpleTableEditor.this.table.isReadOnly());
                }
            }
        });
        this.createButtonBox(this);
    }

    private void newRow() {
        SimpleTableRowDialog<T> dialog = new SimpleTableRowDialog<T>(this.getShell(), this.windowImage, this.windowTitle, this.wizardImage, this.helpURL, this.table, -1, false);
        if (dialog.open() == 0) {
            this.refresh();
        }
    }

    private void removeRow() {
        this.table.removeRow(this.tableViewer.getTable().getSelectionIndex());
        this.refresh();
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return SimpleTableEditor.this.table.getRows().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object field = SimpleTableEditor.this.table.getEditorField(element, columnIndex);
            return field == null ? "" : field.toString();
        }
    }
}

