/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import java.util.Arrays;
import org.eclipse.buckminster.ui.general.editor.TableRowDialog;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.simple.ISimpleTable;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SimpleTableRowDialog<T>
extends TableRowDialog {
    private final ISimpleTable<T> table;
    private final int row;
    private final boolean newRow;
    private IWidgetin[] widgetins;

    public SimpleTableRowDialog(Shell parent, Image windowImage, String windowTitle, Image wizardImage, String helpURL, ISimpleTable<T> table, int row, boolean readOnly) {
        super(parent, windowImage, windowTitle, wizardImage, helpURL, row == -1, readOnly);
        this.table = table;
        this.row = row;
        this.newRow = row == -1;
        this.widgetins = new IWidgetin[table.getColumns()];
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] fields = new Object[this.table.getColumns()];
            int i = 0;
            while (i < this.table.getColumns()) {
                fields[i] = this.widgetins[i].getData();
                ++i;
            }
            try {
                if (this.newRow) {
                    this.table.addRow(fields);
                } else {
                    this.table.setRow(this.row, fields);
                }
            }
            catch (ValidatorException e) {
                this.setErrorMessage(e.getMessage());
                this.getButton(0).setEnabled(false);
                return;
            }
        }
        this.setReturnCode(buttonId);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Listener rowModifyListener = new Listener(){

            public void handleEvent(Event event) {
                SimpleTableRowDialog.this.setErrorMessage(event.text);
                SimpleTableRowDialog.this.enableDisableOkButton();
            }
        };
        Composite textComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 7;
        layout.marginWidth = 10;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(768));
        Object[] fields = null;
        if (!this.newRow) {
            fields = this.table.toRowArray(this.table.getRow(this.row));
        } else {
            fields = new Object[this.table.getColumns()];
            Arrays.fill(fields, null);
        }
        this.widgetins = this.table.fillGrid(textComposite, fields);
        int i = 0;
        while (i < this.table.getColumns()) {
            this.widgetins[i].addListener(954814, rowModifyListener);
            ++i;
        }
        return textComposite;
    }

    @Override
    protected void enableDisableOkButton() {
        if (this.getButton(0) != null) {
            boolean valid = true;
            try {
                int i = 0;
                while (i < this.table.getColumns()) {
                    this.table.getFieldValidator(i).validate(this.widgetins[i].getData());
                    ++i;
                }
            }
            catch (ValidatorException e1) {
                valid = false;
            }
            this.getButton(0).setEnabled(valid);
        }
    }
}

