/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.ui.general.editor.simple.IWidgetin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Widgetin
implements IWidgetin {
    private Object data = null;
    private final Map<Integer, List<Listener>> listenersMap = new HashMap<Integer, List<Listener>>();

    @Override
    public void addListener(int eventType, Listener listener) {
        List<Listener> eventListeners = this.listenersMap.get(eventType);
        if (eventListeners == null) {
            eventListeners = new ArrayList<Listener>();
            this.listenersMap.put(eventType, eventListeners);
        }
        if (!eventListeners.contains(listener)) {
            eventListeners.add(listener);
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void notifyListeners(int eventType, Event event) {
        List<Listener> eventListeners = this.listenersMap.get(eventType);
        if (eventListeners != null) {
            for (Listener listener : eventListeners) {
                listener.handleEvent(event);
            }
        }
    }

    @Override
    public void removeListener(int eventType, Listener listener) {
        this.listenersMap.remove(eventType);
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }
}

