/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import org.eclipse.buckminster.core.cspec.ICSpecData;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.version.VersionHelper;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.ui.internal.SaxableEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.Version;

public class CSpecEditorInput
extends SaxableEditorInput {
    private final CSpec cspec;

    public CSpecEditorInput(CSpec cspec) {
        this.cspec = cspec;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof CSpecEditorInput && ((CSpecEditorInput)other).cspec.equals((Object)this.cspec);
    }

    public boolean exists() {
        return true;
    }

    public ICSpecData getCSpec() {
        return this.cspec;
    }

    public String getName() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.cspec.getName());
        Version version = this.cspec.getVersion();
        if (version != null) {
            bld.append(':');
            bld.append(VersionHelper.getHumanReadable((Version)version));
        }
        bld.append(".cspec");
        return bld.toString();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public int hashCode() {
        return this.cspec.hashCode();
    }

    @Override
    protected ISaxable getContent() throws CoreException {
        return this.cspec;
    }
}

