/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.buckminster.model.common.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.PropertyElement;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;

/**
 * This is the item provider adapter for a
 * {@link org.eclipse.buckminster.model.common.PropertyElement} object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class PropertyElementItemProvider extends PropertyItemProvider implements IEditingDomainItemProvider, IStructuredItemContentProvider,
		ITreeItemContentProvider, IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public PropertyElementItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to
	 * deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand},
	 * {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in
	 * {@link #createCommand}. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__CONSTANT);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__FORMAT);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__PROPERTY_REF);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__REPLACE);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__TO_LOWER);
			childrenFeatures.add(CommonPackage.Literals.PROPERTY_ELEMENT__TO_UPPER);
		}
		return childrenFeatures;
	}

	/**
	 * This returns PropertyElement.gif. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/PropertyElement"));
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

		}
		return itemPropertyDescriptors;
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((PropertyElement) object).getKey();
		return label == null || label.length() == 0 ? getString("_UI_PropertyElement_type") : getString("_UI_PropertyElement_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to
	 * update any cached children and by creating a viewer notification, which
	 * it passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(PropertyElement.class)) {
			case CommonPackage.PROPERTY_ELEMENT__CONSTANT:
			case CommonPackage.PROPERTY_ELEMENT__FORMAT:
			case CommonPackage.PROPERTY_ELEMENT__PROPERTY_REF:
			case CommonPackage.PROPERTY_ELEMENT__REPLACE:
			case CommonPackage.PROPERTY_ELEMENT__TO_LOWER:
			case CommonPackage.PROPERTY_ELEMENT__TO_UPPER:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing the children that can be created under this object. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__CONSTANT, CommonFactory.eINSTANCE.createConstant()));

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__FORMAT, CommonFactory.eINSTANCE.createFormat()));

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__PROPERTY_REF, CommonFactory.eINSTANCE
				.createPropertyRef()));

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__REPLACE, CommonFactory.eINSTANCE.createReplace()));

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__TO_LOWER, CommonFactory.eINSTANCE.createToLower()));

		newChildDescriptors.add(createChildParameter(CommonPackage.Literals.PROPERTY_ELEMENT__TO_UPPER, CommonFactory.eINSTANCE.createToUpper()));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper
		// feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

}
