/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.examples.api.script;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.log.impl.DefaultLoggerImpl;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class JavaViewer implements PaintListener, SelectionListener
{
	private IDeviceRenderer idr = null;
	private Chart cm = null;
	private Canvas ca = null;
	private Combo cb = null;
	private IExternalContext ec = null;
	private transient static Label description = null;

	/**
	 * Execute application
	 * 
	 * @param args
	 */
	public static void main( String[] args )
	{

		JavaViewer jViewer = new JavaViewer( );
		Display d = Display.getDefault( );
		Shell sh = new Shell( Display.getDefault( ) );
		sh.setSize( 500, 400 );
		sh.setLayout( new GridLayout( ) );
		sh.setText( jViewer.getClass( ).getName( ) + " [device="//$NON-NLS-1$
				+ jViewer.idr.getClass( ).getName( ) + "]" );//$NON-NLS-1$

		Canvas cCenter = new Canvas( sh, SWT.NONE );
		cCenter.setLayoutData( new GridData( GridData.FILL_BOTH ) );
		cCenter.addPaintListener( jViewer );

		description = new Label( sh, SWT.NONE );
		description.setLayoutData( new GridData( GridData.FILL_HORIZONTAL ) );
		description.setText( "beforeDrawAxisLabel( Axis, Label, IChartScriptContext )" //$NON-NLS-1$
				+ "\nbeforeDrawAxisTitle( Axis, Label, IChartScriptContext )" ); //$NON-NLS-1$

		Composite choicePanel = new Composite( sh, SWT.NONE );
		choicePanel.setLayoutData( new GridData( GridData.FILL_HORIZONTAL ) );
		choicePanel.setLayout( new RowLayout( ) );

		Label la = new Label( choicePanel, SWT.NONE );
		la.setText( "Choose Scope: " );//$NON-NLS-1$

		Combo cbType = new Combo( choicePanel, SWT.DROP_DOWN | SWT.READ_ONLY );
		cbType.add( "Axis" );//$NON-NLS-1$
		cbType.add( "DataPoints" );//$NON-NLS-1$
		cbType.add( "Marker" );//$NON-NLS-1$
		cbType.add( "Series" );//$NON-NLS-1$
		cbType.add( "Series Title" ); //$NON-NLS-1$
		cbType.add( "Block" );//$NON-NLS-1$
		cbType.add( "Legend" ); //$NON-NLS-1$
		cbType.select( 0 );

		Button btn = new Button( choicePanel, SWT.NONE );
		btn.setText( "Update" );//$NON-NLS-1$
		btn.addSelectionListener( jViewer );

		jViewer.cb = cbType;
		jViewer.ca = cCenter;

		sh.open( );

		while ( !sh.isDisposed( ) )
		{
			if ( !d.readAndDispatch( ) )
			{
				d.sleep( );
			}
		}
	}

	/**
	 * Constructor
	 */
	JavaViewer( )
	{
		final PluginSettings ps = PluginSettings.instance( );
		try
		{
			idr = ps.getDevice( "dv.SWT" );//$NON-NLS-1$
		}
		catch ( ChartException pex )
		{
			DefaultLoggerImpl.instance( ).log( pex );
		}
		cm = ScriptCharts.createJChart_Axis( );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.PaintListener#paintControl(org.eclipse.swt.events.PaintEvent)
	 */
	public final void paintControl( PaintEvent pe )
	{
		idr.setProperty( IDeviceRenderer.GRAPHICS_CONTEXT, pe.gc );

		Composite co = (Composite) pe.getSource( );
		Rectangle re = co.getClientArea( );
		Bounds bo = BoundsImpl.create( re.x, re.y, re.width, re.height );
		bo.scale( 72d / idr.getDisplayServer( ).getDpiResolution( ) );

		Generator gr = Generator.instance( );
		try
		{
			gr.render( idr, gr.build( idr.getDisplayServer( ),
					cm,
					bo,
					ec,
					null,
					null ) );
		}
		catch ( ChartException gex )
		{
			showException( pe.gc, gex );
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected( SelectionEvent e )
	{
		int iSelection = cb.getSelectionIndex( );
		switch ( iSelection )
		{
			case 0 :
				cm = ScriptCharts.createJChart_Axis( );
				description.setText( "beforeDrawAxisLabel( Axis, Label, IChartScriptContext )" //$NON-NLS-1$
						+ "\nbeforeDrawAxisTitle( Axis, Label, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 1 :
				cm = ScriptCharts.createJChart_DataPoints( );
				description.setText( "beforeDrawDataPointLabel( DataPointHint, Label, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 2 :
				cm = ScriptCharts.createJChart_Marker( );
				description.setText( "beforeDrawMarkerLine( Axis, MarkerLine, IChartScriptContext )" //$NON-NLS-1$
						+ "\nbeforeDrawMarkerRange( Axis, MarkerRange, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 3 :
				cm = ScriptCharts.createJChart_Series( );
				description.setText( "beforeDrawSeries( Series, ISeriesRenderer, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 4 :
				cm = ScriptCharts.createJChart_SeriesTitle( );
				description.setText( "beforeDrawSeriesTitle( Series, Label, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 5 :
				cm = ScriptCharts.createJChart_Block( );
				description.setText( "beforeDrawBlock( Block, IChartScriptContext )" ); //$NON-NLS-1$
				break;
			case 6 :
				cm = ScriptCharts.createJChart_Legend( );
				description.setText( "beforeDrawLegendEntry( Label, IChartScriptContext )" ); //$NON-NLS-1$
				break;
		}
		ca.redraw( );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected( SelectionEvent e )
	{
		// TODO Auto-generated method stub
	}

	private final void showException( GC g2d, Exception ex )
	{
		String sWrappedException = ex.getClass( ).getName( );
		Throwable th = ex;
		while ( ex.getCause( ) != null )
		{
			ex = (Exception) ex.getCause( );
		}
		String sException = ex.getClass( ).getName( );
		if ( sWrappedException.equals( sException ) )
		{
			sWrappedException = null;
		}

		String sMessage = null;
		if ( th instanceof BirtException )
		{
			sMessage = ( (BirtException) th ).getLocalizedMessage( );
		}
		else
		{
			sMessage = ex.getMessage( );
		}

		if ( sMessage == null )
		{
			sMessage = "<null>";//$NON-NLS-1$
		}
		StackTraceElement[] stea = ex.getStackTrace( );
		Point d = ca.getSize( );

		Device dv = Display.getCurrent( );
		Font fo = new Font( dv, "Courier", SWT.BOLD, 16 );//$NON-NLS-1$
		g2d.setFont( fo );
		FontMetrics fm = g2d.getFontMetrics( );
		g2d.setBackground( dv.getSystemColor( SWT.COLOR_WHITE ) );
		g2d.fillRectangle( 20, 20, d.x - 40, d.y - 40 );
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_BLACK ) );
		g2d.drawRectangle( 20, 20, d.x - 40, d.y - 40 );
		g2d.setClipping( 20, 20, d.x - 40, d.y - 40 );
		int x = 25, y = 20 + fm.getHeight( );
		g2d.drawString( "Exception:", x, y );//$NON-NLS-1$
		x += g2d.textExtent( "Exception:" ).x + 5;//$NON-NLS-1$
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_RED ) );
		g2d.drawString( sException, x, y );
		x = 25;
		y += fm.getHeight( );
		if ( sWrappedException != null )
		{
			g2d.setForeground( dv.getSystemColor( SWT.COLOR_BLACK ) );
			g2d.drawString( "Wrapped In:", x, y );//$NON-NLS-1$
			x += g2d.textExtent( "Wrapped In:" ).x + 5;//$NON-NLS-1$
			g2d.setForeground( dv.getSystemColor( SWT.COLOR_RED ) );
			g2d.drawString( sWrappedException, x, y );
			x = 25;
			y += fm.getHeight( );
		}
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_BLACK ) );
		y += 10;
		g2d.drawString( "Message:", x, y );//$NON-NLS-1$
		x += g2d.textExtent( "Message:" ).x + 5;//$NON-NLS-1$
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_BLUE ) );
		g2d.drawString( sMessage, x, y );
		x = 25;
		y += fm.getHeight( );
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_BLACK ) );
		y += 10;
		g2d.drawString( "Trace:", x, y );//$NON-NLS-1$
		x = 40;
		y += fm.getHeight( );
		g2d.setForeground( dv.getSystemColor( SWT.COLOR_DARK_GREEN ) );
		for ( int i = 0; i < stea.length; i++ )
		{
			g2d.drawString( stea[i].getClassName( ) + ":"//$NON-NLS-1$
					+ stea[i].getMethodName( ) + "(...):"//$NON-NLS-1$
					+ stea[i].getLineNumber( ), x, y );
			x = 40;
			y += fm.getHeight( );
		}
		fo.dispose( );
	}
}
