package com.samplereport;

import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.element.IAction;
import org.eclipse.birt.report.engine.api.script.element.ILabel;
import org.eclipse.birt.report.engine.api.script.element.IScriptStyleDesign;
import org.eclipse.birt.report.engine.api.script.eventadapter.LabelEventAdapter;

public class HeaderLinkStyle extends LabelEventAdapter
{
	public void onPrepare( ILabel label, IReportContext reportContext )
	{
		try {
			IAction action = label.getAction( );
			action.setLinkType( "drill-through" );
			action.setReportName( "SampleReport2.rptdesign" );
			action.setTargetWindow( "target" );
			action.setFormatType( "pdf" );
			
			System.out.println( action.getFormatType( ) );
			IScriptStyleDesign styleDesign = label.getStyle( );
			styleDesign.setColor( "rgb(0,64,128)" );
			styleDesign.setFontFamily( "arial" );
			styleDesign.setFontSize( "smaller" );
			styleDesign.setFontStyle( "italic" );
			styleDesign.setFontWeight( "bold" );
			styleDesign.setDisplay( "inline" );
		} catch ( Exception e ) {
			e.printStackTrace( );
		}
	}
}