package com.samplereport;

import org.eclipse.birt.report.engine.api.script.IRowData;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.eventadapter.RowEventAdapter;
import org.eclipse.birt.report.engine.api.script.instance.IRowInstance;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;

public class RowStyle extends RowEventAdapter
{
	public void onCreate( IRowInstance rowInstance, IReportContext reportContext )
	{
		try {
			IRowData rowData = rowInstance.getRowData( );
			IScriptStyle scriptStyle = rowInstance.getStyle( );
			String status = ( String ) rowData.getExpressionValue( 1 );
			if ( status.equals( "Total $ Amount of On-Time Orders: " ) ) {
				scriptStyle.setColor( "#0000FF" );
			} else {
				scriptStyle.setColor( "#FF0000" );
			}
		} catch ( Exception e ) {
			e.printStackTrace( );
		}
	}
}