/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser.typehierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.TypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;

public class ChangeCollector {
    HashMap changes = new HashMap();
    TypeHierarchy hierarchy;

    public ChangeCollector(TypeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    private void addAffectedChildren(ICElementDelta delta) throws CModelException {
    }

    public void addChange(ITranslationUnit cu, ICElementDelta newDelta) throws CModelException {
    }

    private void addChange(IMember member, ICElementDelta newDelta) throws CModelException {
    }

    private void addChange(ICElement type, ICElementDelta newDelta) throws CModelException {
    }

    private void getAllTypesFromElement(ICElement element, ArrayList allTypes) throws CModelException {
        switch (element.getElementType()) {
            case 60: {
                ICElement[] types = TypeUtil.getTypes((ITranslationUnit)element);
                int i = 0;
                int length = types.length;
                while (i < length) {
                    ICElement type = types[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                    ++i;
                }
                break;
            }
            case 65: 
            case 67: {
                ICElement[] types = TypeUtil.getTypes(element);
                int i = 0;
                int length = types.length;
                while (i < length) {
                    ICElement type = types[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                    ++i;
                }
                break;
            }
            case 70: {
                if (!(element instanceof IParent)) break;
                ICElement[] children = ((IParent)((Object)element)).getChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    ICElement type = children[i];
                    allTypes.add(type);
                    this.getAllTypesFromElement(type, allTypes);
                    ++i;
                }
                break;
            }
        }
    }

    private void getAllTypesFromHierarchy(CElement element, ArrayList allTypes) {
        switch (element.getElementType()) {
            case 60: {
                ArrayList types = (ArrayList)this.hierarchy.files.get(element);
                if (types == null) break;
                allTypes.addAll(types);
                break;
            }
            case 65: 
            case 67: 
            case 70: {
                ArrayList types = (ArrayList)this.hierarchy.files.get(((IMember)((Object)element)).getTranslationUnit());
                if (types == null) break;
                int i = 0;
                int length = types.size();
                while (i < length) {
                    ICElement type = (ICElement)types.get(i);
                    if (element.isAncestorOf(type)) {
                        allTypes.add(type);
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private boolean hasSuperTypeChange(ICElement type) throws CModelException {
        return false;
    }

    private boolean hasVisibilityChange(ICElement type) throws CModelException {
        return false;
    }

    public boolean needsRefresh() {
        return this.changes.size() != 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.changes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            buffer.append(((CElement)entry.getKey()).toDebugString());
            buffer.append(entry.getValue());
            if (!iterator.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

