/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.browser.typehierarchy;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchyChangedListener;
import org.eclipse.cdt.core.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;

public class TypeHierarchy
implements ITypeHierarchy,
IElementChangedListener {
    public static boolean DEBUG = false;
    private static final int INITIAL_SUPER_TYPES = 1;
    private static final int INITIAL_SUB_TYPES = 1;
    private static final ITypeInfo[] NO_TYPES = new ITypeInfo[0];
    private ArrayList fRootTypes = new ArrayList();
    private Map fTypeToSuperTypes = new HashMap();
    private Map fTypeToSubTypes = new HashMap();
    private ITypeInfo fFocusType;
    protected IProgressMonitor fProgressMonitor = null;
    protected ArrayList fChangeListeners = null;
    public Map files = null;
    protected boolean fComputeSubtypes;
    ICSearchScope fScope;
    public boolean fNeedsRefresh = true;

    public TypeHierarchy(ITypeInfo type) {
        this.fFocusType = type;
    }

    public void addRootType(ITypeInfo type) {
        if (!this.fRootTypes.contains(type)) {
            this.fRootTypes.add(type);
        }
    }

    public void addSuperType(ITypeInfo type, ITypeInfo superType, ASTAccessVisibility access) {
        ArrayList<ITypeInfo> subTypes;
        ArrayList<TypeEntry> superEntries = (ArrayList<TypeEntry>)this.fTypeToSuperTypes.get(type);
        if (superEntries == null) {
            superEntries = new ArrayList<TypeEntry>(1);
            this.fTypeToSuperTypes.put(type, superEntries);
        }
        if ((subTypes = (ArrayList<ITypeInfo>)this.fTypeToSubTypes.get(superType)) == null) {
            subTypes = new ArrayList<ITypeInfo>(1);
            this.fTypeToSubTypes.put(superType, subTypes);
        }
        if (!subTypes.contains(type)) {
            subTypes.add(type);
        }
        Iterator i = superEntries.iterator();
        while (i.hasNext()) {
            TypeEntry entry = (TypeEntry)i.next();
            if (!entry.type.equals(superType)) continue;
            entry.access = access;
            return;
        }
        TypeEntry typeEntry = new TypeEntry(superType, access);
        superEntries.add(typeEntry);
    }

    protected void addSubType(ITypeInfo type, ITypeInfo subType) {
        ArrayList<TypeEntry> superEntries;
        ArrayList<ITypeInfo> subTypes = (ArrayList<ITypeInfo>)this.fTypeToSubTypes.get(type);
        if (subTypes == null) {
            subTypes = new ArrayList<ITypeInfo>(1);
            this.fTypeToSubTypes.put(type, subTypes);
        }
        if (!subTypes.contains(subType)) {
            subTypes.add(subType);
        }
        if ((superEntries = (ArrayList<TypeEntry>)this.fTypeToSuperTypes.get(subType)) == null) {
            superEntries = new ArrayList<TypeEntry>(1);
            this.fTypeToSuperTypes.put(subType, superEntries);
        }
        Iterator i = superEntries.iterator();
        while (i.hasNext()) {
            TypeEntry entry = (TypeEntry)i.next();
            if (!entry.type.equals(type)) continue;
            return;
        }
        TypeEntry typeEntry = new TypeEntry(type, ASTAccessVisibility.PRIVATE);
        superEntries.add(typeEntry);
    }

    public boolean hasSuperType(ITypeInfo type, ITypeInfo superType) {
        Collection entries = (Collection)this.fTypeToSuperTypes.get(type);
        if (entries != null) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                TypeEntry entry = (TypeEntry)i.next();
                if (!entry.type.equals(superType)) continue;
                return true;
            }
        }
        return false;
    }

    public ITypeInfo[] getSuperTypes(ITypeInfo type) {
        Collection entries = (Collection)this.fTypeToSuperTypes.get(type);
        if (entries != null) {
            ArrayList<ITypeInfo> superTypes = new ArrayList<ITypeInfo>(1);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                TypeEntry entry = (TypeEntry)i.next();
                superTypes.add(entry.type);
            }
            return superTypes.toArray(new ITypeInfo[superTypes.size()]);
        }
        return NO_TYPES;
    }

    public ITypeInfo[] getSubTypes(ITypeInfo type) {
        Collection subTypes = (Collection)this.fTypeToSubTypes.get(type);
        if (subTypes != null) {
            return subTypes.toArray(new ITypeInfo[subTypes.size()]);
        }
        return NO_TYPES;
    }

    public void addTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList<ITypeHierarchyChangedListener> listeners = this.fChangeListeners;
        if (listeners == null) {
            this.fChangeListeners = listeners = new ArrayList<ITypeHierarchyChangedListener>();
        }
        if (listeners.size() == 0) {
            CoreModel.getDefault().addElementChangedListener(this);
        }
        if (listeners.indexOf(listener) == -1) {
            listeners.add(listener);
        }
    }

    public synchronized void removeTypeHierarchyChangedListener(ITypeHierarchyChangedListener listener) {
        ArrayList listeners = this.fChangeListeners;
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.isEmpty()) {
            CoreModel.getDefault().removeElementChangedListener(this);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fNeedsRefresh) {
            return;
        }
        if (this.isAffected(event.getDelta())) {
            this.fNeedsRefresh = true;
            this.fireChange();
        }
    }

    public synchronized boolean isAffected(ICElementDelta delta) {
        return true;
    }

    public void fireChange() {
        ArrayList listeners = this.fChangeListeners;
        if (listeners == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("FIRING hierarchy change [" + Thread.currentThread() + "]");
            if (this.fFocusType != null) {
                System.out.println("    for hierarchy focused on " + this.fFocusType.toString());
            }
        }
        listeners = (ArrayList)listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            final ITypeHierarchyChangedListener listener = (ITypeHierarchyChangedListener)listeners.get(i);
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    Util.log(exception, "Exception occurred in listener of Type hierarchy change notification", ICLogConstants.CDT);
                }

                public void run() throws Exception {
                    listener.typeHierarchyChanged(TypeHierarchy.this);
                }
            });
            ++i;
        }
    }

    public boolean contains(ICElement type) {
        ITypeInfo info = AllTypesCache.getTypeForElement(type, true, true, null);
        if (info == null) {
            return false;
        }
        if (this.fTypeToSuperTypes.get(info) != null) {
            return true;
        }
        return this.fRootTypes.contains(type);
    }

    public boolean exists() {
        if (!this.fNeedsRefresh) {
            return true;
        }
        return (this.fFocusType == null || this.fFocusType.exists()) && this.cProject().exists();
    }

    public ICProject cProject() {
        IProject project = this.fFocusType.getCache().getProject();
        return this.findCProject(project);
    }

    private ICProject findCProject(IProject project) {
        try {
            ICProject[] cProjects = CoreModel.getDefault().getCModel().getCProjects();
            if (cProjects != null) {
                int i = 0;
                while (i < cProjects.length) {
                    ICProject cProject = cProjects[i];
                    if (project.equals((Object)cProjects[i].getProject())) {
                        return cProject;
                    }
                    ++i;
                }
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public ICElement[] getAllClasses() {
        return null;
    }

    public ICElement[] getRootClasses() {
        return null;
    }

    public ICElement[] getSubtypes(ICElement type) {
        ArrayList<ICElement> list = new ArrayList<ICElement>();
        ITypeInfo info = AllTypesCache.getTypeForElement(type, true, true, null);
        Collection entries = (Collection)this.fTypeToSubTypes.get(info);
        if (entries != null) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                ITypeInfo subType = (ITypeInfo)i.next();
                ICElement elem = AllTypesCache.getElementForType(subType, true, true, null);
                if (elem == null) continue;
                list.add(elem);
            }
        }
        return list.toArray(new ICElement[list.size()]);
    }

    public ICElement[] getAllSubtypes(ICElement type) {
        ArrayList list = new ArrayList();
        ITypeInfo info = AllTypesCache.getTypeForElement(type, true, true, null);
        this.addSubs(info, list);
        ICElement[] elems = new ICElement[list.size()];
        int count = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ITypeInfo subType = (ITypeInfo)i.next();
            elems[count++] = AllTypesCache.getElementForType(subType, true, true, null);
        }
        return elems;
    }

    private void addSubs(ITypeInfo type, List list) {
        Collection entries = (Collection)this.fTypeToSubTypes.get(type);
        if (entries != null) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                ITypeInfo subType = (ITypeInfo)i.next();
                if (!list.contains(subType)) {
                    list.add(subType);
                }
                this.addSubs(subType, list);
            }
        }
    }

    public ICElement[] getSupertypes(ICElement type) {
        ArrayList<ICElement> list = new ArrayList<ICElement>();
        ITypeInfo info = AllTypesCache.getTypeForElement(type, true, true, null);
        Collection entries = (Collection)this.fTypeToSuperTypes.get(info);
        if (entries != null) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                TypeEntry entry = (TypeEntry)i.next();
                ITypeInfo superType = entry.type;
                ICElement elem = AllTypesCache.getElementForType(superType, true, true, null);
                if (elem == null) continue;
                list.add(elem);
            }
        }
        return list.toArray(new ICElement[list.size()]);
    }

    public ICElement[] getAllSupertypes(ICElement type) {
        ArrayList list = new ArrayList();
        ITypeInfo info = AllTypesCache.getTypeForElement(type, true, true, null);
        this.addSupers(info, list);
        ICElement[] elems = new ICElement[list.size()];
        int count = 0;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ITypeInfo superType = (ITypeInfo)i.next();
            elems[count++] = AllTypesCache.getElementForType(superType, true, true, null);
        }
        return elems;
    }

    private void addSupers(ITypeInfo type, List list) {
        Collection entries = (Collection)this.fTypeToSuperTypes.get(type);
        if (entries != null) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                TypeEntry entry = (TypeEntry)i.next();
                ITypeInfo superType = entry.type;
                if (!list.contains(superType)) {
                    list.add(superType);
                }
                this.addSupers(superType, list);
            }
        }
    }

    public ICElement getType() {
        if (this.fFocusType != null) {
            return AllTypesCache.getElementForType(this.fFocusType, true, true, null);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void refresh(IProgressMonitor monitor) throws CModelException {
        block14: {
            try {
                this.fProgressMonitor = monitor;
                if (monitor != null) {
                    if (this.fFocusType != null) {
                        monitor.beginTask(TypeHierarchyMessages.getFormattedString("hierarchy.creatingOnType", this.fFocusType.getQualifiedTypeName().getFullyQualifiedName()), 100);
                    } else {
                        monitor.beginTask(TypeHierarchyMessages.getString("hierarchy.creating"), 100);
                    }
                }
                long start = -1L;
                if (DEBUG) {
                    start = System.currentTimeMillis();
                    if (this.fComputeSubtypes) {
                        System.out.println("CREATING TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    } else {
                        System.out.println("CREATING SUPER TYPE HIERARCHY [" + Thread.currentThread() + "]");
                    }
                    if (this.fFocusType != null) {
                        System.out.println("  on type " + this.fFocusType.toString());
                    }
                }
                this.compute();
                this.fNeedsRefresh = false;
                if (DEBUG) {
                    if (this.fComputeSubtypes) {
                        System.out.println("CREATED TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    } else {
                        System.out.println("CREATED SUPER TYPE HIERARCHY in " + (System.currentTimeMillis() - start) + "ms");
                    }
                    System.out.println(this.toString());
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (monitor != null) {
                    monitor.done();
                }
                this.fProgressMonitor = null;
                throw throwable;
            }
            {
                Object var4_5 = null;
                if (monitor == null) break block14;
            }
            monitor.done();
        }
        this.fProgressMonitor = null;
    }

    protected void compute() {
    }

    public void store(OutputStream outputStream, IProgressMonitor monitor) throws CModelException {
    }

    private static final class TypeEntry {
        ITypeInfo type;
        ASTAccessVisibility access;

        TypeEntry(ITypeInfo type, ASTAccessVisibility access) {
            this.type = type;
            this.access = access;
        }
    }
}

