/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom;

import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class PDOM {
    private static final String PDOM_NODE = "org.eclipse.cdt.core.pdom";
    private static final String ENABLED_KEY = "enabled";

    private static IEclipsePreferences getPreferences(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        if (projectScope == null) {
            return null;
        }
        return projectScope.getNode(PDOM_NODE);
    }

    public static boolean isEnabled(IProject project) {
        IEclipsePreferences prefs = PDOM.getPreferences(project);
        if (prefs == null) {
            return false;
        }
        return prefs.getBoolean(ENABLED_KEY, false);
    }

    public static void setEnabled(IProject project, boolean enabled) {
        IEclipsePreferences prefs = PDOM.getPreferences(project);
        if (prefs == null) {
            return;
        }
        prefs.putBoolean(ENABLED_KEY, enabled);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static boolean isInitialized(IProject project) {
        return PDOM.getPreferences(project) != null;
    }

    public static IPDOM getPDOM(IProject project) {
        if (PDOM.isEnabled(project)) {
            return PDOMManager.getInstance().getPDOM(project);
        }
        return null;
    }

    public static void deletePDOM(IProject project) throws CoreException {
        if (PDOM.isEnabled(project)) {
            PDOMManager.getInstance().getPDOM(project).delete();
        }
    }

    public static void startup() {
        PDOMManager listener = PDOMManager.getInstance();
        if (listener != null) {
            CoreModel.getDefault().addElementChangedListener(listener);
        }
    }
}

