/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class LanguageManager {
    private static LanguageManager instance;

    public static LanguageManager getInstance() {
        if (instance == null) {
            instance = new LanguageManager();
        }
        return instance;
    }

    public ILanguage getLanguage(String id) throws CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "language");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] languages = extension.getConfigurationElements();
            int j = 0;
            while (j < languages.length) {
                IConfigurationElement language = languages[j];
                String langId = String.valueOf(extension.getNamespace()) + "." + language.getAttribute("id");
                if (langId.equals(id)) {
                    return (ILanguage)language.createExecutableExtension("class");
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public ILanguage getLanguage(IContentType contentType) throws CoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "language");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] languages = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < languages.length) {
                IConfigurationElement language = languages[j];
                IConfigurationElement[] contentTypes = language.getChildren("contentType");
                int k = 0;
                while (k < contentTypes.length) {
                    IContentType langContType = manager.getContentType(contentTypes[k].getAttribute("id"));
                    if (contentType.equals(langContType)) {
                        return (ILanguage)language.createExecutableExtension("class");
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

