/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import org.eclipse.cdt.core.search.ILineLocatable;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.IOffsetLocatable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class BasicSearchMatch
implements IMatch,
Comparable {
    String name = null;
    String parentName = null;
    String[] qualifiedName;
    String[] parameters;
    String returnType;
    IResource resource = null;
    IPath path = null;
    int type = 0;
    int visibility = 0;
    boolean isConst = false;
    boolean isVolatile = false;
    boolean isStatic = false;
    private int hashCode = 0;
    IPath referringElement = null;
    IMatchLocatable locatable = null;
    private static final String HASH_SEPERATOR = ":";

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer hashBuffer = new StringBuffer();
            hashBuffer.append(this.name);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.parentName);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.returnType);
            if (this.getLocation() != null) {
                hashBuffer.append(HASH_SEPERATOR);
                hashBuffer.append(this.getLocation().toString());
            }
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.locatable instanceof IOffsetLocatable ? ((IOffsetLocatable)this.locatable).getNameStartOffset() : ((ILineLocatable)this.locatable).getStartLine());
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.locatable instanceof IOffsetLocatable ? ((IOffsetLocatable)this.locatable).getNameEndOffset() : ((ILineLocatable)this.locatable).getEndLine());
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.type);
            hashBuffer.append(HASH_SEPERATOR);
            hashBuffer.append(this.visibility);
            this.hashCode = hashBuffer.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicSearchMatch)) {
            return false;
        }
        BasicSearchMatch match = (BasicSearchMatch)obj;
        if (this.locatable != null && match.locatable == null || this.locatable == null && match.locatable != null) {
            return false;
        }
        if (this.locatable != null && match.locatable != null) {
            if (!(this.locatable instanceof IOffsetLocatable && match.locatable instanceof IOffsetLocatable && this.locatable instanceof ILineLocatable && match.locatable instanceof ILineLocatable)) {
                return false;
            }
            if (this.locatable instanceof IOffsetLocatable ? ((IOffsetLocatable)this.locatable).getNameStartOffset() != ((IOffsetLocatable)match.locatable).getNameStartOffset() || ((IOffsetLocatable)this.locatable).getNameEndOffset() != ((IOffsetLocatable)match.locatable).getNameEndOffset() : ((ILineLocatable)this.locatable).getStartLine() != ((ILineLocatable)match.locatable).getStartLine()) {
                return false;
            }
        }
        if (this.type != match.getElementType() || this.visibility != match.getVisibility()) {
            return false;
        }
        if (this.name != null && match.getName() != null ? !this.name.equals(match.getName()) : this.name != match.getName()) {
            return false;
        }
        if (this.parentName != null && match.getParentName() != null ? !this.parentName.equals(match.getParentName()) : this.parentName != match.getParentName()) {
            return false;
        }
        if (this.returnType != null && match.getReturnType() != null ? !this.returnType.equals(match.getReturnType()) : this.returnType != match.getReturnType()) {
            return false;
        }
        IPath thisPath = this.getLocation();
        IPath matchPath = match.getLocation();
        return !(thisPath != null && matchPath != null ? !thisPath.equals((Object)matchPath) : thisPath != matchPath);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BasicSearchMatch)) {
            throw new ClassCastException();
        }
        BasicSearchMatch match = (BasicSearchMatch)o;
        int result = this.getLocation().toString().compareTo(match.getLocation().toString());
        if (result != 0) {
            return result;
        }
        if (this.locatable instanceof IOffsetLocatable && match.getLocatable() instanceof IOffsetLocatable) {
            result = ((IOffsetLocatable)this.locatable).getNameStartOffset() - ((IOffsetLocatable)match.locatable).getNameStartOffset();
            if (result != 0) {
                return result;
            }
            result = ((IOffsetLocatable)this.locatable).getNameEndOffset() - ((IOffsetLocatable)match.locatable).getNameEndOffset();
            if (result != 0) {
                return result;
            }
        } else if (this.locatable instanceof ILineLocatable && match.getLocatable() instanceof ILineLocatable) {
            result = ((ILineLocatable)this.locatable).getStartLine() - ((ILineLocatable)match.locatable).getStartLine();
            if (result != 0) {
                return result;
            }
            result = ((ILineLocatable)this.locatable).getEndLine() - ((ILineLocatable)match.locatable).getEndLine();
            if (result != 0) {
                return result;
            }
        }
        if ((result = this.getName().compareTo(match.getName())) != 0) {
            return result;
        }
        result = this.getParentName().compareTo(match.getParentName());
        if (result != 0) {
            return result;
        }
        result = this.getReturnType().compareTo(match.getReturnType());
        return result;
    }

    public int getElementType() {
        return this.type;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IPath getLocation() {
        if (this.resource != null) {
            return this.resource.getLocation();
        }
        if (this.path != null) {
            return this.path;
        }
        return null;
    }

    public IPath getReferenceLocation() {
        return this.referringElement;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public int getType() {
        return this.type;
    }

    public void setConst(boolean b) {
        this.isConst = b;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public void setVolatile(boolean b) {
        this.isVolatile = b;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setParentName(String string) {
        this.parentName = string;
    }

    public void setParameters(String[] params) {
        this.parameters = params;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }

    public void setType(int i) {
        this.type = i;
    }

    public void setVisibility(int i) {
        this.visibility = i;
    }

    public IMatchLocatable getLocatable() {
        return this.locatable;
    }

    public void setLocatable(IMatchLocatable locatable) {
        this.locatable = locatable;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IPath getPath() {
        return this.path;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public IPath getReferringElement() {
        return this.referringElement;
    }

    public void setReferringElement(IPath referringElement) {
        this.referringElement = referringElement;
    }

    public String[] getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String[] qualifiedName) {
        this.qualifiedName = qualifiedName;
    }
}

