/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTUtil;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.OffsetLocatable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class BasicSearchResultCollector
implements ICSearchResultCollector {
    IProgressMonitor fProgressMonitor = null;
    private Set results;

    public BasicSearchResultCollector() {
    }

    public BasicSearchResultCollector(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void aboutToStart() {
        this.results = new HashSet();
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public IMatch createMatch(Object fileResource, int start, int end, ISourceElementCallbackDelegate node, IPath referringElement) {
        BasicSearchMatch result = new BasicSearchMatch();
        return this.createMatch(result, fileResource, start, end, node, referringElement);
    }

    public IMatch createMatch(BasicSearchMatch result, Object fileResource, int start, int end, ISourceElementCallbackDelegate node, IPath referringElement) {
        if (fileResource instanceof IResource) {
            result.resource = (IResource)fileResource;
        } else if (fileResource instanceof IPath) {
            result.path = (IPath)fileResource;
        }
        result.locatable = new OffsetLocatable(start, end);
        result.parentName = "";
        result.referringElement = referringElement;
        IASTOffsetableNamedElement offsetable = null;
        if (node instanceof IASTReference) {
            offsetable = (IASTOffsetableNamedElement)((Object)((IASTReference)node).getReferencedElement());
            result.name = ((IASTReference)node).getName();
        } else if (node instanceof IASTOffsetableNamedElement) {
            offsetable = (IASTOffsetableNamedElement)((Object)node);
            result.name = offsetable.getName();
        }
        result.parentName = "";
        String[] names = null;
        if (offsetable instanceof IASTEnumerator) {
            IASTEnumerator enumerator = (IASTEnumerator)offsetable;
            names = enumerator.getOwnerEnumerationSpecifier().getFullyQualifiedName();
        } else if (offsetable instanceof IASTQualifiedNameElement) {
            names = ((IASTQualifiedNameElement)((Object)offsetable)).getFullyQualifiedName();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length - 1) {
                if (i > 0) {
                    result.parentName = String.valueOf(result.parentName) + "::";
                }
                result.parentName = String.valueOf(result.parentName) + names[i];
                ++i;
            }
        }
        if (offsetable instanceof IASTVariable) {
            result.returnType = ASTUtil.getType(((IASTVariable)offsetable).getAbstractDeclaration());
        }
        if (offsetable instanceof IASTFunction) {
            result.name = String.valueOf(result.name) + this.getParameterString((IASTFunction)offsetable);
            result.returnType = ASTUtil.getType(((IASTFunction)offsetable).getReturnType());
        }
        this.setElementInfo(result, offsetable);
        return result;
    }

    private String getParameterString(IASTFunction function) {
        if (function == null) {
            return "";
        }
        String paramString = "(";
        String[] paramTypes = ASTUtil.getFunctionParameterTypes(function);
        int i = 0;
        while (i < paramTypes.length) {
            if (i != 0) {
                paramString = String.valueOf(paramString) + ", ";
            }
            paramString = String.valueOf(paramString) + paramTypes[i];
            ++i;
        }
        paramString = String.valueOf(paramString) + ")";
        return paramString;
    }

    public boolean acceptMatch(IMatch match) throws CoreException {
        if (!this.results.contains(match)) {
            this.results.add(match);
            return true;
        }
        return false;
    }

    public Set getSearchResults() {
        return this.results;
    }

    private void setElementInfo(BasicSearchMatch match, IASTOffsetableElement node) {
        if (node instanceof IASTClassSpecifier || node instanceof IASTElaboratedTypeSpecifier) {
            ASTClassKind kind = null;
            kind = node instanceof IASTClassSpecifier ? ((IASTClassSpecifier)node).getClassKind() : ((IASTElaboratedTypeSpecifier)node).getClassKind();
            if (kind == ASTClassKind.CLASS) {
                match.type = 65;
            } else if (kind == ASTClassKind.STRUCT) {
                match.type = 67;
            } else if (kind == ASTClassKind.UNION) {
                match.type = 69;
            }
        } else if (node instanceof IASTNamespaceDefinition) {
            match.type = 61;
        } else if (node instanceof IASTEnumerationSpecifier) {
            match.type = 63;
        } else if (node instanceof IASTMacro) {
            match.type = 79;
        } else if (node instanceof IASTField) {
            match.type = 72;
            IASTField field = (IASTField)node;
            ASTAccessVisibility visibility = field.getVisiblity();
            if (visibility == ASTAccessVisibility.PUBLIC) {
                match.visibility = 8192;
            } else if (visibility == ASTAccessVisibility.PRIVATE) {
                match.visibility = 4096;
            }
            match.isConst = field.getAbstractDeclaration().isConst();
            match.isStatic = field.isStatic();
        } else if (node instanceof IASTVariable) {
            match.type = 76;
            IASTVariable variable = (IASTVariable)node;
            match.isConst = variable.getAbstractDeclaration().isConst();
        } else if (node instanceof IASTParameterDeclaration) {
            match.type = 76;
            match.isConst = ((IASTParameterDeclaration)node).isConst();
        } else if (node instanceof IASTEnumerator) {
            match.type = 81;
        } else if (node instanceof IASTMethod) {
            match.type = 70;
            IASTMethod method = (IASTMethod)node;
            ASTAccessVisibility visibility = method.getVisiblity();
            if (visibility == ASTAccessVisibility.PUBLIC) {
                match.visibility = 8192;
            } else if (visibility == ASTAccessVisibility.PRIVATE) {
                match.visibility = 4096;
            }
            match.isConst = method.isConst();
            match.isVolatile = method.isVolatile();
            match.isStatic = method.isStatic();
        } else if (node instanceof IASTFunction) {
            match.type = 74;
            IASTFunction function = (IASTFunction)node;
            match.isStatic = function.isStatic();
        } else if (node instanceof IASTTypedefDeclaration) {
            match.type = 80;
        }
    }
}

