/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.domsourceindexer.IndexVisitorUtil;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;

public class DOMSearchUtil {
    private static final String BLANK_STRING = "";
    private static final IASTName[] BLANK_NAME_ARRAY = new IASTName[0];
    private static final IASTName[] EMPTY_NAME_LIST = BLANK_NAME_ARRAY;
    private static final Set EMPTY_MATCHES = new HashSet(0);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Set getMatchesFromSearchEngine(ICSearchScope scope, IASTName searchName, ICSearchConstants.LimitTo limitTo) {
        SearchEngine engine = new SearchEngine();
        BasicSearchResultCollector results = new BasicSearchResultCollector();
        CSearchPattern pattern = DOMSearchUtil.createPattern(searchName, limitTo, true);
        try {
            engine.setWaitingPolicy(1);
            engine.search(CCorePlugin.getWorkspace(), pattern, scope, results, false);
        }
        catch (InterruptedException interruptedException) {
            return EMPTY_MATCHES;
        }
        return results.getSearchResults();
    }

    public static Set getMatchesFromSearchEngine(ICSearchScope scope, String searchPattern, ICSearchConstants.LimitTo limitTo) {
        SearchEngine engine = new SearchEngine();
        BasicSearchResultCollector results = new BasicSearchResultCollector();
        ICSearchPattern pattern = SearchEngine.createSearchPattern(searchPattern, ICSearchConstants.UNKNOWN_SEARCH_FOR, limitTo, true);
        try {
            engine.setWaitingPolicy(1);
            engine.search(CCorePlugin.getWorkspace(), pattern, scope, results, false);
        }
        catch (InterruptedException interruptedException) {
            return EMPTY_MATCHES;
        }
        return results.getSearchResults();
    }

    private static CSearchPattern createPattern(IASTName searchName, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        IBinding binding = searchName.resolveBinding();
        if (binding == null) {
            return null;
        }
        ICSearchConstants.SearchFor searchFor = DOMSearchUtil.createSearchFor(binding);
        return CSearchPattern.createPattern(DOMSearchUtil.getSearchPattern(searchName), searchFor, limitTo, 0, caseSensitive);
    }

    private static ICSearchConstants.SearchFor createSearchFor(IBinding binding) {
        ICSearchConstants.SearchFor searchFor = null;
        if (binding instanceof ICPPMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (binding instanceof IFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (binding instanceof ICPPNamespace || binding instanceof ICPPNamespaceAlias) {
            searchFor = ICSearchConstants.NAMESPACE;
        } else if (binding instanceof ICPPField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (binding instanceof IEnumerator) {
            searchFor = ICSearchConstants.ENUMTOR;
        } else if (binding instanceof IMacroBinding) {
            searchFor = ICSearchConstants.MACRO;
        } else if (binding instanceof ITypedef) {
            searchFor = ICSearchConstants.TYPEDEF;
        } else if (binding instanceof IVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (binding instanceof ICompositeType) {
            try {
                switch (((ICompositeType)binding).getKey()) {
                    case 1: 
                    case 3: {
                        searchFor = ICSearchConstants.CLASS_STRUCT;
                        break;
                    }
                    case 2: {
                        searchFor = ICSearchConstants.UNION;
                        break;
                    }
                    default: {
                        searchFor = ICSearchConstants.TYPE;
                        break;
                    }
                }
            }
            catch (DOMException dOMException) {
                searchFor = ICSearchConstants.UNKNOWN_SEARCH_FOR;
            }
        } else {
            searchFor = binding instanceof IEnumeration ? ICSearchConstants.ENUM : ICSearchConstants.UNKNOWN_SEARCH_FOR;
        }
        return searchFor;
    }

    /*
     * Exception decompiling
     */
    public static IASTName[] getSelectedNamesFrom(IASTTranslationUnit tu, int offset, int length, ParserLanguage lang) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static IASTName[] getSelectedNamesFrom(IFile file, int offset, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 140->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ParserLanguage getLanguageFromFile(IFile file) {
        String lid;
        IProject project = file.getProject();
        IContentType contentType = CCorePlugin.getContentType(project, file.getFullPath().lastSegment());
        if (contentType != null && "org.eclipse.cdt.core.cxxSource".equals(lid = contentType.getId())) {
            return ParserLanguage.CPP;
        }
        return ParserLanguage.C;
    }

    public static IASTName[] getNamesFromDOM(IASTName searchName, ICSearchConstants.LimitTo limitTo) {
        IASTName[] names = null;
        IASTTranslationUnit tu = searchName.getTranslationUnit();
        if (tu == null) {
            return BLANK_NAME_ARRAY;
        }
        IBinding binding = searchName.resolveBinding();
        if (binding instanceof PDOMBinding) {
            try {
                ArrayList<PDOMName> pdomNames = new ArrayList<PDOMName>();
                PDOMName name = ((PDOMBinding)binding).getFirstDeclaration();
                while (name != null) {
                    pdomNames.add(name);
                    name = name.getNextInBinding();
                }
                name = ((PDOMBinding)binding).getFirstDefinition();
                while (name != null) {
                    pdomNames.add(name);
                    name = name.getNextInBinding();
                }
                names = pdomNames.toArray(new IASTName[pdomNames.size()]);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else {
            names = DOMSearchUtil.getNames(tu, binding, limitTo);
            if (names == null || names.length == 0) {
                try {
                    if ((binding instanceof ICPPConstructor || binding instanceof ICPPMethod && ((ICPPMethod)binding).isDestructor()) && binding.getScope() instanceof ICPPClassScope) {
                        binding = ((ICPPClassScope)binding.getScope()).getClassType();
                        names = DOMSearchUtil.getNames(tu, binding, limitTo);
                    }
                }
                catch (DOMException dOMException) {}
            }
        }
        return names;
    }

    private static IASTName[] getNames(IASTTranslationUnit tu, IBinding binding, ICSearchConstants.LimitTo limitTo) {
        Object[] names = null;
        if (limitTo == ICSearchConstants.DECLARATIONS || limitTo == ICSearchConstants.DECLARATIONS_DEFINITIONS) {
            names = tu.getDeclarations(binding);
        } else if (limitTo == ICSearchConstants.REFERENCES) {
            names = tu.getReferences(binding);
        } else if (limitTo == ICSearchConstants.DEFINITIONS) {
            names = tu.getDefinitions(binding);
        } else if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
            names = tu.getDeclarations(binding);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            names = (IASTName[])ArrayUtil.addAll(clazz, names, tu.getReferences(binding));
        } else {
            names = tu.getDeclarations(binding);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            names = (IASTName[])ArrayUtil.addAll(clazz, names, tu.getReferences(binding));
        }
        return names;
    }

    public static ParserLanguage getLanguage(IPath path, IProject project) {
        String id = null;
        IContentType contentType = CCorePlugin.getContentType(project, path.lastSegment());
        if (contentType != null) {
            id = contentType.getId();
        }
        if (id != null) {
            if ("org.eclipse.cdt.core.cxxHeader".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cxxSource".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cHeader".equals(id)) {
                return ParserLanguage.CPP;
            }
            if ("org.eclipse.cdt.core.cSource".equals(id)) {
                return ParserLanguage.C;
            }
            "org.eclipse.cdt.core.asmSource".equals(id);
        }
        return ParserLanguage.CPP;
    }

    public static String getSearchPattern(IASTName name) {
        if (name == null) {
            return BLANK_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IProblemBinding)) {
            if (binding instanceof ICPPBinding) {
                ICPPBinding cppBinding = (ICPPBinding)binding;
                try {
                    String[] qualifiedName = cppBinding.getQualifiedName();
                    int i = 0;
                    while (i < qualifiedName.length) {
                        if (i != 0) {
                            buffer.append("::");
                        }
                        buffer.append(qualifiedName[i]);
                        ++i;
                    }
                }
                catch (DOMException dOMException) {
                    buffer.append(name.toString());
                }
            } else {
                buffer.append(name.toString());
            }
        } else {
            Object[] namespaces = null;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTTranslationUnit) && parent != null) {
                if (parent instanceof ICPPASTNamespaceDefinition) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    namespaces = (String[])ArrayUtil.append(clazz, namespaces, ((ICPPASTNamespaceDefinition)parent).getName().toString());
                }
                parent = parent.getParent();
            }
            if (namespaces != null && namespaces.length > 0) {
                int i = namespaces.length - 1;
                while (i >= 0) {
                    if (namespaces[i] != null) {
                        buffer.append((String)namespaces[i]);
                        buffer.append("::");
                    }
                    --i;
                }
            }
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] names = ((ICPPASTQualifiedName)name.getParent()).getNames();
                int i = 0;
                while (i < names.length) {
                    if (i != 0) {
                        buffer.append("::");
                    }
                    buffer.append(names[i].toString());
                    ++i;
                }
            } else {
                buffer.append(name.toString());
            }
        }
        if (binding instanceof IFunction || binding instanceof IProblemBinding && name.getParent() instanceof IASTFunctionDeclarator) {
            char[][] parameters = IndexVisitorUtil.getParameters(name);
            buffer.append("(");
            int i = 0;
            while (i < parameters.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(parameters[i]);
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static class CPPNameCollector
    extends CPPASTVisitor {
        public List nameList;

        public CPPNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName getName(int idx) {
            if (idx < 0 || idx >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(idx);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    public static class CNameCollector
    extends CASTVisitor {
        public List nameList;

        public CNameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName getName(int idx) {
            if (idx < 0 || idx >= this.nameList.size()) {
                return null;
            }
            return (IASTName)this.nameList.get(idx);
        }

        public int size() {
            return this.nameList.size();
        }
    }
}

