/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.search;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class OrPattern
extends CSearchPattern {
    private LinkedList patterns = new LinkedList();

    public void addPattern(ICSearchPattern pattern) {
        if (pattern != null) {
            this.patterns.add(pattern);
        }
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        Iterator iter = this.patterns.iterator();
        int size = this.patterns.size();
        int result = 0;
        int i = 0;
        while (i < size) {
            ICSearchPattern pattern = (ICSearchPattern)iter.next();
            result = pattern.matchLevel(node, limit);
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public boolean canAccept(ICSearchConstants.LimitTo limit) {
        if (limit == ALL_OCCURRENCES) {
            return true;
        }
        Iterator iter = this.patterns.iterator();
        int size = this.patterns.size();
        int i = 0;
        while (i < size) {
            ICSearchPattern pattern = (ICSearchPattern)iter.next();
            if (pattern.canAccept(limit)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void findIndexMatches(IndexInput input, IIndexSearchRequestor requestor, int detailLevel, IProgressMonitor progressMonitor, ICSearchScope scope) throws IOException {
        Iterator iter = this.patterns.iterator();
        int size = this.patterns.size();
        int i = 0;
        while (i < size) {
            CSearchPattern pattern = (CSearchPattern)iter.next();
            pattern.findIndexMatches(input, requestor, detailLevel, progressMonitor, scope);
            ++i;
        }
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
    }

    protected void resetIndexInfo() {
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
    }

    public char[] indexEntryPrefix() {
        return null;
    }

    protected boolean matchIndexEntry() {
        return false;
    }
}

