/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.internal.core.browser.cache.BasicJob;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerDependenciesJob;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob2;
import org.eclipse.cdt.internal.core.browser.cache.IndexerTypesJob2;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheDelta;
import org.eclipse.cdt.internal.core.browser.cache.TypeCacheMessages;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypeCacherJob
extends BasicJob {
    public static final Object FAMILY = new Object();
    private IndexManager fIndexManager;
    private ITypeCache fTypeCache;
    private TypeCacheDelta[] fDeltas;
    private boolean fEnableIndexing;
    private boolean fIndexerIsBusy;
    private static final int PATH_ENTRY_FLAGS = 265984;

    public TypeCacherJob(ITypeCache typeCache, TypeCacheDelta[] deltas, boolean enableIndexing) {
        super(TypeCacheMessages.getString("TypeCacherJob.defaultJobName"), FAMILY);
        this.fTypeCache = typeCache;
        this.fDeltas = deltas;
        this.fEnableIndexing = enableIndexing;
        this.fIndexerIsBusy = false;
        this.fIndexManager = CModelManager.getDefault().getIndexManager();
        this.setPriority(40);
        this.setSystem(true);
        this.setRule(typeCache);
        this.setName(TypeCacheMessages.getFormattedString("TypeCacherJob.jobName", this.fTypeCache.getProject().getName()));
    }

    public ITypeCache getCache() {
        return this.fTypeCache;
    }

    public TypeCacheDelta[] getDeltas() {
        return this.fDeltas;
    }

    public boolean isIndexerBusy() {
        return this.fIndexerIsBusy;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus runWithDelegatedProgress(IProgressMonitor monitor) throws InterruptedException {
        boolean success = false;
        long startTime = System.currentTimeMillis();
        TypeCacherJob.trace("TypeCacherJob: started");
        try {
            SubProgressMonitor subMonitor;
            int totalWork = 100;
            monitor.beginTask(TypeCacheMessages.getString("TypeCacherJob.taskName"), totalWork);
            TypeSearchScope flushScope = new TypeSearchScope();
            if (this.fDeltas != null) {
                int i = 0;
                while (i < this.fDeltas.length) {
                    TypeCacheDelta delta = this.fDeltas[i];
                    this.prepareToFlush(delta, flushScope);
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            int flushWork = 0;
            if (!flushScope.isEmpty()) {
                flushWork = totalWork / 4;
                subMonitor = new SubProgressMonitor(monitor, flushWork);
                this.flush(flushScope, (IProgressMonitor)subMonitor);
            }
            subMonitor = new SubProgressMonitor(monitor, totalWork - flushWork);
            this.update(flushScope, (IProgressMonitor)subMonitor);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            long executionTime = System.currentTimeMillis() - startTime;
            if (success) {
                TypeCacherJob.trace("TypeCacherJob: completed (" + executionTime + " ms)");
            } else {
                TypeCacherJob.trace("TypeCacherJob: aborted (" + executionTime + " ms)");
            }
            monitor.done();
            throw throwable;
        }
        {
            Object var9_10 = null;
        }
        long executionTime = System.currentTimeMillis() - startTime;
        if (success) {
            TypeCacherJob.trace("TypeCacherJob: completed (" + executionTime + " ms)");
        } else {
            TypeCacherJob.trace("TypeCacherJob: aborted (" + executionTime + " ms)");
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    private void flush(ITypeSearchScope scope, IProgressMonitor monitor) throws InterruptedException {
        boolean success = true;
        IProject project = this.fTypeCache.getProject();
        monitor.beginTask("", 100);
        this.fTypeCache.flush(scope);
        if (!scope.encloses(project) && project.exists() && project.isOpen()) {
            success = this.doIndexerJob(new IndexerDependenciesJob(this.fIndexManager, this.fTypeCache, scope), monitor);
        }
        if (!success || monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.done();
    }

    private void update(ITypeSearchScope scope, IProgressMonitor monitor) throws InterruptedException {
        boolean success = true;
        IProject project = this.fTypeCache.getProject();
        monitor.beginTask("", 100);
        if (project.exists() && project.isOpen()) {
            success = this.doIndexerJob(new IndexerTypesJob2(this.fIndexManager, this.fTypeCache, scope), monitor);
        }
        if (!success || monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.done();
    }

    private boolean doIndexerJob(IndexerJob job, IProgressMonitor monitor) {
        if (!this.fEnableIndexing) {
            return false;
        }
        this.fIndexerIsBusy = false;
        try {
            this.fIndexManager.performConcurrentJob(new DummyIndexerJob(this.fIndexManager, this.fTypeCache.getProject()), 2, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fIndexerIsBusy = true;
        }
        return this.fIndexManager.performConcurrentJob(job, 1, monitor, null);
    }

    private boolean doIndexerJob(IndexerJob2 job, IProgressMonitor monitor) {
        if (!this.fEnableIndexing) {
            return false;
        }
        this.fIndexerIsBusy = false;
        try {
            this.fIndexManager.performConcurrentJob(new DummyIndexerJob(this.fIndexManager, this.fTypeCache.getProject()), 2, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.fIndexerIsBusy = true;
        }
        return this.fIndexManager.performConcurrentJob(job, 1, monitor, null);
    }

    private void prepareToFlush(TypeCacheDelta cacheDelta, ITypeSearchScope scope) {
        ICElementDelta delta;
        ITypeSearchScope deltaScope = cacheDelta.getScope();
        if (deltaScope != null) {
            scope.add(deltaScope);
        }
        if ((delta = cacheDelta.getCElementDelta()) != null) {
            ICElement elem = delta.getElement();
            boolean added = delta.getKind() == 1;
            boolean removed = delta.getKind() == 2;
            boolean contentChanged = (delta.getFlags() & 1) != 0;
            boolean pathEntryChanged = (delta.getFlags() & 0x40F00) != 0;
            switch (elem.getElementType()) {
                case 10: {
                    if (!added && !removed) break;
                    scope.add(elem);
                    break;
                }
                case 11: {
                    if (!added && !removed && !pathEntryChanged) break;
                    scope.add(elem);
                    break;
                }
                case 12: {
                    if (!added && !removed && !pathEntryChanged) break;
                    scope.add(elem);
                    break;
                }
                case 60: {
                    if (!added && !removed && !pathEntryChanged && !contentChanged) break;
                    scope.add(elem);
                    break;
                }
                case 61: 
                case 63: 
                case 65: 
                case 67: 
                case 69: 
                case 75: 
                case 80: 
                case 83: {
                    if (!added && !removed) break;
                    scope.add(elem);
                }
            }
        }
    }

    private static final class DummyIndexerJob
    extends IndexerJob {
        public DummyIndexerJob(IndexManager indexManager, IProject project) {
            super(indexManager, project);
        }

        protected boolean processIndex(IIndex index, IProject project, IProgressMonitor progressMonitor) {
            return false;
        }
    }
}

