/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultProblemHandler;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserTimeOut;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.util.SimpleStack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TypeParser
implements ISourceElementRequestor {
    private ITypeCache fTypeCache;
    private ITypeSearchScope fScope;
    private IProject fProject;
    private IWorkingCopyProvider fWorkingCopyProvider;
    private IProgressMonitor fProgressMonitor;
    ISourceElementCallbackDelegate fLastDeclaration;
    private final SimpleStack fScopeStack = new SimpleStack();
    private final SimpleStack fResourceStack = new SimpleStack();
    private ITypeInfo fTypeToFind;
    private ITypeInfo fSuperTypeToFind;
    private Set fProcessedTypes = new HashSet();
    private boolean fFoundType;
    IParser fParser = null;
    ParserTimeOut fTimeoutThread = null;
    private static final int DEFAULT_PARSER_TIMEOUT = 30;

    public TypeParser(ITypeCache typeCache, IWorkingCopyProvider provider) {
        this.fTypeCache = typeCache;
        this.fWorkingCopyProvider = provider;
        this.fTimeoutThread = new ParserTimeOut("TypeParser TimeOut Thread");
        this.fTimeoutThread.setThreadPriority(10);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseTypes(TypeSearchScope scope, IProgressMonitor monitor) throws InterruptedException {
        IWorkingCopy[] workingCopies;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.fScope = new TypeSearchScope(scope);
        HashMap<IPath, IWorkingCopy> workingCopyMap = null;
        if (this.fWorkingCopyProvider != null && (workingCopies = this.fWorkingCopyProvider.getWorkingCopies()) != null && workingCopies.length > 0) {
            workingCopyMap = new HashMap<IPath, IWorkingCopy>(workingCopies.length);
            int i = 0;
            while (i < workingCopies.length) {
                IWorkingCopy workingCopy = workingCopies[i];
                IPath wcPath = workingCopy.getOriginalElement().getPath();
                if (this.fScope.encloses(wcPath)) {
                    this.fScope.add(wcPath, false, null);
                    workingCopyMap.put(wcPath, workingCopy);
                }
                ++i;
            }
        }
        this.fProject = this.fTypeCache.getProject();
        IPath[] searchPaths = this.fTypeCache.getPaths(this.fScope);
        HashSet workingCopyPaths = new HashSet();
        if (workingCopyMap != null) {
            this.collectWorkingCopiesInProject(workingCopyMap, this.fProject, workingCopyPaths);
        }
        monitor.beginTask("", searchPaths.length + workingCopyPaths.size());
        try {
            IPath path;
            int i;
            Iterator pathIter = workingCopyPaths.iterator();
            while (true) {
                if (!pathIter.hasNext()) {
                    i = 0;
                    break;
                }
                path = (IPath)pathIter.next();
                this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            while (i < searchPaths.length) {
                path = searchPaths[i];
                if (!workingCopyPaths.contains(path)) {
                    this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean findType(ITypeInfo info, IProgressMonitor monitor) throws InterruptedException {
        block19: {
            block18: {
                block17: {
                    IWorkingCopy[] workingCopies;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.fScope = new TypeSearchScope();
                    ITypeReference[] refs = info.getReferences();
                    if (refs == null) return false;
                    if (refs.length == 0) {
                        return false;
                    }
                    this.fScope.add(refs[0].getPath(), false, null);
                    HashMap<IPath, IWorkingCopy> workingCopyMap = null;
                    if (this.fWorkingCopyProvider != null && (workingCopies = this.fWorkingCopyProvider.getWorkingCopies()) != null && workingCopies.length > 0) {
                        workingCopyMap = new HashMap<IPath, IWorkingCopy>(workingCopies.length);
                        int i = 0;
                        while (i < workingCopies.length) {
                            IWorkingCopy workingCopy = workingCopies[i];
                            IPath wcPath = workingCopy.getOriginalElement().getPath();
                            if (this.fScope.encloses(wcPath)) {
                                this.fScope.add(wcPath, false, null);
                                workingCopyMap.put(wcPath, workingCopy);
                            }
                            ++i;
                        }
                    }
                    this.fProject = this.fTypeCache.getProject();
                    IPath[] searchPaths = this.fTypeCache.getPaths(this.fScope);
                    HashSet workingCopyPaths = new HashSet();
                    if (workingCopyMap != null) {
                        this.collectWorkingCopiesInProject(workingCopyMap, this.fProject, workingCopyPaths);
                    }
                    monitor.beginTask("", searchPaths.length + workingCopyPaths.size());
                    try {
                        IPath path;
                        int i;
                        block16: {
                            this.fTypeToFind = info;
                            this.fFoundType = false;
                            Iterator pathIter = workingCopyPaths.iterator();
                            do {
                                if (!pathIter.hasNext()) {
                                    i = 0;
                                    break block16;
                                }
                                path = (IPath)pathIter.next();
                                this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } while (!this.fFoundType);
                            Object var9_11 = null;
                            this.fTypeToFind = null;
                            this.fFoundType = false;
                            break block17;
                        }
                        while (i < searchPaths.length) {
                            path = searchPaths[i];
                            if (!workingCopyPaths.contains(path)) {
                                this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else {
                                monitor.worked(1);
                            }
                            if (this.fFoundType) {
                                break block18;
                            }
                            ++i;
                        }
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        this.fTypeToFind = null;
                        this.fFoundType = false;
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.done();
                return true;
            }
            Object var9_12 = null;
            this.fTypeToFind = null;
            this.fFoundType = false;
            monitor.done();
            return true;
        }
        Object var9_14 = null;
        this.fTypeToFind = null;
        this.fFoundType = false;
        monitor.done();
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean findSubTypes(ITypeInfo info, IProgressMonitor monitor) throws InterruptedException {
        HashMap<IPath, IWorkingCopy> workingCopyMap;
        block17: {
            int i;
            IWorkingCopy[] workingCopies;
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.fScope = new TypeSearchScope();
            ITypeReference[] refs = info.getDerivedReferences();
            if (refs == null) return false;
            if (refs.length == 0) {
                return false;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= refs.length) {
                    workingCopyMap = null;
                    if (this.fWorkingCopyProvider != null && (workingCopies = this.fWorkingCopyProvider.getWorkingCopies()) != null && workingCopies.length > 0) {
                        workingCopyMap = new HashMap<IPath, IWorkingCopy>(workingCopies.length);
                        i = 0;
                        break;
                    }
                    break block17;
                }
                ITypeReference location = refs[i2];
                IPath path = location.getPath();
                this.fScope.add(path, false, null);
                ++i2;
            }
            while (i < workingCopies.length) {
                IWorkingCopy workingCopy = workingCopies[i];
                IPath wcPath = workingCopy.getOriginalElement().getPath();
                if (this.fScope.encloses(wcPath)) {
                    this.fScope.add(wcPath, false, null);
                    workingCopyMap.put(wcPath, workingCopy);
                }
                ++i;
            }
        }
        this.fProject = this.fTypeCache.getProject();
        IPath[] searchPaths = this.fTypeCache.getPaths(this.fScope);
        HashSet workingCopyPaths = new HashSet();
        if (workingCopyMap != null) {
            this.collectWorkingCopiesInProject(workingCopyMap, this.fProject, workingCopyPaths);
        }
        monitor.beginTask("", searchPaths.length + workingCopyPaths.size());
        try {
            IPath path;
            int i;
            this.fTypeToFind = null;
            this.fSuperTypeToFind = info;
            this.fFoundType = false;
            Iterator pathIter = workingCopyPaths.iterator();
            while (true) {
                if (!pathIter.hasNext()) {
                    i = 0;
                    break;
                }
                path = (IPath)pathIter.next();
                this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            while (i < searchPaths.length) {
                path = searchPaths[i];
                if (!workingCopyPaths.contains(path)) {
                    this.parseSource(path, this.fProject, workingCopyMap, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.fTypeToFind = null;
            this.fFoundType = false;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_14 = null;
            this.fTypeToFind = null;
            this.fFoundType = false;
        }
        monitor.done();
        return false;
    }

    private void collectWorkingCopiesInProject(Map workingCopyMap, IProject project, Collection workingCopyPaths) {
        Iterator mapIter = workingCopyMap.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry entry = mapIter.next();
            IPath path = (IPath)entry.getKey();
            IWorkingCopy copy = (IWorkingCopy)entry.getValue();
            ICProject cProject = copy.getCProject();
            if (cProject == null || !cProject.getProject().equals((Object)project)) continue;
            workingCopyPaths.add(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSource(IPath path, IProject project, Map workingCopyMap, IProgressMonitor progressMonitor) throws InterruptedException {
        block14: {
            block13: {
                if (progressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                TypeSearchScope pathScope = new TypeSearchScope();
                pathScope.add(path, false, project);
                int typeCount = this.fTypeCache.getTypes(pathScope).length;
                progressMonitor.beginTask("", typeCount);
                try {
                    ParserLanguage language;
                    IWorkingCopy workingCopy = null;
                    if (workingCopyMap != null) {
                        workingCopy = (IWorkingCopy)workingCopyMap.get(path);
                    }
                    if ((language = this.getLanguage(project, workingCopy)) == null) {
                        Object var14_9 = null;
                        break block13;
                    }
                    CodeReader reader = null;
                    IWorkingCopy stackObject = null;
                    IResource resource = null;
                    if (workingCopy != null) {
                        reader = this.createWorkingCopyReader(workingCopy);
                        resource = workingCopy.getResource();
                        if (resource != null) {
                            path = resource.getLocation();
                        }
                        stackObject = workingCopy;
                    } else {
                        IWorkspaceRoot wsRoot;
                        IWorkspace workspace = CCorePlugin.getWorkspace();
                        if (workspace != null && (wsRoot = workspace.getRoot()) != null) {
                            resource = wsRoot.findMember(path, true);
                        }
                        if (resource != null) {
                            reader = this.createResourceReader(resource);
                            path = resource.getLocation();
                            stackObject = resource;
                        } else {
                            reader = this.createFileReader(path);
                            stackObject = path;
                        }
                    }
                    if (reader != null) {
                        this.fResourceStack.clear();
                        this.fScopeStack.clear();
                        this.fResourceStack.push(stackObject);
                        this.parseContents(path, resource, project, reader, language, progressMonitor);
                        this.fResourceStack.pop();
                    }
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var14_10 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var14_11 = null;
        progressMonitor.done();
    }

    private ParserLanguage getLanguage(IProject project, IWorkingCopy workingCopy) {
        ParserLanguage projectLanguage = null;
        if (project != null) {
            if (CoreModel.hasCCNature(project)) {
                projectLanguage = ParserLanguage.CPP;
            } else if (CoreModel.hasCNature(project)) {
                projectLanguage = ParserLanguage.C;
            }
        }
        if (workingCopy != null) {
            ParserLanguage workingCopyLanguage = null;
            ITranslationUnit unit = workingCopy.getTranslationUnit();
            if (unit != null) {
                if (unit.isCLanguage()) {
                    workingCopyLanguage = ParserLanguage.C;
                } else if (unit.isCXXLanguage()) {
                    workingCopyLanguage = ParserLanguage.CPP;
                }
            }
            if (workingCopyLanguage != null) {
                if (projectLanguage == null) {
                    return workingCopyLanguage;
                }
                if (projectLanguage.equals(ParserLanguage.CPP)) {
                    return projectLanguage;
                }
                return workingCopyLanguage;
            }
        }
        return projectLanguage;
    }

    private CodeReader createWorkingCopyReader(IWorkingCopy workingCopy) {
        char[] contents;
        CodeReader reader = null;
        IResource resource = workingCopy.getResource();
        if (resource != null && resource.isAccessible() && (contents = workingCopy.getContents()) != null) {
            reader = new CodeReader(resource.getLocation().toOSString(), contents);
        }
        return reader;
    }

    /*
     * Exception decompiling
     */
    private CodeReader createResourceReader(IResource resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 109->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CodeReader createFileReader(IPath path) {
        CodeReader reader = null;
        try {
            reader = new CodeReader(path.toOSString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return reader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseContents(IPath realPath, IResource resource, IProject project, CodeReader reader, ParserLanguage language, IProgressMonitor progressMonitor) throws InterruptedException {
        ScannerInfo scanInfo = null;
        if (project != null) {
            try {
                IScannerInfo buildScanInfo;
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
                if (provider != null && (buildScanInfo = provider.getScannerInformation((IResource)(resource != null ? resource : project))) != null) {
                    scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (scanInfo == null) {
            scanInfo = new ScannerInfo();
        }
        try {
            try {
                this.fProgressMonitor = progressMonitor;
                IScanner scanner = ParserFactory.createScanner(reader, (IScannerInfo)scanInfo, ParserMode.STRUCTURAL_PARSE, language, (ISourceElementRequestor)this, ParserUtil.getScannerLogService(), null);
                this.fParser = ParserFactory.createParser(scanner, this, ParserMode.STRUCTURAL_PARSE, language, ParserUtil.getParserLogService());
                int timeout = this.getParserTimeout();
                if (timeout > 0) {
                    this.fTimeoutThread.setTimeout(timeout);
                    this.fTimeoutThread.setParser(this.fParser);
                    while (true) {
                        if (this.fTimeoutThread.isReadyToRun()) {
                            this.fTimeoutThread.startTimer();
                            break;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.fParser.parse();
            }
            catch (ParserFactoryError e) {
                CCorePlugin.log(e);
            }
            catch (ParseError parseError) {
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                CCorePlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.fTimeoutThread.stopTimer();
            this.fTimeoutThread.setParser(null);
            this.fProgressMonitor = null;
            this.fParser = null;
            throw throwable;
        }
        {
            Object var11_17 = null;
            this.fTimeoutThread.stopTimer();
            this.fTimeoutThread.setParser(null);
            this.fProgressMonitor = null;
            this.fParser = null;
            return;
        }
    }

    public boolean acceptProblem(IProblem problem) {
        return DefaultProblemHandler.ruleOnProblem(problem, ParserMode.COMPLETE_PARSE);
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void acceptParameterReference(IASTParameterReference reference) {
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference reference) {
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
    }

    public void acceptClassReference(IASTClassReference reference) {
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
    }

    public void acceptVariableReference(IASTVariableReference reference) {
    }

    public void acceptFieldReference(IASTFieldReference reference) {
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
    }

    public void acceptMethodReference(IASTMethodReference reference) {
    }

    public void acceptField(IASTField field) {
    }

    public void acceptMacro(IASTMacro macro) {
    }

    public void acceptVariable(IASTVariable variable) {
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
    }

    public void acceptMethodDeclaration(IASTMethod method) {
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void acceptFriendDeclaration(IASTDeclaration declaration) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.pushScope(linkageSpec);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.popScope();
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.pushScope(compilationUnit);
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.popScope();
    }

    public void enterFunctionBody(IASTFunction function) {
        this.pushScope(function);
    }

    public void exitFunctionBody(IASTFunction function) {
        this.popScope();
    }

    public void enterMethodBody(IASTMethod method) {
        this.pushScope(method);
    }

    public void exitMethodBody(IASTMethod method) {
        this.popScope();
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.fLastDeclaration = namespaceDefinition;
        this.acceptType(namespaceDefinition);
        this.pushScope(namespaceDefinition);
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.popScope();
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        this.fLastDeclaration = classSpecification;
        this.acceptType(classSpecification);
        this.pushScope(classSpecification);
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.popScope();
    }

    private void pushScope(IASTScope scope) {
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fScopeStack.push(scope);
    }

    private IASTScope popScope() {
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return (IASTScope)this.fScopeStack.pop();
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.fLastDeclaration = typedef;
        this.acceptType(typedef);
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.fLastDeclaration = enumeration;
        this.acceptType(enumeration);
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
    }

    public void enterInclusion(IASTInclusion inclusion) {
        IWorkspaceRoot wsRoot;
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String includePath = inclusion.getFullFileName();
        Path path = new Path(includePath);
        path = PathUtil.getWorkspaceRelativePath((IPath)path);
        IResource resource = null;
        IWorkspace workspace = CCorePlugin.getWorkspace();
        if (workspace != null && (wsRoot = workspace.getRoot()) != null) {
            resource = wsRoot.findMember((IPath)path, true);
        }
        Path stackObject = path;
        if (resource != null) {
            stackObject = resource;
        }
        this.fResourceStack.push(stackObject);
    }

    public void exitInclusion(IASTInclusion inclusion) {
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fResourceStack.pop();
    }

    private void acceptType(ISourceElementCallbackDelegate node) {
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IASTScope currentScope = (IASTScope)this.fScopeStack.top();
        if (currentScope instanceof IASTFunction || currentScope instanceof IASTMethod) {
            return;
        }
        NodeTypeInfo nodeInfo = new NodeTypeInfo();
        if (nodeInfo.parseNodeForTypeInfo(node)) {
            QualifiedTypeName qualifiedName;
            TypeReference originalLocation = null;
            Object originalRef = this.fResourceStack.bottom();
            if (originalRef instanceof IWorkingCopy) {
                IWorkingCopy workingCopy = (IWorkingCopy)originalRef;
                originalLocation = new TypeReference(workingCopy, this.fProject);
            } else if (originalRef instanceof IResource) {
                IResource resource = (IResource)originalRef;
                originalLocation = new TypeReference(resource, this.fProject);
            } else if (originalRef instanceof IPath) {
                IPath path = PathUtil.getProjectRelativePath((IPath)originalRef, this.fProject);
                originalLocation = new TypeReference(path, this.fProject);
            }
            TypeReference resolvedLocation = null;
            Object resolvedRef = this.fResourceStack.top();
            if (resolvedRef instanceof IWorkingCopy) {
                IWorkingCopy workingCopy = (IWorkingCopy)resolvedRef;
                resolvedLocation = new TypeReference(workingCopy, this.fProject, nodeInfo.offset, nodeInfo.end - nodeInfo.offset);
            } else if (resolvedRef instanceof IResource) {
                IResource resource = (IResource)resolvedRef;
                resolvedLocation = new TypeReference(resource, this.fProject, nodeInfo.offset, nodeInfo.end - nodeInfo.offset);
            } else if (resolvedRef instanceof IPath) {
                IPath path = PathUtil.getProjectRelativePath((IPath)resolvedRef, this.fProject);
                resolvedLocation = new TypeReference(path, this.fProject, nodeInfo.offset, nodeInfo.end - nodeInfo.offset);
            }
            if (this.fTypeToFind != null) {
                if ((this.fTypeToFind.getCElementType() == nodeInfo.type || this.fTypeToFind.isUndefinedType()) && nodeInfo.name.equals(this.fTypeToFind.getName()) && (qualifiedName = new QualifiedTypeName(nodeInfo.name, nodeInfo.enclosingNames)).equals(this.fTypeToFind.getQualifiedTypeName())) {
                    ITypeInfo newType = this.addType(nodeInfo.type, qualifiedName, originalLocation, resolvedLocation);
                    if (newType != null && node instanceof IASTClassSpecifier) {
                        this.addSuperClasses(newType, (IASTClassSpecifier)node, originalLocation, this.fProcessedTypes);
                    }
                    this.fProgressMonitor.worked(1);
                    this.fFoundType = true;
                    this.fParser.cancel();
                }
            } else {
                qualifiedName = new QualifiedTypeName(nodeInfo.name, nodeInfo.enclosingNames);
                ITypeInfo newType = this.addType(nodeInfo.type, qualifiedName, originalLocation, resolvedLocation);
                if (newType != null && node instanceof IASTClassSpecifier) {
                    this.addSuperClasses(newType, (IASTClassSpecifier)node, originalLocation, this.fProcessedTypes);
                }
                this.fProgressMonitor.worked(1);
            }
        }
    }

    int getElementType(IASTOffsetableNamedElement offsetable) {
        if (offsetable instanceof IASTClassSpecifier || offsetable instanceof IASTElaboratedTypeSpecifier) {
            ASTClassKind kind = null;
            kind = offsetable instanceof IASTClassSpecifier ? ((IASTClassSpecifier)offsetable).getClassKind() : ((IASTElaboratedTypeSpecifier)offsetable).getClassKind();
            if (kind == ASTClassKind.CLASS) {
                return 65;
            }
            if (kind == ASTClassKind.STRUCT) {
                return 67;
            }
            if (kind == ASTClassKind.UNION) {
                return 69;
            }
        } else {
            if (offsetable instanceof IASTNamespaceDefinition) {
                return 61;
            }
            if (offsetable instanceof IASTEnumerationSpecifier) {
                return 63;
            }
            if (offsetable instanceof IASTTypedefDeclaration) {
                return 80;
            }
        }
        return 0;
    }

    private void addSuperClasses(ITypeInfo type, IASTClassSpecifier classSpec, TypeReference location, Set processedClasses) {
        Iterator baseIter = classSpec.getBaseClauses();
        if (baseIter != null) {
            while (baseIter.hasNext()) {
                IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)baseIter.next();
                try {
                    NodeTypeInfo nodeInfo;
                    ASTAccessVisibility baseAccess = baseSpec.getAccess();
                    IASTClassSpecifier parentClass = null;
                    IASTTypeSpecifier parentSpec = baseSpec.getParentClassSpecifier();
                    if (parentSpec instanceof IASTClassSpecifier) {
                        parentClass = (IASTClassSpecifier)parentSpec;
                    }
                    if (parentClass == null || !(nodeInfo = new NodeTypeInfo()).parseNodeForTypeInfo(parentClass)) continue;
                    ITypeInfo superType = this.addSuperType(type, nodeInfo.type, nodeInfo.name, nodeInfo.enclosingNames, location, baseAccess, baseSpec.isVirtual());
                    if (processedClasses.contains(parentClass)) continue;
                    processedClasses.add(parentClass);
                    this.addSuperClasses(superType, parentClass, location, processedClasses);
                }
                catch (ASTNotImplementedException aSTNotImplementedException) {}
            }
        }
    }

    private ITypeInfo addType(int type, QualifiedTypeName qualifiedName, TypeReference originalLocation, TypeReference resolvedLocation) {
        ITypeInfo info = this.fTypeCache.getType(type, qualifiedName);
        if (info == null || info.isUndefinedType()) {
            if (info != null) {
                info.setCElementType(type);
            } else {
                info = new TypeInfo(type, qualifiedName);
                this.fTypeCache.insert(info);
            }
            info.addReference(originalLocation);
        }
        info.addReference(resolvedLocation);
        return info;
    }

    private ITypeInfo addSuperType(ITypeInfo addToType, int type, String name, String[] enclosingNames, TypeReference location, ASTAccessVisibility access, boolean isVirtual) {
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo superType = this.fTypeCache.getType(type, qualifiedName);
        if (superType == null || superType.isUndefinedType()) {
            if (superType != null) {
                superType.setCElementType(type);
            } else {
                superType = new TypeInfo(type, qualifiedName);
                this.fTypeCache.insert(superType);
            }
        }
        superType.addDerivedReference(location);
        if (this.fSuperTypeToFind != null) {
            this.fSuperTypeToFind.equals(superType);
        }
        this.fTypeCache.addSupertype(addToType, superType, access, isVirtual);
        this.fTypeCache.addSubtype(superType, addToType);
        return superType;
    }

    public CodeReader createReader(String finalPath, Iterator workingCopies) {
        return ParserUtil.createReader(finalPath, workingCopies);
    }

    public int getParserTimeout() {
        int timeout = 0;
        try {
            int val;
            String str = CCorePlugin.getDefault().getPluginPreferences().getString("CDT_INDEXER_TIMEOUT");
            if (str != null && str.length() > 0 && (val = Integer.valueOf(str).intValue()) > 0) {
                timeout = val;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (timeout == 0) {
            timeout = 30;
        }
        return timeout;
    }

    private class NodeTypeInfo {
        int type;
        String name;
        String[] enclosingNames;
        int offset;
        int end;
        IASTOffsetableNamedElement offsetable;

        NodeTypeInfo() {
        }

        void init() {
            this.type = 0;
            this.name = null;
            this.enclosingNames = null;
            this.offset = 0;
            this.end = 0;
            this.offsetable = null;
        }

        boolean parseNodeForTypeInfo(ISourceElementCallbackDelegate node) {
            String[] names;
            this.init();
            if (node instanceof IASTReference) {
                IASTReference reference = (IASTReference)node;
                this.offset = reference.getOffset();
                this.end = this.offset + reference.getName().length();
            } else if (node instanceof IASTOffsetableNamedElement) {
                this.offsetable = (IASTOffsetableNamedElement)((Object)node);
                this.offset = this.offsetable.getNameOffset() != 0 ? this.offsetable.getNameOffset() : this.offsetable.getStartingOffset();
                this.end = this.offsetable.getNameEndOffset();
                if (this.end == 0) {
                    this.end = this.offset + this.offsetable.getName().length();
                }
            }
            if (node instanceof IASTReference) {
                node = TypeParser.this.fLastDeclaration;
            }
            if (node instanceof IASTReference) {
                this.offsetable = (IASTOffsetableNamedElement)((Object)((IASTReference)node).getReferencedElement());
                this.name = ((IASTReference)node).getName();
            } else if (node instanceof IASTOffsetableNamedElement) {
                this.offsetable = (IASTOffsetableNamedElement)((Object)node);
                this.name = this.offsetable.getName();
            } else {
                return false;
            }
            if (this.name == null || this.name.length() == 0) {
                return false;
            }
            this.type = TypeParser.this.getElementType(this.offsetable);
            if (this.type == 0) {
                return false;
            }
            if (this.offsetable instanceof IASTQualifiedNameElement && (names = ((IASTQualifiedNameElement)((Object)this.offsetable)).getFullyQualifiedName()) != null && names.length > 1) {
                this.enclosingNames = new String[names.length - 1];
                System.arraycopy(names, 0, this.enclosingNames, 0, names.length - 1);
            }
            return true;
        }
    }
}

