/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.gnu.c.IGCCASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CArrayType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumeration;
import org.eclipse.cdt.internal.core.dom.parser.c.CEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.c.CExternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CField;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CLabel;
import org.eclipse.cdt.internal.core.dom.parser.c.CParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifiedPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CStructure;
import org.eclipse.cdt.internal.core.dom.parser.c.CTypedef;
import org.eclipse.cdt.internal.core.dom.parser.c.CVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.core.runtime.PlatformObject;

public class CVisitor {
    protected static final ASTNodeProperty STRING_LOOKUP_PROPERTY = new ASTNodeProperty("CVisitor.STRING_LOOKUP_PROPERTY - STRING_LOOKUP");
    protected static final ASTNodeProperty STRING_LOOKUP_TAGS_PROPERTY = new ASTNodeProperty("CVisitor.STRING_LOOKUP_TAGS_PROPERTY - STRING_LOOKUP");
    private static final String SIZE_T = "size_t";
    public static final String EMPTY_STRING = "";
    public static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();
    private static final int COMPLETE = 0;
    private static final int CURRENT_SCOPE = 1;
    private static final int TAGS = 2;
    private static final int INCLUDE_BLOCK_ITEM = 4;
    private static final int PREFIX_LOOKUP = 8;
    protected static final int AT_BEGINNING = 1;
    protected static final int AT_NEXT = 2;
    static /* synthetic */ Class class$0;

    protected static void createBinding(IASTName name) {
        IBinding binding = null;
        IASTNode parent = name.getParent();
        if (parent instanceof CASTIdExpression) {
            binding = CVisitor.resolveBinding(parent, 4);
        } else if (parent instanceof ICASTTypedefNameSpecifier) {
            binding = CVisitor.resolveBinding(parent);
        } else if (parent instanceof IASTFieldReference) {
            binding = (IBinding)CVisitor.findBinding((IASTFieldReference)parent, false);
        } else if (parent instanceof IASTDeclarator) {
            binding = CVisitor.createBinding((IASTDeclarator)parent, name);
        } else if (parent instanceof ICASTCompositeTypeSpecifier) {
            binding = CVisitor.createBinding((ICASTCompositeTypeSpecifier)parent);
        } else if (parent instanceof ICASTElaboratedTypeSpecifier) {
            binding = CVisitor.createBinding((ICASTElaboratedTypeSpecifier)parent);
        } else if (parent instanceof IASTStatement) {
            binding = CVisitor.createBinding((IASTStatement)parent);
        } else if (parent instanceof ICASTEnumerationSpecifier) {
            binding = CVisitor.createBinding((ICASTEnumerationSpecifier)parent);
        } else if (parent instanceof IASTEnumerationSpecifier.IASTEnumerator) {
            binding = CVisitor.createBinding((IASTEnumerationSpecifier.IASTEnumerator)parent);
        } else if (parent instanceof ICASTFieldDesignator) {
            binding = CVisitor.resolveBinding(parent);
        }
        name.setBinding(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IBinding createBinding(ICASTEnumerationSpecifier enumeration) {
        IBinding binding;
        IASTName name = enumeration.getName();
        ICScope scope = (ICScope)CVisitor.getContainingScope(enumeration);
        try {
            binding = scope.getBinding(name, false);
        }
        catch (DOMException dOMException) {
            binding = null;
        }
        if (binding != null) {
            if (!(binding instanceof CEnumeration)) return new ProblemBinding(name, 2, name.toCharArray());
            ((CEnumeration)binding).addDefinition(name);
            return binding;
        }
        binding = new CEnumeration(name);
        try {
            scope.addName(name);
            return binding;
        }
        catch (DOMException dOMException) {}
        return binding;
    }

    private static IBinding createBinding(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        CEnumerator binding = new CEnumerator(enumerator);
        try {
            ((ICScope)binding.getScope()).addName(enumerator.getName());
        }
        catch (DOMException dOMException) {}
        return binding;
    }

    private static IBinding createBinding(IASTStatement statement) {
        if (statement instanceof IASTGotoStatement) {
            char[] gotoName = ((IASTGotoStatement)statement).getName().toCharArray();
            IScope scope = CVisitor.getContainingScope(statement);
            if (scope != null && scope instanceof ICFunctionScope) {
                CFunctionScope functionScope = (CFunctionScope)scope;
                ILabel[] labels = functionScope.getLabels();
                int i = 0;
                while (i < labels.length) {
                    ILabel label = labels[i];
                    if (CharArrayUtils.equals(label.getNameCharArray(), gotoName)) {
                        return label;
                    }
                    ++i;
                }
                return new CLabel.CLabelProblem(((IASTGotoStatement)statement).getName(), 9, gotoName);
            }
        } else if (statement instanceof IASTLabelStatement) {
            IASTName name = ((IASTLabelStatement)statement).getName();
            CLabel binding = new CLabel(name);
            try {
                ((ICFunctionScope)binding.getScope()).addName(name);
            }
            catch (DOMException dOMException) {}
            return binding;
        }
        return null;
    }

    private static IBinding createBinding(ICASTElaboratedTypeSpecifier elabTypeSpec) {
        IASTNode parent = elabTypeSpec.getParent();
        if (parent instanceof IASTDeclaration) {
            int bits = 2;
            if (parent instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)parent).getDeclarators().length == 0) {
                bits |= 1;
            }
            IASTName name = elabTypeSpec.getName();
            IBinding binding = CVisitor.resolveBinding(elabTypeSpec, bits);
            if (binding != null) {
                if (binding instanceof CEnumeration) {
                    ((CEnumeration)binding).addDeclaration(name);
                }
            } else {
                binding = elabTypeSpec.getKind() == 0 ? new CEnumeration(name) : new CStructure(name);
                try {
                    ((ICScope)binding.getScope()).addName(name);
                }
                catch (DOMException dOMException) {}
            }
            return binding;
        }
        if (parent instanceof IASTTypeId || parent instanceof IASTParameterDeclaration) {
            IASTNode blockItem = CVisitor.getContainingBlockItem(parent);
            try {
                return (IBinding)CVisitor.findBinding(blockItem, elabTypeSpec.getName(), 2);
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        return null;
    }

    private static Object findBinding(IASTFieldReference fieldReference, boolean prefix) {
        IASTExpression fieldOwner = fieldReference.getFieldOwner();
        IType type = null;
        type = fieldOwner instanceof IASTArraySubscriptExpression ? CVisitor.getExpressionType(((IASTArraySubscriptExpression)fieldOwner).getArrayExpression()) : CVisitor.getExpressionType(fieldOwner);
        while (type != null && type instanceof ITypeContainer) {
            try {
                type = ((ITypeContainer)type).getType();
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        if (type != null && type instanceof ICompositeType) {
            if (prefix) {
                Object[] result = null;
                try {
                    char[] p = fieldReference.getFieldName().toCharArray();
                    IField[] fields = ((ICompositeType)type).getFields();
                    int i = 0;
                    while (i < fields.length) {
                        if (CharArrayUtils.equals(fields[i].getNameCharArray(), 0, p.length, p)) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            result = (IBinding[])ArrayUtil.append(clazz, result, fields[i]);
                        }
                        ++i;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ArrayUtil.trim(clazz, result);
                }
                catch (DOMException e) {
                    return new IBinding[]{e.getProblem()};
                }
            }
            try {
                return ((ICompositeType)type).findField(fieldReference.getFieldName().toString());
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        return null;
    }

    public static IType getExpressionType(IASTExpression expression) {
        try {
            if (expression instanceof IASTIdExpression) {
                IBinding binding = ((IASTIdExpression)expression).getName().resolveBinding();
                if (binding instanceof IVariable) {
                    return ((IVariable)binding).getType();
                }
            } else {
                if (expression instanceof IASTCastExpression) {
                    IASTTypeId id = ((IASTCastExpression)expression).getTypeId();
                    return CVisitor.createType(id.getAbstractDeclarator());
                }
                if (expression instanceof IASTFieldReference) {
                    IBinding binding = ((IASTFieldReference)expression).getFieldName().resolveBinding();
                    if (binding instanceof IVariable) {
                        return ((IVariable)binding).getType();
                    }
                } else if (expression instanceof IASTFunctionCallExpression) {
                    IType type = CVisitor.getExpressionType(((IASTFunctionCallExpression)expression).getFunctionNameExpression());
                    while (type instanceof ITypeContainer) {
                        type = ((ITypeContainer)type).getType();
                    }
                    if (type instanceof IFunctionType) {
                        return ((IFunctionType)type).getReturnType();
                    }
                } else {
                    if (expression instanceof IASTUnaryExpression) {
                        IType type = CVisitor.getExpressionType(((IASTUnaryExpression)expression).getOperand());
                        int op = ((IASTUnaryExpression)expression).getOperator();
                        if (op == 4 && (type instanceof IPointerType || type instanceof IArrayType)) {
                            return ((ITypeContainer)type).getType();
                        }
                        if (op == 5) {
                            return new CPointerType(type, 0);
                        }
                        return type;
                    }
                    if (expression instanceof IASTLiteralExpression) {
                        switch (((IASTLiteralExpression)expression).getKind()) {
                            case 2: {
                                return new CBasicType(2, 0, expression);
                            }
                            case 1: {
                                return new CBasicType(4, 0, expression);
                            }
                            case 0: {
                                return new CBasicType(3, 0, expression);
                            }
                            case 3: {
                                IType type = new CBasicType(2, 0, expression);
                                type = new CQualifierType(type, true, false, false);
                                return new CPointerType(type, 0);
                            }
                        }
                    } else {
                        if (expression instanceof IASTBinaryExpression) {
                            IASTBinaryExpression binary = (IASTBinaryExpression)expression;
                            int op = binary.getOperator();
                            IType result = null;
                            switch (op) {
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 15: 
                                case 16: 
                                case 28: 
                                case 29: {
                                    result = new CBasicType(3, 0);
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    IType t = CVisitor.getExpressionType(((IASTBinaryExpression)expression).getOperand1());
                                    if (t instanceof IPointerType) {
                                        result = t;
                                        break;
                                    }
                                    result = CVisitor.getExpressionType(((IASTBinaryExpression)expression).getOperand2());
                                    break;
                                }
                                default: {
                                    result = CVisitor.getExpressionType(((IASTBinaryExpression)expression).getOperand1());
                                }
                            }
                            if (result instanceof CBasicType) {
                                ((CBasicType)result).setValue(expression);
                            }
                            return result;
                        }
                        if (expression instanceof IASTUnaryExpression) {
                            int op = ((IASTUnaryExpression)expression).getOperator();
                            if (op == 8) {
                                IScope scope = CVisitor.getContainingScope(expression);
                                IBinding[] bs = scope.find(SIZE_T);
                                if (bs.length > 0 && bs[0] instanceof IType) {
                                    return (IType)((Object)bs[0]);
                                }
                                return new CBasicType(3, 17, expression);
                            }
                            IType type = CVisitor.getExpressionType(((IASTUnaryExpression)expression).getOperand());
                            if (op == 4 && (type instanceof IPointerType || type instanceof IArrayType)) {
                                try {
                                    return ((ITypeContainer)type).getType();
                                }
                                catch (DOMException e) {
                                    return e.getProblem();
                                }
                            }
                            if (op == 5) {
                                return new CPointerType(type, 0);
                            }
                            if (type instanceof CBasicType) {
                                ((CBasicType)type).setValue(expression);
                            }
                            return type;
                        }
                        if (expression instanceof IASTFieldReference) {
                            IBinding binding = (IBinding)CVisitor.findBinding((IASTFieldReference)expression, false);
                            if (binding instanceof IVariable) {
                                return ((IVariable)binding).getType();
                            }
                            if (binding instanceof IFunction) {
                                return ((IFunction)binding).getType();
                            }
                            if (binding instanceof IEnumerator) {
                                return ((IEnumerator)binding).getType();
                            }
                        } else {
                            if (expression instanceof IASTExpressionList) {
                                IASTExpression[] exps = ((IASTExpressionList)expression).getExpressions();
                                return CVisitor.getExpressionType(exps[exps.length - 1]);
                            }
                            if (expression instanceof IASTTypeIdExpression) {
                                IASTTypeIdExpression typeidExp = (IASTTypeIdExpression)expression;
                                if (typeidExp.getOperator() == 0) {
                                    IScope scope = CVisitor.getContainingScope(typeidExp);
                                    IBinding[] bs = scope.find(SIZE_T);
                                    if (bs.length > 0 && bs[0] instanceof IType) {
                                        return (IType)((Object)bs[0]);
                                    }
                                    return new CBasicType(3, 17);
                                }
                                return CVisitor.createType(typeidExp.getTypeId().getAbstractDeclarator());
                            }
                            if (expression instanceof IASTArraySubscriptExpression) {
                                IType t = CVisitor.getExpressionType(((IASTArraySubscriptExpression)expression).getArrayExpression());
                                if (t instanceof IPointerType) {
                                    return ((IPointerType)t).getType();
                                }
                                if (t instanceof IArrayType) {
                                    return ((IArrayType)t).getType();
                                }
                            } else if (expression instanceof IGNUASTCompoundStatementExpression) {
                                IASTStatement st;
                                IASTCompoundStatement compound = ((IGNUASTCompoundStatementExpression)expression).getCompoundStatement();
                                IASTStatement[] statements = compound.getStatements();
                                if (statements.length > 0 && (st = statements[statements.length - 1]) instanceof IASTExpressionStatement) {
                                    return CVisitor.getExpressionType(((IASTExpressionStatement)st).getExpression());
                                }
                            } else if (expression instanceof IASTConditionalExpression) {
                                IASTConditionalExpression conditional = (IASTConditionalExpression)expression;
                                IType t2 = CVisitor.getExpressionType(conditional.getPositiveResultExpression());
                                IType t3 = CVisitor.getExpressionType(conditional.getNegativeResultExpression());
                                if (t3 instanceof IPointerType || t2 == null) {
                                    return t3;
                                }
                                return t2;
                            }
                        }
                    }
                }
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return null;
    }

    private static IBinding createBinding(IASTDeclarator declarator, IASTName name) {
        IBinding binding = null;
        if (declarator instanceof ICASTKnRFunctionDeclarator) {
            IASTNode parent = declarator.getParent();
            if (CharArrayUtils.equals(declarator.getName().toCharArray(), name.toCharArray())) {
                binding = CVisitor.resolveBinding(parent, 1);
                if (binding != null) {
                    if (binding instanceof ICInternalFunction) {
                        ((ICInternalFunction)((Object)binding)).addDeclarator((ICASTKnRFunctionDeclarator)declarator);
                    } else {
                        binding = new ProblemBinding(name, 2, name.toCharArray());
                    }
                } else {
                    binding = CVisitor.createBinding(declarator);
                }
            } else {
                ICScope scope;
                IBinding f = declarator.getName().resolveBinding();
                if (f instanceof CFunction) {
                    binding = ((CFunction)f).resolveParameter(name);
                }
                if (declarator.getParent() instanceof IASTFunctionDefinition && (scope = (ICScope)((IASTCompoundStatement)((IASTFunctionDefinition)declarator.getParent()).getBody()).getScope()) != null && binding != null) {
                    try {
                        scope.addName(name);
                    }
                    catch (DOMException dOMException) {}
                }
            }
        } else {
            binding = CVisitor.createBinding(declarator);
        }
        return binding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IBinding createBinding(IASTDeclarator declarator) {
        IASTNode parent = declarator.getParent();
        while (parent instanceof IASTDeclarator) {
            parent = parent.getParent();
        }
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        ICScope scope = (ICScope)CVisitor.getContainingScope(parent);
        ASTNodeProperty prop = parent.getPropertyInParent();
        if (prop == IASTDeclarationStatement.DECLARATION && (prop = parent.getParent().getPropertyInParent()) != IASTCompoundStatement.NESTED_STATEMENT) {
            scope = null;
        }
        IASTName name = declarator.getName();
        IBinding binding = null;
        try {
            binding = scope != null ? scope.getBinding(name, false) : null;
        }
        catch (DOMException dOMException) {
            binding = null;
        }
        if (parent instanceof IASTParameterDeclaration || parent.getPropertyInParent() == ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER) {
            IASTFunctionDeclarator fdtor = (IASTFunctionDeclarator)parent.getParent();
            IBinding temp = fdtor.getName().resolveBinding();
            if (temp != null && temp instanceof CFunction) {
                binding = ((CFunction)temp).resolveParameter(name);
            } else if (temp instanceof IFunction) {
                binding = new CParameter(name);
            }
            try {
                if (scope != null && scope.getPhysicalNode() instanceof IASTTranslationUnit) {
                    return binding;
                }
            }
            catch (DOMException dOMException) {}
        } else if (declarator instanceof IASTFunctionDeclarator) {
            if (binding != null) {
                if (binding instanceof IFunction) {
                    IFunction function = (IFunction)binding;
                    if (!(function instanceof CFunction)) return function;
                    ((CFunction)function).addDeclarator((IASTFunctionDeclarator)declarator);
                    return function;
                }
                binding = new ProblemBinding(name, 2, name.toCharArray());
            } else {
                binding = parent instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)parent).getDeclSpecifier().getStorageClass() == 1 ? new CTypedef(name) : new CFunction((IASTFunctionDeclarator)declarator);
            }
        } else if (parent instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)parent;
            if (simpleDecl.getDeclSpecifier().getStorageClass() == 1) {
                binding = new CTypedef(name);
            } else {
                IType t1 = null;
                IType t2 = null;
                if (binding != null) {
                    if (binding instanceof IParameter) {
                        return new ProblemBinding(name, 12, name.toCharArray());
                    }
                    if (binding instanceof IVariable) {
                        t1 = CVisitor.createType(declarator);
                        try {
                            t2 = ((IVariable)binding).getType();
                        }
                        catch (DOMException dOMException) {}
                        if (t1 == null || t2 == null || !t1.isSameType(t2)) return new ProblemBinding(name, 12, name.toCharArray());
                        if (binding instanceof CVariable) {
                            ((CVariable)binding).addDeclaration(name);
                        }
                    }
                } else {
                    binding = simpleDecl.getParent() instanceof ICASTCompositeTypeSpecifier ? new CField(name) : new CVariable(name);
                }
            }
        }
        if (scope == null || binding == null) return binding;
        try {
            scope.addName(name);
            return binding;
        }
        catch (DOMException dOMException) {}
        return binding;
    }

    private static IBinding createBinding(ICASTCompositeTypeSpecifier compositeTypeSpec) {
        ICScope scope = null;
        IBinding binding = null;
        IASTName name = compositeTypeSpec.getName();
        try {
            scope = (ICScope)CVisitor.getContainingScope(compositeTypeSpec);
            while (scope instanceof ICCompositeTypeScope) {
                scope = (ICScope)scope.getParent();
            }
            binding = scope.getBinding(name, false);
            if (binding != null) {
                if (binding instanceof CStructure) {
                    ((CStructure)binding).addDefinition(compositeTypeSpec);
                }
                return binding;
            }
        }
        catch (DOMException dOMException) {}
        binding = new CStructure(name);
        try {
            scope = (ICScope)binding.getScope();
            scope.addName(name);
        }
        catch (DOMException dOMException) {}
        return binding;
    }

    protected static IBinding resolveBinding(IASTNode node) {
        return CVisitor.resolveBinding(node, 0);
    }

    protected static IBinding resolveBinding(IASTNode node, int bits) {
        block48: {
            IASTNode blockItem;
            if (node instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition functionDef = (IASTFunctionDefinition)node;
                IASTFunctionDeclarator functionDeclartor = functionDef.getDeclarator();
                IASTName name = functionDeclartor.getName();
                IASTNode blockItem2 = CVisitor.getContainingBlockItem(node);
                try {
                    return (IBinding)CVisitor.findBinding(blockItem2, name, bits);
                }
                catch (DOMException dOMException) {
                    return null;
                }
            }
            if (node instanceof IASTIdExpression) {
                IASTNode blockItem3 = CVisitor.getContainingBlockItem(node);
                try {
                    IBinding binding = (IBinding)CVisitor.findBinding(blockItem3, ((IASTIdExpression)node).getName(), bits);
                    if (binding instanceof IType && !(binding instanceof IProblemBinding)) {
                        return new ProblemBinding(node, 5, binding.getNameCharArray());
                    }
                    return binding;
                }
                catch (DOMException dOMException) {
                    return null;
                }
            }
            if (node instanceof ICASTTypedefNameSpecifier) {
                IASTNode blockItem4 = CVisitor.getContainingBlockItem(node);
                try {
                    IBinding binding = (IBinding)CVisitor.findBinding(blockItem4, ((ICASTTypedefNameSpecifier)node).getName(), bits);
                    if (binding instanceof IType) {
                        return binding;
                    }
                    if (binding != null) {
                        return new ProblemBinding(node, 5, binding.getNameCharArray());
                    }
                    break block48;
                }
                catch (DOMException dOMException) {
                    return null;
                }
            }
            if (node instanceof ICASTElaboratedTypeSpecifier) {
                IASTNode blockItem5 = CVisitor.getContainingBlockItem(node);
                try {
                    return (IBinding)CVisitor.findBinding(blockItem5, ((ICASTElaboratedTypeSpecifier)node).getName(), bits);
                }
                catch (DOMException dOMException) {
                    return null;
                }
            }
            if (node instanceof ICASTCompositeTypeSpecifier) {
                IASTNode blockItem6 = CVisitor.getContainingBlockItem(node);
                try {
                    return (IBinding)CVisitor.findBinding(blockItem6, ((ICASTCompositeTypeSpecifier)node).getName(), bits);
                }
                catch (DOMException dOMException) {
                    return null;
                }
            }
            if (node instanceof IASTTypeId) {
                IASTTypeId typeId = (IASTTypeId)node;
                IASTDeclSpecifier declSpec = typeId.getDeclSpecifier();
                IASTName name = null;
                if (declSpec instanceof ICASTElaboratedTypeSpecifier) {
                    name = ((ICASTElaboratedTypeSpecifier)declSpec).getName();
                } else if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                    name = ((ICASTCompositeTypeSpecifier)declSpec).getName();
                } else if (declSpec instanceof ICASTTypedefNameSpecifier) {
                    name = ((ICASTTypedefNameSpecifier)declSpec).getName();
                }
                if (name != null) {
                    IBinding binding = name.resolveBinding();
                    if (binding instanceof IType) {
                        return binding;
                    }
                    if (binding != null) {
                        return new ProblemBinding(node, 5, binding.getNameCharArray());
                    }
                    return null;
                }
            } else if (node instanceof ICASTFieldDesignator && ((blockItem = CVisitor.getContainingBlockItem(node)) instanceof IASTSimpleDeclaration || blockItem instanceof IASTDeclarationStatement && ((IASTDeclarationStatement)blockItem).getDeclaration() instanceof IASTSimpleDeclaration)) {
                IASTSimpleDeclaration simpleDecl = null;
                if (blockItem instanceof IASTDeclarationStatement && ((IASTDeclarationStatement)blockItem).getDeclaration() instanceof IASTSimpleDeclaration) {
                    simpleDecl = (IASTSimpleDeclaration)((IASTDeclarationStatement)blockItem).getDeclaration();
                } else if (blockItem instanceof IASTSimpleDeclaration) {
                    simpleDecl = (IASTSimpleDeclaration)blockItem;
                }
                if (simpleDecl != null) {
                    IBinding struct = null;
                    if (simpleDecl.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                        struct = ((IASTNamedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                    } else if (simpleDecl.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                        struct = ((IASTElaboratedTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                    } else if (simpleDecl.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                        struct = ((IASTCompositeTypeSpecifier)simpleDecl.getDeclSpecifier()).getName().resolveBinding();
                    }
                    if (struct instanceof CStructure) {
                        try {
                            return ((CStructure)struct).findField(((ICASTFieldDesignator)node).getName().toString());
                        }
                        catch (DOMException e) {
                            return e.getProblem();
                        }
                    }
                    if (struct instanceof ITypeContainer) {
                        IType type;
                        try {
                            type = ((ITypeContainer)((Object)struct)).getType();
                            while (type instanceof ITypeContainer && !(type instanceof CStructure)) {
                                type = ((ITypeContainer)type).getType();
                            }
                        }
                        catch (DOMException e) {
                            return e.getProblem();
                        }
                        if (type instanceof CStructure) {
                            try {
                                return ((CStructure)type).findField(((ICASTFieldDesignator)node).getName().toString());
                            }
                            catch (DOMException e1) {
                                return e1.getProblem();
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IScope getContainingScope(IASTNode node) {
        if (node != null) ** GOTO lbl28
        return null;
lbl-1000:
        // 1 sources

        {
            if (node instanceof IASTDeclaration) {
                parent = node.getParent();
                if (parent instanceof IASTTranslationUnit) {
                    return ((IASTTranslationUnit)parent).getScope();
                }
                if (parent instanceof IASTDeclarationStatement) {
                    return CVisitor.getContainingScope((IASTStatement)parent);
                }
                if (parent instanceof IASTForStatement) {
                    return ((IASTForStatement)parent).getScope();
                }
                if (parent instanceof IASTCompositeTypeSpecifier) {
                    return ((IASTCompositeTypeSpecifier)parent).getScope();
                }
                if (parent instanceof ICASTKnRFunctionDeclarator && (parent = ((IASTDeclarator)parent).getParent()) instanceof IASTFunctionDefinition) {
                    return ((IASTCompoundStatement)((IASTFunctionDefinition)parent).getBody()).getScope();
                }
            } else {
                if (node instanceof IASTStatement) {
                    return CVisitor.getContainingScope((IASTStatement)node);
                }
                if (node instanceof IASTParameterDeclaration) {
                    parent = node.getParent();
                    if (parent instanceof IASTStandardFunctionDeclarator) {
                        if ((parent = ((IASTDeclarator)parent).getParent()) instanceof IASTFunctionDefinition) {
                            return ((IASTCompoundStatement)((IASTFunctionDefinition)parent).getBody()).getScope();
                        }
                        return null;
                    }
                } else if (node instanceof IASTEnumerationSpecifier.IASTEnumerator) {
                    node = node.getParent();
                }
            }
            node = node.getParent();
lbl28:
            // 2 sources

            ** while (node != null)
        }
lbl29:
        // 1 sources

        return null;
    }

    public static IScope getContainingScope(IASTStatement statement) {
        IASTNode parent = statement.getParent();
        IScope scope = null;
        if (parent instanceof IASTCompoundStatement) {
            IASTCompoundStatement compound = (IASTCompoundStatement)parent;
            scope = compound.getScope();
        } else if (parent instanceof IASTStatement) {
            scope = CVisitor.getContainingScope((IASTStatement)parent);
        } else if (parent instanceof IASTFunctionDefinition) {
            IASTFunctionDeclarator fnDeclarator = ((IASTFunctionDefinition)parent).getDeclarator();
            IBinding function = fnDeclarator.getName().resolveBinding();
            try {
                if (function instanceof IFunction) {
                    scope = ((IFunction)function).getFunctionScope();
                } else if (function instanceof ProblemBinding) {
                    return (IScope)((Object)function);
                }
            }
            catch (DOMException e) {
                return e.getProblem();
            }
        }
        if (statement instanceof IASTGotoStatement || statement instanceof IASTLabelStatement) {
            while (scope != null && !(scope instanceof ICFunctionScope)) {
                try {
                    scope = scope.getParent();
                }
                catch (DOMException e) {
                    scope = e.getProblem();
                }
            }
        }
        return scope;
    }

    private static IASTNode getContainingBlockItem(IASTNode node) {
        IASTNode parent = node.getParent();
        if (parent instanceof IASTDeclaration) {
            IASTNode p = parent.getParent();
            if (p instanceof IASTDeclarationStatement) {
                return p;
            }
            return parent;
        }
        if (parent instanceof IASTCompoundStatement || parent instanceof IASTTranslationUnit || parent instanceof IASTForStatement || parent instanceof IASTFunctionDeclarator) {
            return node;
        }
        return CVisitor.getContainingBlockItem(parent);
    }

    protected static Object findBinding(IASTNode blockItem, IASTName name, int bits) throws DOMException {
        boolean prefix = (bits & 8) != 0;
        Object binding = prefix ? new ObjectSet(2) : null;
        CharArrayObjectMap prefixMap = prefix ? new CharArrayObjectMap(2) : null;
        while (blockItem != null) {
            boolean includeBlockItem;
            IASTNode parent = blockItem.getParent();
            IASTNode[] nodes = null;
            ICScope scope = null;
            if (parent instanceof IASTCompoundStatement) {
                IASTCompoundStatement compound = (IASTCompoundStatement)parent;
                scope = (ICScope)compound.getScope();
                if (parent.getParent() instanceof IASTFunctionDefinition) {
                    IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)parent.getParent()).getDeclarator();
                    if (dtor instanceof IASTStandardFunctionDeclarator) {
                        nodes = ((IASTStandardFunctionDeclarator)dtor).getParameters();
                    } else if (dtor instanceof ICASTKnRFunctionDeclarator) {
                        nodes = ((ICASTKnRFunctionDeclarator)dtor).getParameterDeclarations();
                    }
                }
                if (nodes == null || nodes.length == 0) {
                    nodes = compound.getStatements();
                }
            } else if (parent instanceof IASTTranslationUnit) {
                IASTTranslationUnit translation = (IASTTranslationUnit)parent;
                nodes = translation.getDeclarations();
                scope = (ICScope)translation.getScope();
            } else if (parent instanceof IASTStandardFunctionDeclarator) {
                IASTStandardFunctionDeclarator dtor = (IASTStandardFunctionDeclarator)parent;
                nodes = dtor.getParameters();
                scope = (ICScope)CVisitor.getContainingScope(blockItem);
            } else if (parent instanceof ICASTKnRFunctionDeclarator) {
                ICASTKnRFunctionDeclarator dtor = (ICASTKnRFunctionDeclarator)parent;
                nodes = dtor.getParameterDeclarations();
                scope = (ICScope)CVisitor.getContainingScope(blockItem);
            }
            boolean typesOnly = (bits & 2) != 0;
            boolean bl = includeBlockItem = (bits & 4) != 0;
            if (prefix) {
                scope = null;
            }
            if (scope != null && scope.isFullyCached()) {
                try {
                    binding = scope.getBinding(name, true);
                }
                catch (DOMException dOMException) {
                    binding = null;
                }
                if (binding != null) {
                    return binding;
                }
            } else {
                if (!prefix && scope != null && scope.getParent() == null && scope.getBinding(name, false) != null) {
                    binding = scope.getBinding(name, false);
                    return binding;
                }
                IASTName result = null;
                boolean reachedBlockItem = false;
                if (nodes != null) {
                    int idx = -1;
                    IASTNode node = nodes != null ? (nodes.length > 0 ? nodes[++idx] : null) : parent;
                    while (node != null) {
                        IASTName candidate = null;
                        try {
                            candidate = CVisitor.checkForBinding(scope, node, name, typesOnly, prefixMap);
                        }
                        catch (DOMException dOMException) {
                            continue;
                        }
                        if (result == null && !reachedBlockItem && (includeBlockItem || node != blockItem)) {
                            result = candidate;
                        }
                        if (node == blockItem) {
                            reachedBlockItem = true;
                        }
                        if (idx > -1 && ++idx < nodes.length) {
                            node = nodes[idx];
                            continue;
                        }
                        node = null;
                        if (nodes[0].getPropertyInParent() != ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER && nodes[0].getPropertyInParent() != IASTStandardFunctionDeclarator.FUNCTION_PARAMETER) continue;
                        IASTCompoundStatement compound = null;
                        if (parent instanceof IASTCompoundStatement) {
                            compound = (IASTCompoundStatement)parent;
                        } else if (parent instanceof IASTFunctionDeclarator) {
                            IASTNode n = parent.getParent();
                            while (n instanceof IASTDeclarator) {
                                n = n.getParent();
                            }
                            if (n instanceof IASTFunctionDefinition) {
                                compound = (IASTCompoundStatement)((IASTFunctionDefinition)n).getBody();
                            }
                        }
                        if (compound == null || (nodes = compound.getStatements()).length <= 0) continue;
                        idx = 0;
                        node = nodes[0];
                    }
                } else {
                    try {
                        result = CVisitor.checkForBinding(scope, parent, name, typesOnly, prefixMap);
                    }
                    catch (DOMException dOMException) {}
                }
                if (scope != null) {
                    try {
                        scope.setFullyCached(true);
                    }
                    catch (DOMException dOMException) {}
                }
                if (result != null) {
                    return result.resolveBinding();
                }
            }
            if ((blockItem = (bits & 1) == 0 ? parent : null) instanceof IASTTranslationUnit) break;
        }
        if (prefixMap != null) {
            Object[] result = null;
            Object[] vals = prefixMap.valueArray();
            int i = 0;
            while (i < vals.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (IBinding[])ArrayUtil.append(clazz, result, ((IASTName)vals[i]).resolveBinding());
                ++i;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ArrayUtil.trim(clazz, result);
        }
        if (blockItem != null) {
            IASTTranslationUnit tu = (IASTTranslationUnit)blockItem;
            IPDOM pdom = tu.getIndex();
            binding = null;
            if (pdom != null) {
                binding = pdom.resolveBinding(name);
            }
            if (binding == null) {
                return CVisitor.externalBinding((IASTTranslationUnit)blockItem, name);
            }
            return binding;
        }
        return null;
    }

    private static IBinding externalBinding(IASTTranslationUnit tu, IASTName name) {
        IASTNode parent = name.getParent();
        PlatformObject external = null;
        if (parent instanceof IASTIdExpression) {
            if (parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                external = new CExternalFunction(tu, name);
                ((CScope)tu.getScope()).addName(name);
            } else {
                external = new ProblemBinding(name, 1, name.toCharArray());
            }
        }
        return external;
    }

    private static IASTName checkForBinding(ICScope scope, IASTDeclSpecifier declSpec, IASTName name, boolean typesOnly, CharArrayObjectMap prefixMap) throws DOMException {
        IASTName resultName;
        block24: {
            char[] n;
            IASTName tempName;
            block25: {
                block26: {
                    tempName = null;
                    resultName = null;
                    n = name.toCharArray();
                    if (!(declSpec instanceof ICASTElaboratedTypeSpecifier)) break block25;
                    tempName = ((ICASTElaboratedTypeSpecifier)declSpec).getName();
                    if (scope != null) {
                        scope.addName(tempName);
                    }
                    if (!typesOnly) break block24;
                    if (prefixMap == null) break block26;
                    prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                    break block24;
                }
                if (CVisitor.collectResult(tempName, n, prefixMap) == null) break block24;
                resultName = tempName;
                break block24;
            }
            if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                tempName = ((ICASTCompositeTypeSpecifier)declSpec).getName();
                if (scope != null) {
                    scope.addName(tempName);
                }
                if (typesOnly) {
                    if (prefixMap != null) {
                        prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                    } else if (CVisitor.collectResult(tempName, n, prefixMap) != null) {
                        resultName = tempName;
                    }
                }
                IASTDeclaration[] nested = ((ICASTCompositeTypeSpecifier)declSpec).getMembers();
                int i = 0;
                while (i < nested.length) {
                    IASTDeclSpecifier d;
                    if (nested[i] instanceof IASTSimpleDeclaration && ((d = ((IASTSimpleDeclaration)nested[i]).getDeclSpecifier()) instanceof ICASTCompositeTypeSpecifier || d instanceof IASTEnumerationSpecifier)) {
                        IASTName obj = CVisitor.checkForBinding(scope, d, name, typesOnly, prefixMap);
                        if (prefixMap == null && resultName == null) {
                            resultName = obj;
                        }
                    }
                    ++i;
                }
            } else if (declSpec instanceof ICASTEnumerationSpecifier) {
                ICASTEnumerationSpecifier enumeration = (ICASTEnumerationSpecifier)declSpec;
                tempName = enumeration.getName();
                if (scope != null) {
                    scope.addName(tempName);
                }
                if (typesOnly) {
                    if (prefixMap != null) {
                        prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                    } else if (CVisitor.collectResult(tempName, n, prefixMap) != null) {
                        resultName = tempName;
                    }
                }
                IASTEnumerationSpecifier.IASTEnumerator[] list = ((ICASTEnumerationSpecifier)declSpec).getEnumerators();
                int i = 0;
                while (i < list.length) {
                    IASTEnumerationSpecifier.IASTEnumerator enumerator = list[i];
                    if (enumerator != null) {
                        tempName = enumerator.getName();
                        if (scope != null) {
                            scope.addName(tempName);
                        }
                        if (!typesOnly) {
                            if (prefixMap != null) {
                                prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                            } else if (CVisitor.collectResult(tempName, n, prefixMap) != null) {
                                resultName = tempName;
                            }
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        return resultName;
    }

    private static Object collectResult(IASTName candidate, char[] name, CharArrayObjectMap prefixMap) {
        char[] c = candidate.toCharArray();
        if (prefixMap == null && CharArrayUtils.equals(c, name)) {
            return candidate;
        }
        if (prefixMap != null && CharArrayUtils.equals(c, 0, name.length, name) && !prefixMap.containsKey(c)) {
            prefixMap.put(c, candidate);
        }
        return prefixMap;
    }

    private static IASTName checkForBinding(ICScope scope, IASTParameterDeclaration paramDecl, IASTName name, boolean typesOnly, CharArrayObjectMap prefixMap) throws DOMException {
        if (paramDecl == null) {
            return null;
        }
        IASTDeclarator dtor = paramDecl.getDeclarator();
        while (dtor.getNestedDeclarator() != null) {
            dtor = dtor.getNestedDeclarator();
        }
        IASTName tempName = dtor.getName();
        if (scope != null) {
            scope.addName(tempName);
        }
        if (!typesOnly) {
            char[] c = tempName.toCharArray();
            char[] n = name.toCharArray();
            if (prefixMap == null && CharArrayUtils.equals(c, n)) {
                return tempName;
            }
            if (prefixMap != null && CharArrayUtils.equals(c, 0, n.length, n) && !prefixMap.containsKey(c)) {
                prefixMap.put(c, tempName);
            }
        } else {
            return CVisitor.checkForBinding(scope, paramDecl.getDeclSpecifier(), name, typesOnly, prefixMap);
        }
        return null;
    }

    private static IASTName checkForBinding(ICScope scope, IASTNode node, IASTName name, boolean typesOnly, CharArrayObjectMap prefixMap) throws DOMException {
        IASTForStatement forStatement;
        if (node instanceof IASTDeclaration) {
            return CVisitor.checkForBinding(scope, (IASTDeclaration)node, name, typesOnly, prefixMap);
        }
        if (node instanceof IASTParameterDeclaration) {
            return CVisitor.checkForBinding(scope, (IASTParameterDeclaration)node, name, typesOnly, prefixMap);
        }
        if (node instanceof IASTDeclarationStatement) {
            return CVisitor.checkForBinding(scope, ((IASTDeclarationStatement)node).getDeclaration(), name, typesOnly, prefixMap);
        }
        if (node instanceof IASTForStatement && (forStatement = (IASTForStatement)node).getInitializerStatement() instanceof IASTDeclarationStatement) {
            return CVisitor.checkForBinding(scope, ((IASTDeclarationStatement)forStatement.getInitializerStatement()).getDeclaration(), name, typesOnly, prefixMap);
        }
        return null;
    }

    private static IASTName checkForBinding(ICScope scope, IASTDeclaration declaration, IASTName name, boolean typesOnly, CharArrayObjectMap prefixMap) throws DOMException {
        char[] n = name.toCharArray();
        IASTName tempName = null;
        IASTName resultName = null;
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
            IASTDeclarator[] declarators = simpleDeclaration.getDeclarators();
            int i = 0;
            while (i < declarators.length) {
                IASTDeclarator declarator = declarators[i];
                while (declarator.getNestedDeclarator() != null) {
                    declarator = declarator.getNestedDeclarator();
                }
                tempName = declarator.getName();
                if (scope != null) {
                    scope.addName(tempName);
                }
                if (!typesOnly) {
                    if (prefixMap != null) {
                        prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                    } else if (CVisitor.collectResult(tempName, n, prefixMap) != null) {
                        resultName = tempName;
                    }
                }
                ++i;
            }
            tempName = CVisitor.checkForBinding(scope, simpleDeclaration.getDeclSpecifier(), name, typesOnly, prefixMap);
            if (prefixMap == null && tempName != null) {
                resultName = tempName;
            }
        } else if (!typesOnly && declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition functionDef = (IASTFunctionDefinition)declaration;
            IASTFunctionDeclarator dtor = functionDef.getDeclarator();
            tempName = dtor.getName();
            if (scope != null) {
                scope.addName(tempName);
            }
            if (!typesOnly) {
                if (prefixMap != null) {
                    prefixMap = (CharArrayObjectMap)CVisitor.collectResult(tempName, n, prefixMap);
                } else if (CVisitor.collectResult(tempName, n, prefixMap) != null) {
                    resultName = tempName;
                }
            }
            tempName = CVisitor.checkForBinding(scope, functionDef.getDeclSpecifier(), name, typesOnly, prefixMap);
            if (prefixMap == null && tempName != null) {
                resultName = tempName;
            }
        }
        return resultName;
    }

    protected static IASTDeclarator findDefinition(IASTDeclarator declarator, int beginAtLoc) {
        return (IASTDeclarator)CVisitor.findDefinition(declarator, declarator.getName().toCharArray(), beginAtLoc);
    }

    protected static IASTFunctionDeclarator findDefinition(IASTFunctionDeclarator declarator) {
        return (IASTFunctionDeclarator)CVisitor.findDefinition(declarator, declarator.getName().toCharArray(), 2);
    }

    protected static IASTDeclSpecifier findDefinition(ICASTElaboratedTypeSpecifier declSpec) {
        return (IASTDeclSpecifier)CVisitor.findDefinition(declSpec, declSpec.getName().toCharArray(), 1);
    }

    private static IASTNode findDefinition(IASTNode decl, char[] declName, int beginAtLoc) {
        boolean begun;
        IASTNode blockItem = CVisitor.getContainingBlockItem(decl);
        IASTNode parent = blockItem.getParent();
        IASTNode[] list = null;
        if (parent instanceof IASTCompoundStatement) {
            IASTCompoundStatement compound = (IASTCompoundStatement)parent;
            list = compound.getStatements();
        } else if (parent instanceof IASTTranslationUnit) {
            IASTTranslationUnit translation = (IASTTranslationUnit)parent;
            list = translation.getDeclarations();
        }
        boolean bl = begun = beginAtLoc == 1;
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                IASTNode node = list[i];
                if (node == blockItem) {
                    begun = true;
                } else if (begun) {
                    IASTSimpleDeclaration simpleDecl;
                    if (node instanceof IASTDeclarationStatement) {
                        node = ((IASTDeclarationStatement)node).getDeclaration();
                    }
                    if (node instanceof IASTFunctionDefinition && decl instanceof IASTFunctionDeclarator) {
                        IASTFunctionDeclarator dtor = ((IASTFunctionDefinition)node).getDeclarator();
                        IASTName name = dtor.getName();
                        if (name.toString().equals(declName)) {
                            return dtor;
                        }
                    } else if (node instanceof IASTSimpleDeclaration && decl instanceof ICASTElaboratedTypeSpecifier) {
                        simpleDecl = (IASTSimpleDeclaration)node;
                        IASTDeclSpecifier declSpec = simpleDecl.getDeclSpecifier();
                        IASTName name = null;
                        if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                            name = ((ICASTCompositeTypeSpecifier)declSpec).getName();
                        } else if (declSpec instanceof ICASTEnumerationSpecifier) {
                            name = ((ICASTEnumerationSpecifier)declSpec).getName();
                        }
                        if (name != null && CharArrayUtils.equals(name.toCharArray(), declName)) {
                            return declSpec;
                        }
                    } else if (node instanceof IASTSimpleDeclaration && decl instanceof IASTDeclarator) {
                        simpleDecl = (IASTSimpleDeclaration)node;
                        IASTDeclarator[] dtors = simpleDecl.getDeclarators();
                        int j = 0;
                        while (dtors != null && j < dtors.length) {
                            if (CharArrayUtils.equals(dtors[j].getName().toCharArray(), declName)) {
                                return dtors[j];
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void clearBindings(IASTTranslationUnit tu) {
        tu.accept(new ClearBindingAction());
    }

    public static IType createType(IASTDeclarator declarator) {
        IASTDeclSpecifier declSpec = null;
        IASTNode node = declarator.getParent();
        while (node instanceof IASTDeclarator) {
            declarator = (IASTDeclarator)node;
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            declSpec = ((IASTParameterDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTSimpleDeclaration) {
            declSpec = ((IASTSimpleDeclaration)node).getDeclSpecifier();
        } else if (node instanceof IASTFunctionDefinition) {
            declSpec = ((IASTFunctionDefinition)node).getDeclSpecifier();
        } else if (node instanceof IASTTypeId) {
            declSpec = ((IASTTypeId)node).getDeclSpecifier();
        }
        boolean isParameter = node instanceof IASTParameterDeclaration || node.getParent() instanceof ICASTKnRFunctionDeclarator;
        IType type = null;
        type = isParameter && node.getParent().getParent() instanceof IASTFunctionDefinition ? CVisitor.createBaseType(declSpec) : CVisitor.createType((ICASTDeclSpecifier)declSpec);
        type = CVisitor.createType(type, declarator);
        if (isParameter) {
            if (type instanceof IArrayType) {
                CArrayType at = (CArrayType)type;
                type = new CQualifiedPointerType(at.getType(), at.getModifier());
            } else if (type instanceof IFunctionType) {
                type = new CPointerType(type, 0);
            }
        }
        return type;
    }

    public static IType createType(IType baseType, IASTDeclarator declarator) {
        if (declarator instanceof IASTFunctionDeclarator) {
            return CVisitor.createType(baseType, (IASTFunctionDeclarator)declarator);
        }
        IType type = baseType;
        type = CVisitor.setupPointerChain(declarator.getPointerOperators(), type);
        type = CVisitor.setupArrayChain(declarator, type);
        IASTDeclarator nested = declarator.getNestedDeclarator();
        if (nested != null) {
            return CVisitor.createType(type, nested);
        }
        return type;
    }

    public static IType createType(IType returnType, IASTFunctionDeclarator declarator) {
        IType[] pTypes = CVisitor.getParmTypes(declarator);
        returnType = CVisitor.setupPointerChain(declarator.getPointerOperators(), returnType);
        CFunctionType type = new CFunctionType(returnType, pTypes);
        IASTDeclarator nested = declarator.getNestedDeclarator();
        if (nested != null) {
            return CVisitor.createType((IType)type, nested);
        }
        return type;
    }

    public static IType createBaseType(IASTDeclSpecifier declSpec) {
        if (declSpec instanceof IGCCASTSimpleDeclSpecifier) {
            IASTExpression exp = ((IGCCASTSimpleDeclSpecifier)declSpec).getTypeofExpression();
            if (exp != null) {
                return CVisitor.getExpressionType(exp);
            }
            return new CBasicType((ICASTSimpleDeclSpecifier)declSpec);
        }
        if (declSpec instanceof ICASTSimpleDeclSpecifier) {
            return new CBasicType((ICASTSimpleDeclSpecifier)declSpec);
        }
        IBinding binding = null;
        IASTName name = null;
        if (declSpec instanceof ICASTTypedefNameSpecifier) {
            name = ((ICASTTypedefNameSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            name = ((IASTElaboratedTypeSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTCompositeTypeSpecifier) {
            name = ((IASTCompositeTypeSpecifier)declSpec).getName();
        } else if (declSpec instanceof IASTEnumerationSpecifier) {
            name = ((IASTEnumerationSpecifier)declSpec).getName();
        }
        binding = name.resolveBinding();
        if (binding instanceof IType) {
            return (IType)((Object)binding);
        }
        if (binding != null) {
            return new ProblemBinding(name, 5, name.toCharArray());
        }
        return new ProblemBinding(name, 1, name.toCharArray());
    }

    public static IType createType(ICASTDeclSpecifier declSpec) {
        if (declSpec.isConst() || declSpec.isVolatile() || declSpec.isRestrict()) {
            return new CQualifierType(declSpec);
        }
        return CVisitor.createBaseType(declSpec);
    }

    private static IType[] getParmTypes(IASTFunctionDeclarator decltor) {
        if (decltor instanceof IASTStandardFunctionDeclarator) {
            IASTParameterDeclaration[] parms = ((IASTStandardFunctionDeclarator)decltor).getParameters();
            IType[] parmTypes = new IType[parms.length];
            int i = 0;
            while (i < parms.length) {
                parmTypes[i] = CVisitor.createType(parms[i].getDeclarator());
                ++i;
            }
            return parmTypes;
        }
        if (decltor instanceof ICASTKnRFunctionDeclarator) {
            IASTName[] parms = ((ICASTKnRFunctionDeclarator)decltor).getParameterNames();
            IType[] parmTypes = new IType[parms.length];
            int i = 0;
            while (i < parms.length) {
                IASTDeclarator dtor = CVisitor.getKnRParameterDeclarator((ICASTKnRFunctionDeclarator)decltor, parms[i]);
                if (dtor != null) {
                    parmTypes[i] = CVisitor.createType(dtor);
                }
                ++i;
            }
            return parmTypes;
        }
        return null;
    }

    protected static IASTDeclarator getKnRParameterDeclarator(ICASTKnRFunctionDeclarator fKnRDtor, IASTName name) {
        IASTDeclaration[] decls = fKnRDtor.getParameterDeclarations();
        char[] n = name.toCharArray();
        int i = 0;
        while (i < decls.length) {
            if (decls[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decls[i]).getDeclarators();
                int j = 0;
                while (j < dtors.length) {
                    if (CharArrayUtils.equals(dtors[j].getName().toCharArray(), n)) {
                        return dtors[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static IType setupArrayChain(IASTDeclarator decl, IType lastType) {
        if (decl instanceof IASTArrayDeclarator) {
            int i = 0;
            IASTArrayModifier[] mods = ((IASTArrayDeclarator)decl).getArrayModifiers();
            CArrayType arrayType = new CArrayType(lastType);
            if (mods[i] instanceof ICASTArrayModifier) {
                arrayType.setModifiedArrayModifier((ICASTArrayModifier)mods[i++]);
            }
            while (i < ((IASTArrayDeclarator)decl).getArrayModifiers().length - 1) {
                arrayType = new CArrayType(arrayType);
                if (mods[i] instanceof ICASTArrayModifier) {
                    arrayType.setModifiedArrayModifier((ICASTArrayModifier)mods[i]);
                }
                ++i;
            }
            return arrayType;
        }
        return lastType;
    }

    private static IType setupPointerChain(IASTPointerOperator[] ptrs, IType lastType) {
        CPointerType pointerType = null;
        if (ptrs != null && ptrs.length > 0) {
            pointerType = new CPointerType();
            if (ptrs.length == 1) {
                pointerType.setType(lastType);
                pointerType.setQualifiers((((ICASTPointer)ptrs[0]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[0]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[0]).isVolatile() ? 4 : 0));
            } else {
                CPointerType tempType = new CPointerType();
                pointerType.setType(tempType);
                pointerType.setQualifiers((((ICASTPointer)ptrs[ptrs.length - 1]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[ptrs.length - 1]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[ptrs.length - 1]).isVolatile() ? 4 : 0));
                int i = ptrs.length - 2;
                while (i > 0) {
                    tempType.setType(new CPointerType());
                    tempType.setQualifiers((((ICASTPointer)ptrs[i]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[i]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[i]).isVolatile() ? 4 : 0));
                    tempType = (CPointerType)tempType.getType();
                    --i;
                }
                tempType.setType(lastType);
                tempType.setQualifiers((((ICASTPointer)ptrs[i]).isConst() ? 1 : 0) | (((ICASTPointer)ptrs[i]).isRestrict() ? 2 : 0) | (((ICASTPointer)ptrs[i]).isVolatile() ? 4 : 0));
            }
            return pointerType;
        }
        return lastType;
    }

    public static IASTProblem[] getProblems(IASTTranslationUnit tu) {
        CollectProblemsAction action = new CollectProblemsAction();
        tu.accept(action);
        return action.getProblems();
    }

    public static IASTName[] getDeclarations(IASTTranslationUnit tu, IBinding binding) {
        CollectDeclarationsAction action = new CollectDeclarationsAction(binding);
        tu.accept(action);
        return action.getDeclarationNames();
    }

    public static IASTName[] getReferences(IASTTranslationUnit tu, IBinding binding) {
        CollectReferencesAction action = new CollectReferencesAction(binding);
        tu.accept(action);
        return action.getReferences();
    }

    public static IBinding findTypeBinding(IASTNode startingPoint, IASTName name) throws DOMException {
        IASTStatement[] statements;
        IASTDeclaration[] declarations;
        if (startingPoint instanceof IASTTranslationUnit && (declarations = ((IASTTranslationUnit)startingPoint).getDeclarations()).length > 0) {
            return (IBinding)CVisitor.findBinding(declarations[declarations.length - 1], name, 4);
        }
        if (startingPoint instanceof IASTCompoundStatement && (statements = ((IASTCompoundStatement)startingPoint).getStatements()).length > 0) {
            return (IBinding)CVisitor.findBinding(statements[statements.length - 1], name, 4);
        }
        return null;
    }

    public static IBinding[] prefixLookup(IASTName name) {
        Class<?> clazz;
        IPDOM pdom;
        ASTNodeProperty prop = name.getPropertyInParent();
        Object[] result = null;
        if (prop == IASTFieldReference.FIELD_NAME) {
            result = (IBinding[])CVisitor.findBinding((IASTFieldReference)name.getParent(), true);
        } else {
            int bits = 8;
            if (prop == IASTElaboratedTypeSpecifier.TYPE_NAME) {
                bits |= 2;
            } else if (prop == IASTIdExpression.ID_NAME) {
                bits |= 4;
            }
            IASTNode blockItem = CVisitor.getContainingBlockItem(name);
            try {
                result = (IBinding[])CVisitor.findBinding(blockItem, name, bits);
            }
            catch (DOMException dOMException) {}
        }
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu != null && (pdom = tu.getIndex()) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IBinding[])ArrayUtil.addAll(clazz2, result, pdom.resolvePrefix(name));
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBinding[])ArrayUtil.trim(clazz, result);
    }

    public static IBinding[] findBindings(IScope scope, String name) throws DOMException {
        IASTNode node = scope.getPhysicalNode();
        if (node instanceof IASTFunctionDefinition) {
            node = ((IASTFunctionDefinition)node).getBody();
        }
        CASTName astName = new CASTName(name.toCharArray());
        astName.setParent(node);
        astName.setPropertyInParent(STRING_LOOKUP_PROPERTY);
        IBinding b1 = (IBinding)CVisitor.findBinding(astName, astName, 0);
        astName.setPropertyInParent(STRING_LOOKUP_TAGS_PROPERTY);
        IBinding b2 = (IBinding)CVisitor.findBinding(astName, astName, 2);
        ILabel b3 = null;
        block0: do {
            char[] n = name.toCharArray();
            if (!(scope instanceof ICFunctionScope)) continue;
            ILabel[] labels = ((CFunctionScope)scope).getLabels();
            int i = 0;
            while (i < labels.length) {
                ILabel label = labels[i];
                if (CharArrayUtils.equals(label.getNameCharArray(), n)) {
                    b3 = label;
                    break block0;
                }
                ++i;
            }
            break;
        } while ((scope = scope.getParent()) != null);
        int c = (b1 != null ? 1 : 0) + (b2 != null ? 1 : 0) + (b3 != null ? 1 : 0);
        IBinding[] result = new IBinding[c];
        c = 0;
        if (b1 != null) {
            result[c++] = b1;
        }
        if (b2 != null) {
            result[c++] = b2;
        }
        if (b3 != null) {
            result[c] = b3;
        }
        return result;
    }

    public static class ClearBindingAction
    extends CASTVisitor {
        public ClearBindingAction() {
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            if (name.getBinding() != null) {
                try {
                    ICScope scope = (ICScope)name.resolveBinding().getScope();
                    if (scope != null) {
                        scope.removeBinding(name.resolveBinding());
                    }
                }
                catch (DOMException dOMException) {}
                name.setBinding(null);
            }
            return 3;
        }
    }

    public static class CollectProblemsAction
    extends CASTVisitor {
        private static final int DEFAULT_CHILDREN_LIST_SIZE = 8;
        private IASTProblem[] problems;
        int numFound;

        public CollectProblemsAction() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitStatements = true;
            this.shouldVisitTypeIds = true;
            this.problems = null;
            this.numFound = 0;
            this.problems = new IASTProblem[8];
        }

        private void addProblem(IASTProblem problem) {
            if (this.problems.length == this.numFound) {
                IASTProblem[] old = this.problems;
                this.problems = new IASTProblem[old.length * 2];
                int j = 0;
                while (j < old.length) {
                    this.problems[j] = old[j];
                    ++j;
                }
            }
            this.problems[this.numFound++] = problem;
        }

        private IASTProblem[] removeNullFromProblems() {
            if (this.problems[this.problems.length - 1] != null) {
                return this.problems;
            }
            if (this.problems[0] == null) {
                return new IASTProblem[0];
            }
            IASTProblem[] results = new IASTProblem[this.numFound];
            int i = 0;
            while (i < results.length) {
                results[i] = this.problems[i];
                ++i;
            }
            return results;
        }

        public IASTProblem[] getProblems() {
            return this.removeNullFromProblems();
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)declaration)).getProblem());
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)expression)).getProblem());
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)statement)).getProblem());
            }
            return 3;
        }

        public int visit(IASTTypeId typeId) {
            if (typeId instanceof IASTProblemHolder) {
                this.addProblem(((IASTProblemHolder)((Object)typeId)).getProblem());
            }
            return 3;
        }
    }

    public static class CollectDeclarationsAction
    extends CASTVisitor {
        private static final int DEFAULT_CHILDREN_LIST_SIZE = 8;
        private IASTName[] declsFound;
        int numFound;
        IBinding binding;
        boolean compositeTypeDeclared;

        private void addName(IASTName name) {
            if (this.declsFound.length == this.numFound) {
                IASTName[] old = this.declsFound;
                this.declsFound = new IASTName[old.length * 2];
                int j = 0;
                while (j < old.length) {
                    this.declsFound[j] = old[j];
                    ++j;
                }
            }
            this.declsFound[this.numFound++] = name;
        }

        private IASTName[] removeNullFromNames() {
            if (this.declsFound[this.declsFound.length - 1] != null) {
                return this.declsFound;
            }
            if (this.declsFound[0] == null) {
                return new IASTName[0];
            }
            IASTName[] results = new IASTName[this.numFound];
            int i = 0;
            while (i < results.length) {
                results[i] = this.declsFound[i];
                ++i;
            }
            return results;
        }

        public IASTName[] getDeclarationNames() {
            return this.removeNullFromNames();
        }

        public CollectDeclarationsAction(IBinding binding) {
            this.shouldVisitDeclarators = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitEnumerators = true;
            this.shouldVisitStatements = true;
            this.declsFound = null;
            this.numFound = 0;
            this.binding = null;
            this.compositeTypeDeclared = false;
            this.declsFound = new IASTName[8];
            this.binding = binding;
        }

        public int visit(IASTDeclarator declarator) {
            if (declarator == null || declarator.getName() == null || declarator.getName().toCharArray().length == 0) {
                return 3;
            }
            if (this.binding instanceof ICompositeType) {
                return 3;
            }
            if (this.binding instanceof IEnumeration) {
                return 3;
            }
            IASTNode parent = declarator.getParent();
            while (parent != null && !(parent instanceof IASTDeclaration) && !(parent instanceof IASTParameterDeclaration)) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTDeclaration) {
                if (parent != null && parent instanceof IASTFunctionDefinition) {
                    if (declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                        this.addName(declarator.getName());
                    }
                } else if (parent instanceof IASTSimpleDeclaration && declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                    this.addName(declarator.getName());
                }
            } else if (parent instanceof IASTParameterDeclaration && declarator.getName() != null && declarator.getName().resolveBinding() == this.binding) {
                this.addName(declarator.getName());
            }
            return 3;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            if (this.compositeTypeDeclared && declSpec instanceof ICASTTypedefNameSpecifier) {
                return 3;
            }
            if (!(this.binding instanceof ICompositeType) && !(this.binding instanceof IEnumeration)) {
                return 3;
            }
            if (this.binding instanceof ICompositeType && declSpec instanceof IASTCompositeTypeSpecifier) {
                if (((IASTCompositeTypeSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTCompositeTypeSpecifier)declSpec).getName());
                }
            } else if (this.binding instanceof IEnumeration && declSpec instanceof IASTEnumerationSpecifier) {
                if (((IASTEnumerationSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTEnumerationSpecifier)declSpec).getName());
                }
            } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
                IASTNode parent;
                if (this.compositeTypeDeclared && (!((parent = declSpec.getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)parent).getDeclarators().length > 0)) {
                    return 3;
                }
                if (((IASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding() == this.binding) {
                    this.compositeTypeDeclared = true;
                    this.addName(((IASTElaboratedTypeSpecifier)declSpec).getName());
                }
            }
            return 3;
        }

        public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
            if (this.binding instanceof IEnumerator && enumerator.getName().resolveBinding() == this.binding) {
                this.addName(enumerator.getName());
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTLabelStatement && this.binding instanceof ILabel) {
                if (((IASTLabelStatement)statement).getName().resolveBinding() == this.binding) {
                    this.addName(((IASTLabelStatement)statement).getName());
                }
                return 1;
            }
            return 3;
        }
    }

    public static class CollectReferencesAction
    extends CASTVisitor {
        private static final int DEFAULT_LIST_SIZE = 8;
        private IASTName[] refs;
        private IBinding binding;
        private int idx = 0;
        private int kind;
        private static final int KIND_LABEL = 1;
        private static final int KIND_OBJ_FN = 2;
        private static final int KIND_TYPE = 3;

        public CollectReferencesAction(IBinding binding) {
            this.binding = binding;
            this.refs = new IASTName[8];
            this.shouldVisitNames = true;
            this.kind = binding instanceof ILabel ? 1 : (binding instanceof ICompositeType || binding instanceof ITypedef || binding instanceof IEnumeration ? 3 : 2);
        }

        public int visit(IASTName name) {
            ASTNodeProperty prop = name.getPropertyInParent();
            switch (this.kind) {
                case 1: {
                    if (prop == IASTGotoStatement.NAME) break;
                    return 3;
                }
                case 3: {
                    IASTNode p;
                    if (prop == IASTNamedTypeSpecifier.NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME && (!((p = name.getParent().getParent()) instanceof IASTSimpleDeclaration) || ((IASTSimpleDeclaration)p).getDeclarators().length > 0)) break;
                    return 3;
                }
                case 2: {
                    if (prop == IASTIdExpression.ID_NAME || prop == IASTFieldReference.FIELD_NAME || prop == ICASTFieldDesignator.FIELD_NAME) break;
                    return 3;
                }
            }
            if (CharArrayUtils.equals(name.toCharArray(), this.binding.getNameCharArray()) && name.resolveBinding() == this.binding) {
                if (this.refs.length == this.idx) {
                    IASTName[] temp = new IASTName[this.refs.length * 2];
                    System.arraycopy(this.refs, 0, temp, 0, this.refs.length);
                    this.refs = temp;
                }
                this.refs[this.idx++] = name;
            }
            return 3;
        }

        public IASTName[] getReferences() {
            if (this.idx < this.refs.length) {
                IASTName[] temp = new IASTName[this.idx];
                System.arraycopy(this.refs, 0, temp, 0, this.idx);
                this.refs = temp;
            }
            return this.refs;
        }
    }
}

