/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public abstract class CPPASTAmbiguity
extends CPPASTNode {
    protected abstract IASTNode[] getNodes();

    public boolean accept(ASTVisitor visitor) {
        IASTNode[] nodez = this.getNodes();
        int[] issues = new int[nodez.length];
        Arrays.fill(issues, 0);
        int i = 0;
        while (i < nodez.length) {
            IScope scope;
            IASTNode s = nodez[i];
            s.accept(visitor);
            CPPASTNameCollector resolver = new CPPASTNameCollector();
            s.accept(resolver);
            IASTName[] names = resolver.getNames();
            int j = 0;
            while (j < names.length) {
                try {
                    IBinding b = names[j].resolveBinding();
                    if (b == null || b instanceof IProblemBinding) {
                        int n = i;
                        issues[n] = issues[n] + 1;
                    }
                }
                catch (Throwable throwable) {
                    int n = i;
                    issues[n] = issues[n] + 1;
                }
                ++j;
            }
            if (names.length > 0 && (scope = CPPVisitor.getContainingScope(names[0])) != null) {
                try {
                    scope.flushCache();
                }
                catch (DOMException dOMException) {}
            }
            ++i;
        }
        int bestIndex = 0;
        int bestValue = issues[0];
        int i2 = 1;
        while (i2 < issues.length) {
            if (issues[i2] < bestValue) {
                bestIndex = i2;
                bestValue = issues[i2];
            }
            ++i2;
        }
        IASTAmbiguityParent owner = (IASTAmbiguityParent)((Object)this.getParent());
        owner.replace(this, nodez[bestIndex]);
        return true;
    }

    protected static class CPPASTNameCollector
    extends CPPASTVisitor {
        private IASTName[] names = new IASTName[2];
        private int namesPos = -1;
        static /* synthetic */ Class class$0;

        protected CPPASTNameCollector() {
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            if (name != null) {
                ++this.namesPos;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.names = (IASTName[])ArrayUtil.append(clazz, this.names, name);
            }
            return 3;
        }

        public IASTName[] getNames() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.names = (IASTName[])ArrayUtil.removeNullsAfter(clazz, this.names, this.namesPos);
            return this.names;
        }
    }
}

