/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class CPPArrayType
implements IArrayType,
ITypeContainer {
    private IType type = null;
    private IASTExpression sizeExpression = null;

    public CPPArrayType(IType type) {
        this.type = type;
    }

    public CPPArrayType(IType type, IASTExpression sizeExp) {
        this.type = type;
        this.sizeExpression = sizeExp;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return ((ITypedef)obj).isSameType(this);
        }
        if (obj instanceof IArrayType) {
            try {
                IType objType = ((IArrayType)obj).getType();
                if (objType != null) {
                    return objType.isSameType(this.type);
                }
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public IASTExpression getArraySizeExpression() {
        return this.sizeExpression;
    }
}

