/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class CPPClassInstanceScope
implements ICPPClassScope {
    private static final char[] CONSTRUCTOR_KEY = "!!!CTOR!!!".toCharArray();
    private CharArrayObjectMap bindings;
    private ObjectMap instanceMap = ObjectMap.EMPTY_MAP;
    private ICPPTemplateInstance instance;
    private boolean isFullyCached = false;
    private boolean doneConstructors = false;
    static /* synthetic */ Class class$0;

    public CPPClassInstanceScope(CPPClassInstance instance) {
        this.instance = instance;
    }

    private ICPPClassType getOriginalClass() {
        return (ICPPClassType)((Object)this.instance.getTemplateDefinition());
    }

    public boolean isFullyCached() {
        if (!this.isFullyCached) {
            CPPSemantics.LookupData data = new CPPSemantics.LookupData();
            try {
                CPPSemantics.lookupInScope(data, this, null);
            }
            catch (DOMException dOMException) {}
        }
        return true;
    }

    public IBinding getBinding(IASTName name, boolean forceResolve) {
        Object cache;
        char[] c = name.toCharArray();
        if (this.bindings == null) {
            return null;
        }
        if (CharArrayUtils.equals(c, this.instance.getNameCharArray()) && CPPClassScope.isConstructorReference(name)) {
            c = CONSTRUCTOR_KEY;
        }
        if ((cache = this.bindings.get(c)) != null) {
            int i = cache instanceof ObjectSet ? 0 : -1;
            ObjectSet set = cache instanceof ObjectSet ? (ObjectSet)cache : null;
            Object obj = set != null ? set.keyAt(i) : cache;
            Object[] bs = null;
            IBinding binding = null;
            while (obj != null) {
                if (obj instanceof IASTName) {
                    IASTName n = (IASTName)obj;
                    if (n instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                        n = ns[ns.length - 1];
                    }
                    if (this.instanceMap.containsKey(n)) {
                        binding = (IBinding)this.instanceMap.get(n);
                    } else {
                        IBinding iBinding = binding = forceResolve ? n.resolveBinding() : n.getBinding();
                        if (binding instanceof ICPPClassTemplatePartialSpecialization) {
                            binding = null;
                        }
                        if (binding != null) {
                            binding = CPPTemplates.createSpecialization(this, binding, this.instance.getArgumentMap());
                            if (this.instanceMap == ObjectMap.EMPTY_MAP) {
                                this.instanceMap = new ObjectMap(2);
                            }
                            this.instanceMap.put(n, binding);
                        }
                    }
                } else if (obj instanceof IBinding) {
                    if (this.instanceMap.containsKey(obj)) {
                        binding = (IBinding)this.instanceMap.get(obj);
                    } else {
                        binding = CPPTemplates.createSpecialization(this, (IBinding)obj, this.instance.getArgumentMap());
                        if (this.instanceMap == ObjectMap.EMPTY_MAP) {
                            this.instanceMap = new ObjectMap(2);
                        }
                        this.instanceMap.put(obj, binding);
                    }
                }
                if (binding != null) {
                    if (i == -1) {
                        return binding;
                    }
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    bs = (IBinding[])ArrayUtil.append(clazz, bs, binding);
                    binding = null;
                }
                obj = i != -1 && ++i < set.size() ? set.keyAt(i) : null;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((bs = (IBinding[])ArrayUtil.trim(clazz, bs)).length == 1) {
                return bs[0];
            }
            return CPPSemantics.resolveAmbiguities(name, bs);
        }
        return null;
    }

    public ICPPClassType getClassType() {
        return (ICPPClassType)((Object)this.instance);
    }

    public ICPPMethod[] getImplicitMethods() {
        return null;
    }

    public IASTName getScopeName() {
        return (IASTName)((ICPPInternalBinding)((Object)this.instance)).getDefinition();
    }

    public void addName(IASTName name) {
        Object o;
        if (name instanceof ICPPASTQualifiedName) {
            return;
        }
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        char[] c = name.toCharArray();
        IASTNode parent = name.getParent();
        if (parent instanceof IASTDeclarator && CPPVisitor.isConstructor(this, (IASTDeclarator)parent)) {
            c = CONSTRUCTOR_KEY;
        }
        if ((o = this.bindings.get(c)) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet temp = new ObjectSet(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    protected ICPPConstructor[] getConstructors() {
        int i;
        ICPPConstructor[] ctors;
        if (this.bindings == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        if (!this.doneConstructors) {
            try {
                ctors = ((ICPPClassType)((Object)this.instance.getTemplateDefinition())).getConstructors();
                i = 0;
                while (i < ctors.length) {
                    this.addBinding(ctors[i]);
                    ++i;
                }
                this.doneConstructors = true;
            }
            catch (DOMException dOMException) {}
        }
        ctors = CPPClassScope.getConstructors(this.bindings, true);
        i = 0;
        while (i < ctors.length) {
            if (this.instanceMap.containsKey(ctors[i])) {
                ctors[i] = (ICPPConstructor)this.instanceMap.get(ctors[i]);
            } else {
                ICPPSpecialization b = CPPTemplates.createSpecialization(this, ctors[i], this.instance.getArgumentMap());
                if (this.instanceMap == ObjectMap.EMPTY_MAP) {
                    this.instanceMap = new ObjectMap(2);
                }
                this.instanceMap.put(ctors[i], b);
                ctors[i] = (ICPPConstructor)((Object)b);
            }
            ++i;
        }
        return ctors;
    }

    public void setFullyCached(boolean b) {
        this.isFullyCached = b;
    }

    public IScope getParent() throws DOMException {
        IASTNode[] nds;
        ICPPClassType cls = this.getOriginalClass();
        ICPPClassScope scope = (ICPPClassScope)cls.getCompositeScope();
        if (scope != null) {
            return scope.getParent();
        }
        if (cls instanceof ICPPInternalBinding && (nds = ((ICPPInternalBinding)((Object)cls)).getDeclarations()) != null && nds.length > 0) {
            return CPPVisitor.getContainingScope(nds[0]);
        }
        return null;
    }

    public IBinding[] find(String name) {
        return null;
    }

    public IASTNode getPhysicalNode() throws DOMException {
        IASTNode[] nds;
        ICPPClassType cls = this.getOriginalClass();
        ICPPClassScope scope = (ICPPClassScope)cls.getCompositeScope();
        if (scope != null) {
            return scope.getPhysicalNode();
        }
        if (cls instanceof ICPPInternalBinding && (nds = ((ICPPInternalBinding)((Object)cls)).getDeclarations()) != null && nds.length > 0) {
            return nds[0];
        }
        return null;
    }

    public void removeBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        if (!this.bindings.containsKey(name)) {
            return;
        }
        Object obj = this.bindings.get(name);
        if (obj instanceof ObjectSet) {
            ObjectSet set = (ObjectSet)obj;
            set.remove(binding);
            if (set.size() == 0) {
                this.bindings.remove(name, 0, name.length);
            }
        } else {
            this.bindings.remove(name, 0, name.length);
        }
        if (this.instanceMap != null && this.instanceMap.containsKey(binding)) {
            this.instanceMap.remove(binding);
        }
        this.isFullyCached = false;
    }

    public void flushCache() {
        if (this.bindings != null) {
            this.bindings.clear();
        }
        this.isFullyCached = false;
    }

    public void addBinding(IBinding binding) {
        char[] c;
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(c = binding instanceof ICPPConstructor ? CONSTRUCTOR_KEY : binding.getNameCharArray())) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet set = new ObjectSet(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    public IBinding getInstance(IBinding binding) {
        if (this.instanceMap != null && this.instanceMap.containsKey(binding)) {
            return (IBinding)this.instanceMap.get(binding);
        }
        return null;
    }
}

