/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;

public class CPPFunctionTemplate
extends CPPTemplateDefinition
implements ICPPFunctionTemplate,
ICPPFunction,
ICPPInternalFunction {
    protected IFunctionType type = null;

    public CPPFunctionTemplate(IASTName name) {
        super(name);
    }

    public void addDefinition(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateFunctionParameterBindings((IASTName)node);
        super.addDefinition(node);
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateFunctionParameterBindings((IASTName)node);
        super.addDeclaration(node);
    }

    private void updateFunctionParameterBindings(IASTName paramName) {
        IASTName defName = this.definition != null ? this.definition : this.declarations[0];
        ICPPASTFunctionDeclarator orig = (ICPPASTFunctionDeclarator)defName.getParent();
        IASTParameterDeclaration[] ops = orig.getParameters();
        IASTParameterDeclaration[] nps = ((ICPPASTFunctionDeclarator)paramName.getParent()).getParameters();
        CPPParameter temp = null;
        int i = 0;
        while (i < nps.length) {
            temp = (CPPParameter)ops[i].getDeclarator().getName().getBinding();
            if (temp != null) {
                IASTName name = nps[i].getDeclarator().getName();
                name.setBinding(temp);
                temp.addDeclaration(name);
            }
            ++i;
        }
    }

    public IParameter[] getParameters() {
        IASTName name = this.getTemplateName();
        IASTNode parent = name.getParent();
        if (parent instanceof ICPPASTQualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)parent;
            IASTParameterDeclaration[] params = dtor.getParameters();
            int size = params.length;
            IParameter[] result = new IParameter[size];
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    IASTParameterDeclaration p = params[i];
                    result[i] = (IParameter)p.getDeclarator().getName().resolveBinding();
                    ++i;
                }
            }
            return result;
        }
        return null;
    }

    public IScope getFunctionScope() {
        return null;
    }

    public IFunctionType getType() {
        if (this.type == null) {
            IASTName name = this.getTemplateName();
            IASTNode parent = name.getParent();
            while (parent.getParent() instanceof IASTDeclarator) {
                parent = parent.getParent();
            }
            IType temp = CPPVisitor.createType((IASTDeclarator)parent);
            if (temp instanceof IFunctionType) {
                this.type = (IFunctionType)temp;
            }
        }
        return this.type;
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (declSpec.getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public IBinding resolveParameter(IASTParameterDeclaration param) {
        IASTName n;
        IASTName name = param.getDeclarator().getName();
        IBinding binding = name.getBinding();
        if (binding != null) {
            return binding;
        }
        ICPPASTFunctionDeclarator fdtor = (ICPPASTFunctionDeclarator)param.getParent();
        IASTParameterDeclaration[] ps = fdtor.getParameters();
        int i = 0;
        while (i < ps.length) {
            if (param == ps[i]) break;
            ++i;
        }
        binding = new CPPParameter(name);
        IASTParameterDeclaration temp = null;
        if (this.definition != null) {
            IASTNode node = this.definition.getParent();
            if (node instanceof ICPPASTQualifiedName) {
                node = node.getParent();
            }
            if ((n = (temp = ((ICPPASTFunctionDeclarator)node).getParameters()[i]).getDeclarator().getName()) != name) {
                n.setBinding(binding);
                ((CPPParameter)binding).addDeclaration(n);
            }
        }
        if (this.declarations != null) {
            int j = 0;
            while (j < this.declarations.length && this.declarations[j] != null) {
                temp = ((ICPPASTFunctionDeclarator)this.declarations[j].getParent()).getParameters()[i];
                n = temp.getDeclarator().getName();
                if (n != name) {
                    n.setBinding(binding);
                    ((CPPParameter)binding).addDeclaration(n);
                }
                ++j;
            }
        }
        return binding;
    }

    public ICPPSpecialization deferredInstance(IType[] arguments) {
        ICPPSpecialization instance = this.getInstance(arguments);
        if (instance == null) {
            instance = new CPPDeferredFunctionInstance(this, arguments);
            this.addSpecialization(arguments, instance);
        }
        return instance;
    }

    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    public boolean isMutable() {
        return this.hasStorageClass(6);
    }

    public boolean isInline() throws DOMException {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            IASTDeclSpecifier declSpec = null;
            if (parent instanceof IASTSimpleDeclaration) {
                declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier();
            } else if (parent instanceof IASTFunctionDefinition) {
                declSpec = ((IASTFunctionDefinition)parent).getDeclSpecifier();
            }
            if (!declSpec.isInline()) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean takesVarArgs() {
        IASTName name = (IASTName)this.getDefinition();
        if (name != null) {
            ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)name.getParent();
            return dtor.takesVarArgs();
        }
        IASTName[] ns = (IASTName[])this.getDeclarations();
        if (ns != null && ns.length > 0) {
            ICPPASTFunctionDeclarator dtor = (ICPPASTFunctionDeclarator)ns[0].getParent();
            return dtor.takesVarArgs();
        }
        return false;
    }

    public boolean isStatic(boolean resolveAll) {
        return this.hasStorageClass(3);
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPFunctionTemplateDelegate(name, this);
    }

    public static final class CPPFunctionTemplateProblem
    extends ProblemBinding
    implements ICPPFunctionTemplate,
    ICPPFunction {
        public CPPFunctionTemplateProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        public ICPPTemplateParameter[] getTemplateParameters() throws DOMException {
            throw new DOMException(this);
        }

        public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
            throw new DOMException(this);
        }

        public String[] getQualifiedName() throws DOMException {
            throw new DOMException(this);
        }

        public char[][] getQualifiedNameCharArray() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isGloballyQualified() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isMutable() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isInline() throws DOMException {
            throw new DOMException(this);
        }

        public IParameter[] getParameters() throws DOMException {
            throw new DOMException(this);
        }

        public IScope getFunctionScope() throws DOMException {
            throw new DOMException(this);
        }

        public IFunctionType getType() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isStatic() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isExtern() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isAuto() throws DOMException {
            throw new DOMException(this);
        }

        public boolean isRegister() throws DOMException {
            throw new DOMException(this);
        }

        public boolean takesVarArgs() throws DOMException {
            throw new DOMException(this);
        }
    }

    public static class CPPFunctionTemplateDelegate
    extends CPPFunction.CPPFunctionDelegate
    implements ICPPFunctionTemplate,
    ICPPInternalTemplate {
        public CPPFunctionTemplateDelegate(IASTName name, ICPPFunction binding) {
            super(name, binding);
        }

        public ICPPTemplateParameter[] getTemplateParameters() throws DOMException {
            return ((ICPPFunctionTemplate)this.getBinding()).getTemplateParameters();
        }

        public void addSpecialization(IType[] arguments, ICPPSpecialization specialization) {
            ((ICPPInternalTemplate)this.getBinding()).addSpecialization(arguments, specialization);
        }

        public IBinding instantiate(IType[] arguments) {
            return ((ICPPInternalTemplate)this.getBinding()).instantiate(arguments);
        }

        public ICPPSpecialization deferredInstance(IType[] arguments) {
            return ((ICPPInternalTemplate)this.getBinding()).deferredInstance(arguments);
        }

        public ICPPSpecialization getInstance(IType[] arguments) {
            return ((ICPPInternalTemplate)this.getBinding()).getInstance(arguments);
        }
    }
}

