/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedef;

public class CPPTypedefSpecialization
extends CPPSpecialization
implements ITypedef,
ITypeContainer {
    private IType type = null;

    public CPPTypedefSpecialization(IBinding specialized, ICPPScope scope, ObjectMap argumentMap) {
        super(specialized, scope, argumentMap);
    }

    private ITypedef getTypedef() {
        return (ITypedef)this.getSpecializedBinding();
    }

    public IType getType() throws DOMException {
        if (this.type == null) {
            this.type = CPPTemplates.instantiateType(this.getTypedef().getType(), this.argumentMap);
        }
        return this.type;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            try {
                IType t = this.getType();
                if (t != null) {
                    return t.isSameType(((ITypedef)o).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        try {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(o);
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return false;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPTypedef.CPPTypedefDelegate(name, this);
    }

    public void setType(IType type) {
        this.type = type;
    }
}

