/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IIndexerRunner;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.ICIndexStorageConstants;
import org.eclipse.cdt.internal.core.index.cindexstorage.InMemoryIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.IncludeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexerOutput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexOutput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.MergeFactory;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.SimpleIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.index.impl.Int;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public class Index
implements IIndex,
ICIndexStorageConstants,
ICSearchConstants {
    public static final int MAX_FOOTPRINT = 10000000;
    protected InMemoryIndex addsIndex;
    protected IndexInput addsIndexInput;
    protected int state = 1;
    protected Map removedInAdds;
    protected Map removedInOld;
    protected static final int CAN_MERGE = 0;
    protected static final int MERGED = 1;
    private File indexFile;
    private ICDTIndexer indexer = null;
    public String toString;

    public Index(String indexName, String toString, boolean reuseExistingFile, ICDTIndexer indexer) throws IOException {
        this.indexFile = new File(indexName);
        this.toString = toString;
        this.indexer = indexer;
        this.initialize(reuseExistingFile);
    }

    public void add(IFile file, IIndexerRunner indexer) throws IOException {
        IndexedFileEntry indexedFile;
        if (this.timeToMerge()) {
            this.merge();
        }
        if ((indexedFile = this.addsIndex.getIndexedFile(file.getFullPath().toString())) != null) {
            this.remove(indexedFile, 0);
        }
        IndexerOutput output = new IndexerOutput(this.addsIndex);
        indexer.index(file, output);
        this.state = 0;
    }

    protected boolean canMerge() {
        return this.state == 0;
    }

    public void empty() throws IOException {
        if (this.indexFile.exists()) {
            this.indexFile.delete();
            InMemoryIndex mainIndex = new InMemoryIndex();
            BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
            if (!this.indexFile.exists()) {
                mainIndex.save(mainIndexOutput);
            }
        }
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    public int getNumDocuments() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumFiles();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public int getNumWords() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumWords();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public int getNumIncludes() throws IOException {
        int n;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            n = ((IndexInput)input).getNumIncludes();
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return n;
    }

    public String getPath(int documentNumber) throws IOException {
        IndexedFileEntry file;
        BlocksIndexInput input;
        block3: {
            String string;
            input = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)input).open();
                file = ((IndexInput)input).getIndexedFile(documentNumber);
                if (file != null) break block3;
                string = null;
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                ((IndexInput)input).close();
                throw throwable;
            }
            ((IndexInput)input).close();
            return string;
        }
        String string = file.getPath();
        Object var4_7 = null;
        ((IndexInput)input).close();
        return string;
    }

    public String[] getDocumentList() throws IOException {
        String[] stringArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            ((IndexInput)input).open();
            int num = ((IndexInput)input).getNumFiles();
            String[] result = new String[num + 1];
            int i = 1;
            while (i < num + 1) {
                IndexedFileEntry file = ((IndexInput)input).getIndexedFile(i);
                result[i] = file != null ? file.getPath() : null;
                ++i;
            }
            stringArray = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return stringArray;
    }

    public boolean hasChanged() {
        return this.canMerge();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(boolean reuseExistingFile) throws IOException {
        this.addsIndex = new InMemoryIndex();
        this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
        this.removedInAdds = new HashMap(11);
        this.removedInOld = new HashMap(11);
        if (reuseExistingFile && this.indexFile.exists()) {
            BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
            try {
                ((IndexInput)mainIndexInput).open();
            }
            catch (IOException e) {
                BlocksIndexInput input = mainIndexInput;
                try {
                    input.setOpened(true);
                    input.close();
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    input.setOpened(false);
                    throw throwable;
                }
                {
                    Object var5_9 = null;
                    input.setOpened(false);
                    this.indexFile.delete();
                }
                mainIndexInput = null;
                throw e;
            }
            ((IndexInput)mainIndexInput).close();
            return;
        }
        InMemoryIndex mainIndex = new InMemoryIndex();
        BlocksIndexOutput mainIndexOutput = new BlocksIndexOutput(this.indexFile);
        mainIndex.save(mainIndexOutput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void merge() throws IOException {
        File tempFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + "TempVA");
        BlocksIndexInput mainIndexInput = new BlocksIndexInput(this.indexFile);
        BlocksIndexOutput tempIndexOutput = new BlocksIndexOutput(tempFile);
        try {
            new MergeFactory(mainIndexInput, this.addsIndexInput, tempIndexOutput, this.removedInOld, this.removedInAdds).merge();
            File mainIndexFile = (File)((IndexInput)mainIndexInput).getSource();
            File tempIndexFile = (File)tempIndexOutput.getDestination();
            boolean deleted = mainIndexFile.delete();
            int counter = 0;
            while (true) {
                block6: {
                    if (!deleted && counter < 5) break block6;
                    tempIndexFile.renameTo(mainIndexFile);
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                ++counter;
                deleted = mainIndexFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            IndexDelta indexDelta = new IndexDelta(null, null, IIndexDelta.MERGE_DELTA);
            this.indexer.notifyListeners(indexDelta);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.removedInAdds.clear();
            this.removedInOld.clear();
            this.addsIndex.init();
            this.addsIndexInput = new SimpleIndexInput(this.addsIndex);
            this.state = 1;
            CCorePlugin.getDefault().cdtLog.flushLog();
            IndexDelta indexDelta = new IndexDelta(null, null, IIndexDelta.MERGE_DELTA);
            this.indexer.notifyListeners(indexDelta);
            return;
        }
    }

    public IEntryResult[] queryEntries(char[] prefix) throws IOException {
        IEntryResult[] iEntryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iEntryResultArray = ((IndexInput)input).queryEntriesPrefixedBy(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iEntryResultArray;
    }

    public IQueryResult[] queryInDocumentNames(String word) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryInDocumentNames(word);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public IQueryResult[] queryPrefix(char[] prefix) throws IOException {
        IQueryResult[] iQueryResultArray;
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        try {
            iQueryResultArray = ((IndexInput)input).queryFilesReferringToPrefix(prefix);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        ((IndexInput)input).close();
        return iQueryResultArray;
    }

    public String[] getFileDependencies(IPath filePath) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getFileDependencies(IFile file) throws IOException {
        BlocksIndexInput input = new BlocksIndexInput(this.indexFile);
        int fileNum = 0;
        ArrayList<String> tempFileReturn = new ArrayList<String>();
        try {
            ((IndexInput)input).open();
            IndexedFileEntry inFile = ((IndexInput)input).getIndexedFile(file.getFullPath().toString());
            fileNum = inFile.getFileID();
            IncludeEntry[] tempEntries = ((IndexInput)input).queryIncludeEntries(fileNum);
            int i = 0;
            while (i < tempEntries.length) {
                char[] tempFile = tempEntries[i].getFile();
                StringBuffer tempString = new StringBuffer();
                tempString.append(tempFile);
                tempFileReturn.add(tempString.toString());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            ((IndexInput)input).close();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        ((IndexInput)input).close();
        return tempFileReturn.toArray(new String[tempFileReturn.size()]);
    }

    public void remove(String documentName) throws IOException {
        IndexedFileEntry file = this.addsIndex.getIndexedFile(documentName);
        if (file != null) {
            Int lastRemoved = (Int)this.removedInAdds.get(documentName);
            if (lastRemoved != null) {
                int fileNum = file.getFileID();
                if (lastRemoved.value < fileNum) {
                    lastRemoved.value = fileNum;
                }
            } else {
                this.removedInAdds.put(documentName, new Int(file.getFileID()));
            }
        } else {
            this.removedInOld.put(documentName, new Int(1));
        }
        this.state = 0;
    }

    protected void remove(IndexedFileEntry file, int index) throws IOException {
        String name = file.getPath();
        if (index == 0) {
            Int lastRemoved = (Int)this.removedInAdds.get(name);
            if (lastRemoved != null) {
                if (lastRemoved.value < file.getFileID()) {
                    lastRemoved.value = file.getFileID();
                }
            } else {
                this.removedInAdds.put(name, new Int(file.getFileID()));
            }
        } else if (index == 1) {
            this.removedInOld.put(name, new Int(1));
        } else {
            throw new Error();
        }
        this.state = 0;
    }

    public void save() throws IOException {
        if (this.canMerge()) {
            this.merge();
        }
    }

    protected boolean timeToMerge() {
        return this.addsIndex.getFootprint() >= 10000000L;
    }

    public String toString() {
        String str = this.toString;
        if (str == null) {
            str = super.toString();
        }
        str = String.valueOf(str) + "(length: " + this.getIndexFile().length() + ")";
        return str;
    }

    public ICDTIndexer getIndexer() {
        return this.indexer;
    }

    public IEntryResult[] queryEntries(char[] prefix, char optionalType, char[] name, char[][] containingTypes, int matchMode, boolean isCaseSensitive) throws IOException {
        return this.queryEntries(Index.bestPrefix(prefix, optionalType, name, containingTypes, matchMode, isCaseSensitive));
    }

    public static final char[] bestTypePrefix(ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, char[] typeName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(1, 0, 1);
        } else if (limitTo == DEFINITIONS) {
            prefix = Index.encodeEntry(1, 0, 3);
        } else if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(1, 0, 2);
        } else {
            return Index.encodeEntry(1, 0, 0);
        }
        char classType = '\u0000';
        if (searchFor == ICSearchConstants.CLASS) {
            classType = typeConstants[1];
        } else if (searchFor == ICSearchConstants.STRUCT) {
            classType = typeConstants[2];
        } else if (searchFor == ICSearchConstants.UNION) {
            classType = typeConstants[3];
        } else if (searchFor == ICSearchConstants.ENUM) {
            classType = typeConstants[4];
        } else if (searchFor == ICSearchConstants.TYPEDEF) {
            classType = typeConstants[5];
        } else if (searchFor == ICSearchConstants.DERIVED) {
            classType = typeConstants[6];
        } else if (searchFor == ICSearchConstants.FRIEND) {
            classType = typeConstants[7];
        } else {
            return prefix;
        }
        return Index.bestPrefix(prefix, classType, typeName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestNamespacePrefix(ICSearchConstants.LimitTo limitTo, char[] namespaceName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(6, 0, 2);
        } else if (limitTo == DEFINITIONS) {
            prefix = Index.encodeEntry(6, 0, 3);
        } else {
            return Index.encodeEntry(6, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', namespaceName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestVariablePrefix(ICSearchConstants.LimitTo limitTo, char[] varName, char[][] containingTypes, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(9, 0, 2);
        } else if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(9, 0, 1);
        } else if (limitTo == DEFINITIONS) {
            prefix = Index.encodeEntry(9, 0, 3);
        } else {
            return Index.encodeEntry(9, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', varName, containingTypes, matchMode, isCaseSenstive);
    }

    public static final char[] bestFieldPrefix(ICSearchConstants.LimitTo limitTo, char[] fieldName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(4, 0, 2);
        } else if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(4, 0, 1);
        } else if (limitTo == DEFINITIONS) {
            prefix = Index.encodeEntry(4, 0, 3);
        } else {
            return Index.encodeEntry(4, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', fieldName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestEnumeratorPrefix(ICSearchConstants.LimitTo limitTo, char[] enumeratorName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(7, 0, 2);
        } else if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(7, 0, 1);
        } else if (limitTo == DEFINITIONS) {
            prefix = Index.encodeEntry(7, 0, 3);
        } else if (limitTo == ALL_OCCURRENCES) {
            return Index.encodeEntry(7, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', enumeratorName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestMethodPrefix(ICSearchConstants.LimitTo limitTo, char[] methodName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(3, 0, 2);
        } else if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(3, 0, 1);
        } else {
            if (limitTo == DEFINITIONS) {
                return Index.encodeEntry(3, 0, 3);
            }
            return Index.encodeEntry(3, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', methodName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestFunctionPrefix(ICSearchConstants.LimitTo limitTo, char[] functionName, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == REFERENCES) {
            prefix = Index.encodeEntry(2, 0, 2);
        } else if (limitTo == DECLARATIONS) {
            prefix = Index.encodeEntry(2, 0, 1);
        } else {
            if (limitTo == DEFINITIONS) {
                return Index.encodeEntry(2, 0, 3);
            }
            return Index.encodeEntry(2, 0, 0);
        }
        return Index.bestPrefix(prefix, '\u0000', functionName, null, matchMode, isCaseSensitive);
    }

    public static final char[] bestPrefix(char[] prefix, char optionalType, char[] name, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        int wildPos;
        int questionPos;
        char[] temp;
        int length;
        int starPos;
        int pos;
        char[] result;
        block22: {
            block21: {
                result = null;
                pos = 0;
                starPos = -1;
                length = prefix.length;
                if (optionalType != '\u0000') {
                    length += 2;
                }
                if (isCaseSensitive) break block21;
                name = null;
                break block22;
            }
            if (matchMode != 2 || name == null) break block22;
            temp = new char[name.length];
            boolean isEscaped = false;
            int tmpIdx = 0;
            int i = 0;
            while (i < name.length) {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                if (name[i] != '\\') break block23;
                                if (isEscaped) break block24;
                                isEscaped = true;
                                break block25;
                            }
                            isEscaped = false;
                            break block26;
                        }
                        if (name[i] == '*' && !isEscaped) {
                            starPos = i;
                            break;
                        }
                    }
                    temp[tmpIdx++] = name[i];
                }
                ++i;
            }
            name = new char[tmpIdx];
            System.arraycopy(temp, 0, name, 0, tmpIdx);
            questionPos = CharOperation.indexOf('?', name);
            wildPos = starPos >= 0 ? (questionPos >= 0 ? (starPos < questionPos ? starPos : questionPos) : starPos) : questionPos;
            switch (wildPos) {
                case -1: {
                    break;
                }
                case 0: {
                    name = null;
                    break;
                }
                default: {
                    name = CharOperation.subarray(name, 0, wildPos);
                }
            }
        }
        if (name != null) {
            length += name.length;
        } else {
            result = new char[length];
            pos = prefix.length;
            System.arraycopy(prefix, 0, result, 0, pos);
            if (optionalType != '\u0000') {
                result[pos++] = optionalType;
                result[pos++] = 47;
            }
            return result;
        }
        if (containingTypes != null) {
            int i = 0;
            while (i < containingTypes.length) {
                if (containingTypes[i].length > 0) {
                    length += containingTypes[i].length;
                    ++length;
                }
                ++i;
            }
        }
        temp = new char[length];
        pos = prefix.length;
        System.arraycopy(prefix, 0, temp, 0, pos);
        if (optionalType != '\u0000') {
            temp[pos++] = optionalType;
            temp[pos++] = 47;
        }
        System.arraycopy(name, 0, temp, pos, name.length);
        pos += name.length;
        if (containingTypes != null) {
            int i = containingTypes.length - 1;
            while (i >= 0) {
                if (matchMode == 2) {
                    starPos = CharOperation.indexOf('*', containingTypes[i]);
                    questionPos = CharOperation.indexOf('?', containingTypes[i]);
                    wildPos = starPos >= 0 ? (questionPos >= 0 ? (starPos < questionPos ? starPos : questionPos) : starPos) : questionPos;
                    if (wildPos >= 0) {
                        temp[pos++] = 47;
                        System.arraycopy(containingTypes[i], 0, temp, pos, wildPos);
                        pos += starPos;
                        break;
                    }
                }
                if (containingTypes[i].length > 0) {
                    temp[pos++] = 47;
                    System.arraycopy(containingTypes[i], 0, temp, pos, containingTypes[i].length);
                    pos += containingTypes[i].length;
                }
                --i;
            }
        }
        if (pos < length) {
            result = new char[pos];
            System.arraycopy(temp, 0, result, 0, pos);
        } else {
            result = temp;
        }
        return result;
    }

    public static final char[] bestMacroPrefix(ICSearchConstants.LimitTo limitTo, char[] macroName, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo != DECLARATIONS) {
            return null;
        }
        prefix = Index.encodeEntry(5, 0, 1);
        return Index.bestPrefix(prefix, '\u0000', macroName, null, matchMode, isCaseSenstive);
    }

    public static final char[] bestIncludePrefix(ICSearchConstants.LimitTo limitTo, char[] incName, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo != REFERENCES) {
            return null;
        }
        prefix = Index.encodeEntry(8, 0, 2);
        return Index.bestPrefix(prefix, '\u0000', incName, null, matchMode, isCaseSenstive);
    }

    public static String getDescriptionOf(int meta_kind, int kind, int ref) {
        StringBuffer buff = new StringBuffer();
        buff.append(encodings[meta_kind]);
        buff.append(encodingTypes[ref]);
        if (kind != 0) {
            buff.append(typeConstants[kind]);
            buff.append('/');
        }
        return buff.toString();
    }

    public static char[] encodeEntry(int meta_kind, int kind, int ref, String name) {
        StringBuffer buff = new StringBuffer();
        buff.append(encodings[meta_kind]);
        buff.append(encodingTypes[ref]);
        if (kind != 0) {
            buff.append(typeConstants[kind]);
            buff.append('/');
        }
        buff.append(name);
        return buff.toString().toCharArray();
    }

    public static char[] encodeEntry(int meta_kind, int kind, int ref) {
        StringBuffer buff = new StringBuffer();
        buff.append(encodings[meta_kind]);
        buff.append(encodingTypes[ref]);
        if (kind != 0) {
            buff.append(typeConstants[kind]);
        }
        return buff.toString().toCharArray();
    }

    public IEntryResult[] getEntries(int meta_kind, int kind, int ref, String name) throws IOException {
        return this.queryEntries(Index.encodeEntry(meta_kind, kind, ref, name));
    }

    public IEntryResult[] getEntries(int meta_kind, int kind, int ref) throws IOException {
        return this.queryEntries(Index.encodeEntry(meta_kind, kind, ref));
    }

    public IQueryResult[] getPrefix(int meta_kind, int kind, int ref, String name) throws IOException {
        return this.queryPrefix(Index.encodeEntry(meta_kind, kind, ref, name));
    }

    public IQueryResult[] getPrefix(int meta_kind, int kind, int ref) throws IOException {
        return this.queryPrefix(Index.encodeEntry(meta_kind, kind, ref));
    }
}

