/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.cindexstorage.Util;

public class WordEntry {
    private int encodings;
    private int encodingType;
    private int typeConstant;
    private char[] word;
    private int fileRefCount;
    private int[] fileRefs;
    private int[] modifiers;
    private int[][] offsets;
    private int[][] offsetLengths;
    private int[] offsetCount;

    public WordEntry() {
        this(CharOperation.NO_CHAR);
    }

    public WordEntry(char[] word) {
        this.word = word;
        this.fileRefCount = 0;
        this.fileRefs = new int[1];
        this.modifiers = new int[1];
        this.offsets = new int[1][1];
        this.offsetLengths = new int[1][1];
        this.offsetCount = new int[1];
    }

    public int addRef(int fileNum) {
        if (this.fileRefCount > 0 && this.fileAlreadyAdded(fileNum)) {
            return 0;
        }
        if (this.fileRefCount < this.fileRefs.length) {
            this.fileRefs[this.fileRefCount++] = fileNum;
            return 0;
        }
        int newSize = this.fileRefCount < 4 ? 4 : this.fileRefCount * 2;
        this.fileRefs = new int[newSize];
        System.arraycopy(this.fileRefs, 0, this.fileRefs, 0, this.fileRefCount);
        this.modifiers = new int[newSize];
        System.arraycopy(this.modifiers, 0, this.modifiers, 0, this.fileRefCount);
        this.offsets = new int[newSize][1];
        System.arraycopy(this.offsets, 0, this.offsets, 0, this.fileRefCount);
        this.offsetLengths = new int[newSize][1];
        System.arraycopy(this.offsetLengths, 0, this.offsetLengths, 0, this.fileRefCount);
        this.offsetCount = new int[newSize];
        System.arraycopy(this.offsetCount, 0, this.offsetCount, 0, this.fileRefCount);
        this.fileRefs[this.fileRefCount++] = fileNum;
        return (newSize - this.fileRefCount + 1) * 4;
    }

    private boolean fileAlreadyAdded(int fileNum) {
        int i = 0;
        while (i < this.fileRefCount) {
            if (this.fileRefs[i] == fileNum) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addWordInfo(int[] refs, int[][] passedOffsets, int[][] passedOffsetLengths, int[] passedOffsetCount, int[] passedModifers) {
        int[] newRefs = new int[this.fileRefCount + refs.length];
        int[][] newOffsets = new int[this.fileRefCount + refs.length][];
        int[][] newOffsetLengths = new int[this.fileRefCount + refs.length][];
        int[] newOffSetCount = new int[this.fileRefCount + refs.length];
        int[] newModifiers = new int[this.fileRefCount + refs.length];
        int pos1 = 0;
        int pos2 = 0;
        int posNew = 0;
        int r1 = 0;
        int r2 = 0;
        while (pos1 < this.fileRefCount || pos2 < refs.length) {
            int compare;
            if (pos1 >= this.fileRefCount) {
                r2 = refs[pos2];
                compare = -1;
            } else if (pos2 >= refs.length) {
                compare = 1;
                r1 = this.fileRefs[pos1];
            } else {
                r1 = this.fileRefs[pos1];
                r2 = refs[pos2];
                compare = r2 - r1;
            }
            if (compare > 0) {
                newRefs[posNew] = r1;
                newOffsets[posNew] = this.offsets[pos1];
                newOffsetLengths[posNew] = this.offsetLengths[pos1];
                newOffSetCount[posNew] = this.offsetCount[pos1];
                newModifiers[posNew] = this.modifiers[pos1];
                ++posNew;
                ++pos1;
                continue;
            }
            if (r2 != 0) {
                newRefs[posNew] = r2;
                newOffsets[posNew] = passedOffsets[pos2];
                newOffsetLengths[posNew] = passedOffsetLengths[pos2];
                newOffSetCount[posNew] = passedOffsetCount[pos2];
                newModifiers[posNew] = passedModifers[pos2];
                ++posNew;
            }
            ++pos2;
        }
        this.fileRefs = newRefs;
        this.offsets = newOffsets;
        this.offsetLengths = newOffsetLengths;
        this.offsetCount = newOffSetCount;
        this.modifiers = newModifiers;
        this.fileRefCount = posNew;
    }

    public int addOffset(int offset, int offsetLength, int fileNum, int offsetType) {
        int filePosition = this.getPositionForFile(fileNum);
        if (filePosition == -1) {
            return -1;
        }
        int[] selectedOffsets = this.offsets[filePosition];
        int[] selectedOffsetLengths = this.offsetLengths[filePosition];
        int selectedOffsetCount = this.offsetCount[filePosition];
        int encodedNumber = this.getEncodedNumber(offsetType, offset);
        if (selectedOffsetCount > 0 && this.offsetAlreadyAdded(filePosition, encodedNumber)) {
            return 0;
        }
        if (selectedOffsetCount < selectedOffsets.length) {
            selectedOffsets[selectedOffsetCount] = encodedNumber;
            selectedOffsetLengths[selectedOffsetCount++] = offsetLength;
            this.offsetCount[filePosition] = selectedOffsetCount;
            return 0;
        }
        int newSize = selectedOffsetCount < 4 ? 4 : selectedOffsetCount * 2;
        int[] nArray = selectedOffsets;
        selectedOffsets = new int[newSize];
        System.arraycopy(nArray, 0, selectedOffsets, 0, selectedOffsetCount);
        int[] nArray2 = selectedOffsetLengths;
        selectedOffsetLengths = new int[newSize];
        System.arraycopy(nArray2, 0, selectedOffsetLengths, 0, selectedOffsetCount);
        selectedOffsets[selectedOffsetCount] = encodedNumber;
        selectedOffsetLengths[selectedOffsetCount++] = offsetLength;
        this.offsetCount[filePosition] = selectedOffsetCount;
        this.offsets[filePosition] = selectedOffsets;
        this.offsetLengths[filePosition] = selectedOffsetLengths;
        return (newSize - this.fileRefCount + 1) * 4;
    }

    public int addModifiers(int modifier, int fileNum) {
        int filePosition = this.getPositionForFile(fileNum);
        if (filePosition == -1) {
            return -1;
        }
        if (modifier <= 0) {
            // empty if block
        }
        this.modifiers[filePosition] = modifier;
        return 0;
    }

    private int getEncodedNumber(int offsetType, int offset) {
        int m = 10;
        while (m <= offset) {
            m *= 10;
        }
        return m * offsetType + offset;
    }

    private boolean offsetAlreadyAdded(int filePosition, int offset) {
        int[] tempOffset = this.offsets[filePosition];
        int i = 0;
        while (i < tempOffset.length) {
            if (tempOffset[i] == offset) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getPositionForFile(int fileNum) {
        int i = 0;
        while (i < this.fileRefCount) {
            if (this.fileRefs[i] == fileNum) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int footprint() {
        return 24 + (8 + this.word.length * 2) + (8 + this.fileRefs.length * 4);
    }

    public int getNumRefs() {
        return this.fileRefCount;
    }

    public int getRef(int i) {
        if (i < this.fileRefCount) {
            return this.fileRefs[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getRefs() {
        int[] result = new int[this.fileRefCount];
        System.arraycopy(this.fileRefs, 0, result, 0, this.fileRefCount);
        return result;
    }

    public int[][] getOffsets() {
        int[][] result = new int[this.fileRefCount][];
        int i = 0;
        while (i < this.fileRefCount) {
            int offsetLength = this.offsetCount[i];
            int[] tempOffset = new int[offsetLength];
            System.arraycopy(this.offsets[i], 0, tempOffset, 0, offsetLength);
            result[i] = tempOffset;
            ++i;
        }
        return result;
    }

    public int[][] getOffsetLengths() {
        int[][] result = new int[this.fileRefCount][];
        int i = 0;
        while (i < this.fileRefCount) {
            int offsetLength = this.offsetCount[i];
            int[] tempOffset = new int[offsetLength];
            System.arraycopy(this.offsetLengths[i], 0, tempOffset, 0, offsetLength);
            result[i] = tempOffset;
            ++i;
        }
        return result;
    }

    public int[] getOffsetCount() {
        int[] result = new int[this.fileRefCount];
        System.arraycopy(this.offsetCount, 0, result, 0, this.fileRefCount);
        return result;
    }

    public char[] getWord() {
        return this.word;
    }

    public void mapRefs(int[] mappings) {
        int position = 0;
        int i = 0;
        while (i < this.fileRefCount) {
            int map = -1;
            if (this.fileRefs[i] >= 0 && this.fileRefs[i] < mappings.length) {
                map = mappings[this.fileRefs[i]];
            }
            if (map != -1 && map != 0) {
                this.fileRefs[position++] = map;
            }
            ++i;
        }
        this.fileRefCount = position;
        this.fileRefs = new int[this.fileRefCount];
        System.arraycopy(this.fileRefs, 0, this.fileRefs, 0, this.fileRefCount);
        this.offsets = new int[this.fileRefCount][];
        System.arraycopy(this.offsets, 0, this.offsets, 0, this.fileRefCount);
        this.offsetLengths = new int[this.fileRefCount][];
        System.arraycopy(this.offsetLengths, 0, this.offsetLengths, 0, this.fileRefCount);
        this.offsetCount = new int[this.fileRefCount];
        System.arraycopy(this.offsetCount, 0, this.offsetCount, 0, this.fileRefCount);
        this.modifiers = new int[this.fileRefCount];
        System.arraycopy(this.modifiers, 0, this.modifiers, 0, this.fileRefCount);
        int[] originalRefs = new int[this.fileRefCount];
        System.arraycopy(this.fileRefs, 0, originalRefs, 0, this.fileRefCount);
        Util.sort(this.fileRefs);
        int[] mapping = new int[this.fileRefs.length];
        this.figureOutMapping(originalRefs, this.fileRefs, mapping);
        this.mapOffsets(mapping);
        this.mapModiers(mapping);
    }

    private void mapOffsets(int[] mapping) {
        int fileRefLength = this.fileRefs.length;
        int[][] tempOffsetsArray = new int[fileRefLength][];
        int[][] tempOffsetsLengthArray = new int[fileRefLength][];
        int[] tempOffsetCountArray = new int[fileRefLength];
        int i = 0;
        while (i < mapping.length) {
            int moveTo = mapping[i];
            tempOffsetsArray[moveTo] = this.offsets[i];
            tempOffsetsLengthArray[moveTo] = this.offsetLengths[i];
            tempOffsetCountArray[moveTo] = this.offsetCount[i];
            ++i;
        }
        System.arraycopy(tempOffsetsArray, 0, this.offsets, 0, fileRefLength);
        System.arraycopy(tempOffsetsLengthArray, 0, this.offsetLengths, 0, fileRefLength);
        System.arraycopy(tempOffsetCountArray, 0, this.offsetCount, 0, fileRefLength);
    }

    private void mapModiers(int[] mapping) {
        int fileRefLength = this.fileRefs.length;
        int[] tempModifierArray = new int[fileRefLength];
        int i = 0;
        while (i < mapping.length) {
            int moveTo = mapping[i];
            tempModifierArray[moveTo] = this.modifiers[i];
            ++i;
        }
        System.arraycopy(tempModifierArray, 0, this.modifiers, 0, fileRefLength);
    }

    private void figureOutMapping(int[] originalRefs, int[] sortedRefs, int[] mapping) {
        int position = 0;
        int i = 0;
        while (i < originalRefs.length) {
            int currentRef = originalRefs[i];
            int j = 0;
            while (j < sortedRefs.length) {
                if (currentRef == sortedRefs[j]) {
                    mapping[position++] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void reset(char[] word) {
        int i = this.fileRefCount;
        while (i-- > 0) {
            this.fileRefs[i] = 0;
        }
        this.fileRefCount = 0;
        this.word = word;
    }

    public String toString() {
        return new String(this.word);
    }

    public int[] getOffsets(int index) {
        int[] tempOffset = this.offsets[index];
        int offsetLength = this.offsetCount[index];
        int[] result = new int[offsetLength];
        System.arraycopy(tempOffset, 0, result, 0, offsetLength);
        Util.sort(result);
        return result;
    }

    public int[] getOffsetLengths(int index) {
        int[] initialOffsets = this.offsets[index];
        int[] sortedOffsets = this.getOffsets(index);
        int[] map = new int[sortedOffsets.length];
        this.figureOutMapping(initialOffsets, sortedOffsets, map);
        int[] tempOffset = this.offsetLengths[index];
        int offsetLength = this.offsetCount[index];
        int[] result = new int[offsetLength];
        int i = 0;
        while (i < map.length) {
            int moveTo = map[i];
            result[moveTo] = tempOffset[i];
            ++i;
        }
        return result;
    }

    public void setOffsets(int index, int[] tempOffsetArray) {
        int[] selectedOffsets = this.offsets[index];
        int tempOffsetArrayLength = tempOffsetArray.length;
        int newSize = tempOffsetArrayLength < 4 ? 4 : tempOffsetArrayLength * 2;
        selectedOffsets = new int[newSize];
        System.arraycopy(tempOffsetArray, 0, selectedOffsets, 0, tempOffsetArrayLength);
        this.offsetCount[index] = tempOffsetArrayLength;
        this.offsets[index] = selectedOffsets;
    }

    public void setOffsetLengths(int index, int[] tempOffsetArray) {
        int[] selectedOffsets = this.offsetLengths[index];
        int tempOffsetArrayLength = tempOffsetArray.length;
        int newSize = tempOffsetArrayLength < 4 ? 4 : tempOffsetArrayLength * 2;
        selectedOffsets = new int[newSize];
        System.arraycopy(tempOffsetArray, 0, selectedOffsets, 0, tempOffsetArrayLength);
        this.offsetLengths[index] = selectedOffsets;
    }

    public int getModifiers(int i) {
        if (i < this.fileRefCount) {
            return this.modifiers[i];
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getModifiers() {
        int[] result = new int[this.fileRefCount];
        System.arraycopy(this.modifiers, 0, result, 0, this.fileRefCount);
        return result;
    }

    public void setModifier(int index, int modifier) {
        this.modifiers[index] = modifier;
    }
}

