/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.ctagsindexer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.core.index.FunctionEntry;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.index.INamedEntry;
import org.eclipse.cdt.internal.core.index.NamedEntry;
import org.eclipse.cdt.internal.core.index.TypeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.ICIndexStorageConstants;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsConsoleParser;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

class CTagEntry {
    private final CTagsConsoleParser parser;
    String elementName;
    String fileName;
    int lineNumber;
    HashMap tagExtensionField;
    String line;

    public CTagEntry(CTagsConsoleParser parser, String line) {
        this.line = line;
        this.parser = parser;
        this.elementName = "";
        this.fileName = "";
        this.lineNumber = 0;
        this.tagExtensionField = new HashMap();
        this.parse();
    }

    void parse() {
        String delim = "\t";
        StringTokenizer st = new StringTokenizer(this.line, delim);
        int state = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case 0: {
                    this.elementName = token;
                    break;
                }
                case 1: {
                    this.fileName = token;
                    break;
                }
                case 2: {
                    try {
                        String sub = token.trim();
                        int i = sub.indexOf(59);
                        String num = sub.substring(0, i);
                        if (!Character.isDigit(num.charAt(0))) break;
                        this.lineNumber = Integer.parseInt(num);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                default: {
                    int i = token.indexOf(58);
                    if (i == -1) break;
                    String key = token.substring(0, i);
                    String value = token.substring(i + 1);
                    this.tagExtensionField.put(key, value);
                }
            }
            ++state;
        }
    }

    public char[][] getQualifiedName() {
        char[][] fullName = null;
        String name = null;
        String[] types = new String[]{"namespace", "class", "struct", "union", "function", "enum"};
        int i = 0;
        while (i < types.length) {
            name = (String)this.tagExtensionField.get(types[i]);
            if (name != null) break;
            ++i;
        }
        if (name != null) {
            StringTokenizer st = new StringTokenizer(name, "::");
            fullName = new char[st.countTokens() + 1][];
            int i2 = 0;
            while (st.hasMoreTokens()) {
                fullName[i2] = st.nextToken().toCharArray();
                ++i2;
            }
            fullName[i2] = this.elementName.toCharArray();
        } else {
            fullName = new char[][]{this.elementName.toCharArray()};
        }
        return fullName;
    }

    public void addTagToIndexOutput(int fileNum, IIndexerOutput output) {
        String kind = (String)this.tagExtensionField.get("kind");
        if (kind == null) {
            return;
        }
        char[][] fullName = this.getQualifiedName();
        if (kind.equals("class")) {
            TypeEntry typeEntry = new TypeEntry(1, 3, fullName, this.getModifiers(), fileNum);
            typeEntry.setNameOffset(this.lineNumber, 1, 1);
            typeEntry.setBaseTypes(this.getInherits());
            typeEntry.serialize(output);
        } else if (kind.equals("macro")) {
            NamedEntry namedEntry = new NamedEntry(5, 1, fullName, this.getModifiers(), fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        } else if (kind.equals("enumerator")) {
            NamedEntry namedEntry = new NamedEntry(7, 1, fullName, this.getModifiers(), fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        } else if (kind.equals("function")) {
            String isMethod = (String)this.tagExtensionField.get("class");
            if (isMethod != null) {
                FunctionEntry funEntry = new FunctionEntry(3, 3, fullName, this.getModifiers(), fileNum);
                funEntry.setSignature(this.getFunctionSignature());
                funEntry.setNameOffset(this.lineNumber, 1, 1);
                funEntry.serialize(output);
            } else {
                FunctionEntry funEntry = new FunctionEntry(2, 3, fullName, this.getModifiers(), fileNum);
                funEntry.setSignature(this.getFunctionSignature());
                funEntry.setNameOffset(this.lineNumber, 1, 1);
                funEntry.serialize(output);
            }
        } else if (kind.equals("enum")) {
            TypeEntry typeEntry = new TypeEntry(4, 1, fullName, this.getModifiers(), fileNum);
            typeEntry.setNameOffset(this.lineNumber, 1, 1);
            typeEntry.serialize(output);
        } else if (kind.equals("member")) {
            NamedEntry namedEntry = new NamedEntry(4, 3, fullName, this.getModifiers(), fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        } else if (kind.equals("namespace")) {
            NamedEntry namedEntry = new NamedEntry(6, 3, fullName, this.getModifiers(), fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        } else if (kind.equals("prototype")) {
            String isMethod = (String)this.tagExtensionField.get("class");
            if (isMethod != null) {
                FunctionEntry funEntry = new FunctionEntry(3, 1, fullName, this.getModifiers(), fileNum);
                funEntry.setSignature(this.getFunctionSignature());
                funEntry.setNameOffset(this.lineNumber, 1, 1);
                funEntry.serialize(output);
            } else {
                FunctionEntry funEntry = new FunctionEntry(2, 1, fullName, this.getModifiers(), fileNum);
                funEntry.setSignature(this.getFunctionSignature());
                funEntry.setNameOffset(this.lineNumber, 1, 1);
                funEntry.serialize(output);
            }
        } else if (kind.equals("struct")) {
            TypeEntry typeEntry = new TypeEntry(2, 3, fullName, this.getModifiers(), fileNum);
            typeEntry.setNameOffset(this.lineNumber, 1, 1);
            typeEntry.setBaseTypes(this.getInherits());
            typeEntry.serialize(output);
        } else if (kind.equals("typedef")) {
            TypeEntry typeEntry = new TypeEntry(5, 1, fullName, this.getModifiers(), fileNum);
            typeEntry.setNameOffset(this.lineNumber, 1, 1);
            typeEntry.serialize(output);
        } else if (kind.equals("union")) {
            TypeEntry typeEntry = new TypeEntry(3, 3, fullName, this.getModifiers(), fileNum);
            typeEntry.setNameOffset(this.lineNumber, 1, 1);
            typeEntry.serialize(output);
        } else if (kind.equals("variable")) {
            NamedEntry namedEntry = new NamedEntry(9, 1, fullName, this.getModifiers(), fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        } else if (kind.equals("externvar")) {
            int modifiers = this.getModifiers();
            NamedEntry namedEntry = new NamedEntry(9, 1, fullName, modifiers |= 0x40, fileNum);
            namedEntry.setNameOffset(this.lineNumber, 1, 1);
            namedEntry.serialize(output);
        }
    }

    private char[][] getFunctionSignature() {
        String signature = (String)this.tagExtensionField.get("signature");
        if (signature == null || signature.equals("()")) {
            char[][] voidSignature = new char[][]{"void".toCharArray()};
            return voidSignature;
        }
        return CSearchPattern.scanForParameters(signature);
    }

    private int getModifiers() {
        String implementation;
        int modifier = 0;
        String access = (String)this.tagExtensionField.get("access");
        if (access != null) {
            int i = 0;
            while (i < ICIndexStorageConstants.allSpecifiers.length) {
                if (access.equals(ICIndexStorageConstants.allSpecifiers[i])) {
                    int tempNum = 1 << i;
                    modifier |= tempNum;
                    break;
                }
                ++i;
            }
        }
        if ((implementation = (String)this.tagExtensionField.get("implementation")) != null) {
            int i = 0;
            while (i < ICIndexStorageConstants.allSpecifiers.length) {
                if (implementation.equals(ICIndexStorageConstants.allSpecifiers[i])) {
                    int tempNum = 1 << i;
                    modifier |= tempNum;
                }
                ++i;
            }
        }
        return modifier;
    }

    private INamedEntry[] getInherits() {
        String access = (String)this.tagExtensionField.get("inherits");
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, ",");
            LinkedList<String> list = new LinkedList<String>();
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
            String[] inherits = new String[]{};
            inherits = list.toArray(inherits);
            INamedEntry[] inherits2 = new INamedEntry[inherits.length];
            int i = 0;
            while (i < inherits.length) {
                NamedEntry tempEntry = new NamedEntry(4, 2, inherits[i], 1, 1);
                inherits2[i] = tempEntry;
                ++i;
            }
            return inherits2;
        }
        return null;
    }
}

