/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.internal.core.index.FunctionEntry;
import org.eclipse.cdt.internal.core.index.NamedEntry;
import org.eclipse.cdt.internal.core.index.TypeEntry;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexerRunner;
import org.eclipse.cdt.internal.core.index.domsourceindexer.IndexEncoderUtil;
import org.eclipse.cdt.internal.core.index.domsourceindexer.IndexVisitorUtil;
import org.eclipse.cdt.internal.core.model.Util;

public class CGenerateIndexVisitor
extends CASTVisitor {
    private DOMSourceIndexerRunner indexer;

    public CGenerateIndexVisitor(DOMSourceIndexerRunner indexer) {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitProblems = true;
        this.indexer = indexer;
    }

    public int visit(IASTDeclaration declaration) {
        if (IndexEncoderUtil.nodeInVisitedExternalHeader(declaration, this.indexer.getIndexer())) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTName name) {
        try {
            this.processName(name);
        }
        catch (DOMException e) {
            e.printStackTrace();
            Util.log((Throwable)((Object)e), e.getProblem().getMessage(), ICLogConstants.CDT);
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.log(e, e.toString(), ICLogConstants.CDT);
        }
        return 3;
    }

    public int visit(IASTProblem problem) {
        if (this.indexer.areProblemMarkersEnabled() && this.indexer.shouldRecordProblem(problem)) {
            IASTFileLocation loc = IndexEncoderUtil.getFileLocation(problem);
            this.indexer.processProblem(problem.getMessage(), loc);
        }
        return super.visit(problem);
    }

    private void processName(IASTName name) throws DOMException {
        if (IndexEncoderUtil.nodeInVisitedExternalHeader(name, this.indexer.getIndexer())) {
            return;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null) {
            return;
        }
        if (binding instanceof IProblemBinding) {
            IProblemBinding problem = (IProblemBinding)binding;
            if (this.indexer.areProblemMarkersEnabled() && this.indexer.shouldRecordProblem(problem)) {
                IASTFileLocation loc = IndexEncoderUtil.getFileLocation(name);
                this.indexer.processProblem(problem.getMessage(), loc);
            }
            return;
        }
        IASTFileLocation loc = IndexEncoderUtil.getFileLocation(name);
        if (loc != null) {
            int indexFlag = IndexEncoderUtil.calculateIndexFlags(this.indexer, loc);
            this.processNameBinding(name, binding, loc, indexFlag);
        }
    }

    private void processNameBinding(IASTName name, IBinding binding, IASTFileLocation loc, int fileNumber) throws DOMException {
        char[][] qualifiedName = this.getFullyQualifiedName(name);
        if (qualifiedName == null) {
            return;
        }
        int entryKind = 0;
        if (name.isDefinition()) {
            entryKind = 3;
        } else if (name.isDeclaration()) {
            entryKind = 1;
        } else if (name.isReference()) {
            entryKind = 2;
        } else {
            return;
        }
        IASTFileLocation fileLoc = IndexEncoderUtil.getFileLocation(name);
        if (binding instanceof ICompositeType) {
            int iEntryType = 0;
            int compositeKey = ((ICompositeType)binding).getKey();
            ASTNodeProperty prop = name.getPropertyInParent();
            switch (compositeKey) {
                case 1: {
                    iEntryType = 2;
                    if (!name.isDeclaration() || prop != IASTElaboratedTypeSpecifier.TYPE_NAME) break;
                    iEntryType = 2;
                    break;
                }
                case 2: {
                    iEntryType = 3;
                    if (!name.isDeclaration() || prop != IASTElaboratedTypeSpecifier.TYPE_NAME) break;
                    iEntryType = 3;
                }
            }
            int modifiers = 0;
            if (entryKind != 2) {
                modifiers = IndexVisitorUtil.getModifiers(name, binding);
            }
            if (iEntryType != 0) {
                TypeEntry indexEntry = new TypeEntry(iEntryType, entryKind, qualifiedName, modifiers, fileNumber);
                indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
                indexEntry.serialize(this.indexer.getOutput());
            }
        } else if (binding instanceof IEnumeration) {
            int modifiers = 0;
            if (entryKind != 2) {
                modifiers = IndexVisitorUtil.getModifiers(name, binding);
            }
            TypeEntry indexEntry = new TypeEntry(4, entryKind, qualifiedName, modifiers, fileNumber);
            indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
            indexEntry.serialize(this.indexer.getOutput());
        } else if (binding instanceof ITypedef) {
            TypeEntry indexEntry = new TypeEntry(5, entryKind, qualifiedName, 0, fileNumber);
            indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
            indexEntry.serialize(this.indexer.getOutput());
        } else if (binding instanceof IEnumerator) {
            NamedEntry indexEntry = new NamedEntry(7, entryKind, qualifiedName, 0, fileNumber);
            indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
            indexEntry.serialize(this.indexer.getOutput());
        } else if (binding instanceof IField) {
            int modifiers = 0;
            if (entryKind != 2) {
                modifiers = IndexVisitorUtil.getModifiers(name, binding);
            }
            NamedEntry indexEntry = new NamedEntry(4, entryKind, qualifiedName, modifiers, fileNumber);
            indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
            indexEntry.serialize(this.indexer.getOutput());
        } else if (binding instanceof IVariable && !(binding instanceof IParameter)) {
            IScope definingScope = binding.getScope();
            if (definingScope == name.getTranslationUnit().getScope()) {
                int modifiers = 0;
                if (entryKind != 2) {
                    modifiers = IndexVisitorUtil.getModifiers(name, binding);
                }
                NamedEntry indexEntry = new NamedEntry(9, entryKind, qualifiedName, modifiers, fileNumber);
                indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
                indexEntry.serialize(this.indexer.getOutput());
            }
        } else if (binding instanceof IFunction) {
            int modifiers = 0;
            if (entryKind != 2) {
                modifiers = IndexVisitorUtil.getModifiers(name, binding);
            }
            FunctionEntry indexEntry = new FunctionEntry(2, entryKind, qualifiedName, modifiers, fileNumber);
            indexEntry.setNameOffset(fileLoc.getNodeOffset(), fileLoc.getNodeLength(), 2);
            indexEntry.setSignature(IndexVisitorUtil.getParameters((IFunction)binding));
            indexEntry.setReturnType(IndexVisitorUtil.getReturnType((IFunction)binding));
            indexEntry.serialize(this.indexer.getOutput());
        }
    }

    private char[][] getFullyQualifiedName(IASTName name) {
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IField)) {
            return new char[][]{name.toCharArray()};
        }
        IASTName parent = null;
        try {
            parent = binding.getScope().getScopeName();
        }
        catch (DOMException dOMException) {}
        if (parent != null) {
            return new char[][]{parent.toCharArray(), name.toCharArray()};
        }
        return new char[][]{name.toCharArray()};
    }
}

