/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.CIndexStorage;
import org.eclipse.cdt.internal.core.index.domsourceindexer.AbstractIndexerRunner;
import org.eclipse.cdt.internal.core.index.domsourceindexer.CleanEncounteredHeaders;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMAddFolderToIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSaveIndex;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DOMIndexAllProject
extends DOMIndexRequest {
    IProject project;

    public DOMIndexAllProject(IProject project, DOMSourceIndexer indexer) {
        super(project.getFullPath(), indexer);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof DOMIndexAllProject) {
            return this.project.equals((Object)((DOMIndexAllProject)o).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        ReadWriteMonitor monitor;
        block20: {
            block19: {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                if (!this.project.isAccessible()) {
                    return true;
                }
                IIndex index = this.indexer.getIndex(this.indexPath, true, true);
                if (index == null) {
                    return true;
                }
                monitor = this.indexer.getMonitorFor(index);
                if (monitor == null) {
                    return true;
                }
                try {
                    try {
                        CModel model;
                        if (AbstractIndexerRunner.TIMING) {
                            this.indexer.setTotalIndexTime(0L);
                        }
                        monitor.enterRead();
                        this.saveIfNecessary(index, monitor);
                        IQueryResult[] results = index.queryInDocumentNames("");
                        int max = results == null ? 0 : results.length;
                        SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                        int i = 0;
                        while (true) {
                            if (i >= max) {
                                model = CModelManager.getDefault().getCModel();
                                if (model != null) break;
                                Object var13_11 = null;
                                monitor.exitRead();
                                return false;
                            }
                            indexedFileNames.put(results[i].getPath(), "DELETED");
                            ++i;
                        }
                        ICProject cProject = model.getCProject(this.project.getName());
                        if (cProject == null) {
                            break block19;
                        }
                        CleanEncounteredHeaders cleanHeaders = new CleanEncounteredHeaders(this.indexer);
                        this.indexer.request(cleanHeaders);
                        ISourceRoot[] sourceRoot = cProject.getSourceRoots();
                        int i2 = 0;
                        while (true) {
                            if (i2 >= sourceRoot.length) {
                                this.indexer.request(new DOMSaveIndex(this.indexPath, this.indexer));
                                break block20;
                            }
                            if (sourceRoot[i2] instanceof SourceRoot) {
                                ISourceEntry tempEntry = ((SourceRoot)sourceRoot[i2]).getSourceEntry();
                                this.indexer.request(new DOMAddFolderToIndex(sourceRoot[i2].getPath(), this.project, tempEntry.fullExclusionPatternChars(), this.indexer));
                            }
                            ++i2;
                        }
                    }
                    catch (CoreException e) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            e.printStackTrace();
                        }
                        this.indexer.removeIndex(this.indexPath);
                        Object var13_13 = null;
                        monitor.exitRead();
                        return false;
                    }
                    catch (IOException e) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            e.printStackTrace();
                        }
                        this.indexer.removeIndex(this.indexPath);
                        Object var13_14 = null;
                        monitor.exitRead();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            Object var13_12 = null;
            monitor.exitRead();
            return false;
        }
        Object var13_16 = null;
        monitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return CIndexStorage.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

