/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IndexRequest;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public abstract class DOMIndexRequest
extends IndexRequest {
    protected DOMSourceIndexer indexer = null;

    public DOMIndexRequest(IPath indexPath, DOMSourceIndexer indexer) {
        super(indexPath);
        this.indexer = indexer;
    }

    public void cancel() {
        this.indexer.jobFinishedNotification(this);
        this.indexer.jobWasCancelled(this.indexPath);
        this.isCancelled = true;
    }

    public boolean isReadyToRun() {
        IProject project = CCorePlugin.getWorkspace().getRoot().getProject(this.indexPath.segment(0));
        if (!project.isAccessible() || !this.indexer.isIndexEnabled(project)) {
            return false;
        }
        this.indexer.aboutToUpdateIndex(this.indexPath, this.updatedIndexState());
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveIfNecessary(IIndex index, ReadWriteMonitor monitor) throws IOException {
        if (!index.hasChanged()) return;
        try {
            monitor.exitRead();
            monitor.enterWrite();
            this.indexer.saveIndex(index);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.exitWriteEnterRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            monitor.exitWriteEnterRead();
            return;
        }
    }
}

