/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMIndexRequest;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DOMRemoveFolderFromIndex
extends DOMIndexRequest {
    IPath folderPath;
    char[][] exclusionPatterns;
    IProject project;

    public DOMRemoveFolderFromIndex(IPath folderPath, char[][] exclusionPatterns, IProject project, DOMSourceIndexer indexer) {
        super(project.getFullPath(), indexer);
        this.folderPath = folderPath;
        this.exclusionPatterns = exclusionPatterns;
        this.project = project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.indexer.getIndex(this.indexPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                int max;
                monitor.enterRead();
                IQueryResult[] results = index.queryInDocumentNames(this.folderPath.toString());
                int i = 0;
                int n = max = results == null ? 0 : results.length;
                while (i < max) {
                    String documentPath = results[i].getPath();
                    if (this.exclusionPatterns == null || !Util.isExcluded((IPath)new Path(documentPath), this.exclusionPatterns)) {
                        this.indexer.remove(documentPath, this.indexPath);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                if (IndexManager.VERBOSE) {
                    JobManager.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:");
                    e.printStackTrace();
                }
                Object var8_9 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var8_11 = null;
            monitor.exitRead();
            return true;
        }
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.indexPath;
    }
}

