/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;

public class IndexVisitorUtil {
    private IndexVisitorUtil() {
    }

    static int getModifiers(IASTName name, IBinding binding) {
        int modifiers = 0;
        try {
            if (binding instanceof ICPPMember) {
                ICPPMember member = (ICPPMember)binding;
                int vis = member.getVisibility();
                if (vis == 1) {
                    modifiers |= 2;
                } else if (vis == 3) {
                    modifiers |= 1;
                } else if (vis == 2) {
                    modifiers |= 4;
                }
            }
            if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
                IASTNode parent = name.getParent();
                if (parent instanceof IASTDeclSpecifier) {
                    IASTDeclSpecifier declSpec = (IASTDeclSpecifier)parent;
                    if (declSpec.isConst()) {
                        modifiers |= 8;
                    } else if (declSpec.isVolatile()) {
                        modifiers |= 0x10;
                    }
                    if (declSpec.isInline()) {
                        modifiers |= 0x80;
                    }
                    if (declSpec instanceof ICPPASTDeclSpecifier) {
                        ICPPASTDeclSpecifier cppDeclSpec = (ICPPASTDeclSpecifier)declSpec;
                        if (cppDeclSpec.isExplicit()) {
                            modifiers |= 0x400;
                        }
                        if (cppDeclSpec.isVirtual()) {
                            modifiers |= 0x100;
                        }
                    }
                }
            } else if (binding instanceof IVariable) {
                ICPPVariable cppVariable;
                IVariable variableBinding = (IVariable)binding;
                if (variableBinding.isAuto()) {
                    modifiers |= 0x800;
                } else if (variableBinding.isExtern()) {
                    modifiers |= 0x40;
                } else if (variableBinding.isRegister()) {
                    modifiers |= 0x1000;
                } else if (variableBinding.isStatic()) {
                    modifiers |= 0x20;
                }
                if (variableBinding instanceof ICPPVariable && (cppVariable = (ICPPVariable)variableBinding).isMutable()) {
                    modifiers |= 0x2000;
                }
            } else if (binding instanceof IFunction) {
                IASTNode parent;
                IFunction functionBinding;
                if (binding instanceof ICInternalFunction) {
                    ((ICInternalFunction)((Object)binding)).setFullyResolved(true);
                }
                if ((functionBinding = (IFunction)binding).isAuto()) {
                    modifiers |= 0x800;
                } else if (functionBinding.isExtern()) {
                    modifiers |= 0x40;
                } else if (functionBinding.isRegister()) {
                    modifiers |= 0x1000;
                } else if (binding instanceof ICPPInternalFunction ? ((ICPPInternalFunction)((Object)functionBinding)).isStatic(false) : functionBinding.isStatic()) {
                    modifiers |= 0x20;
                } else if (functionBinding.isInline()) {
                    modifiers |= 0x80;
                }
                if (functionBinding instanceof ICPPFunction) {
                    ICPPFunction cppFunction = (ICPPFunction)functionBinding;
                    if (cppFunction.isMutable()) {
                        modifiers |= 0x2000;
                    }
                    if (cppFunction instanceof ICPPMethod) {
                        ICPPConstructor constructor;
                        ICPPMethod cppMethod = (ICPPMethod)cppFunction;
                        if (cppMethod.isVirtual()) {
                            modifiers |= 0x100;
                        }
                        if (cppMethod instanceof ICPPConstructor && (constructor = (ICPPConstructor)cppMethod).isExplicit()) {
                            modifiers |= 0x400;
                        }
                    }
                }
                if ((parent = name.getParent()) instanceof ICPPASTFunctionDeclarator) {
                    ICPPASTFunctionDeclarator cppFunDecl = (ICPPASTFunctionDeclarator)parent;
                    if (cppFunDecl.isConst()) {
                        modifiers |= 8;
                    } else if (cppFunDecl.isVolatile()) {
                        modifiers |= 0x10;
                    }
                    if (cppFunDecl.isPureVirtual()) {
                        modifiers |= 0x200;
                    }
                }
            }
        }
        catch (DOMException dOMException) {}
        return modifiers;
    }

    public static char[][] getParameters(IASTName functionName) {
        IASTNode parent = functionName.getParent();
        if (parent instanceof ICPPASTQualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTFunctionDeclarator) {
            char[][] rv;
            IASTFunctionDeclarator fDecl = (IASTFunctionDeclarator)parent;
            String[] parameters = ASTSignatureUtil.getParameterSignatureArray(fDecl);
            if (fDecl instanceof IASTStandardFunctionDeclarator && ((IASTStandardFunctionDeclarator)fDecl).takesVarArgs()) {
                rv = new char[parameters.length + 1][];
                rv[parameters.length] = "...".toCharArray();
            } else {
                rv = new char[parameters.length][];
            }
            if (rv.length == 0) {
                return new char[][]{"void".toCharArray()};
            }
            int k = 0;
            while (k < parameters.length) {
                rv[k] = parameters[k].toCharArray();
                ++k;
            }
            return rv;
        }
        return new char[0][];
    }

    public static char[][] getParameters(IFunction function) {
        ArrayList<char[]> parameterList = new ArrayList<char[]>();
        try {
            IParameter[] parameters = function.getParameters();
            int i = 0;
            while (i < parameters.length) {
                IType paramType = parameters[i].getType();
                parameterList.add(ASTTypeUtil.getType(paramType).toCharArray());
                ++i;
            }
            if (function.takesVarArgs()) {
                parameterList.add("...".toCharArray());
            }
            if (parameterList.isEmpty()) {
                parameterList.add("void".toCharArray());
            }
        }
        catch (DOMException dOMException) {}
        return (char[][])parameterList.toArray((T[])new char[parameterList.size()][]);
    }

    public static char[] getReturnType(IFunction function) {
        try {
            IFunctionType functionType = function.getType();
            IType returnType = functionType.getReturnType();
            return ASTTypeUtil.getType(returnType).toCharArray();
        }
        catch (DOMException dOMException) {
            return new char[0];
        }
    }
}

