/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import org.eclipse.cdt.internal.core.index.FunctionEntry;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.index.NamedEntry;
import org.eclipse.cdt.internal.core.index.TypeEntry;

class IndexerOutputWrapper {
    private static final int CLASS_CONST = 1;
    private static final int STRUCT_CONST = 2;
    private static final int UNION_CONST = 3;
    private static final int ENUM_CONST = 4;
    private static final int VAR_CONST = 5;
    private static final int TYPEDEF_CONST = 6;
    private static final int DERIVED_CONST = 7;
    private static final int FRIEND_CONST = 8;
    private static final int NAMESPACE_CONST = 12;
    private static final int ENUMERATOR_CONST = 13;
    private static final int FIELD_CONST = 14;
    private static final int METHOD_CONST = 15;
    private static final int FUNCTION_CONST = 16;
    private static final int MACRO_CONST = 17;
    private static final int INCLUDE_CONST = 18;
    static final EntryType CLASS = new EntryType(1);
    static final EntryType STRUCT = new EntryType(2);
    static final EntryType UNION = new EntryType(3);
    static final EntryType ENUM = new EntryType(4);
    static final EntryType VAR = new EntryType(5);
    static final EntryType TYPEDEF = new EntryType(6);
    static final EntryType DERIVED = new EntryType(7);
    static final EntryType FRIEND = new EntryType(8);
    static final EntryType NAMESPACE = new EntryType(12);
    static final EntryType ENUMERATOR = new EntryType(13);
    static final EntryType FIELD = new EntryType(14);
    static final EntryType METHOD = new EntryType(15);
    static final EntryType FUNCTION = new EntryType(16);
    static final EntryType MACRO = new EntryType(17);
    static final EntryType INCLUDE = new EntryType(18);

    private IndexerOutputWrapper() {
    }

    static void addIndexEntry(IIndexerOutput indexerOutput, char[][] name, EntryType entryType, int entryKind, int fileNumber, int offset, int length, int offsetType) {
        if (name == null) {
            name = new char[][]{"NPE".toCharArray()};
        }
        switch (entryType.toInt()) {
            case 1: {
                TypeEntry typeEntry = new TypeEntry(1, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 2: {
                TypeEntry typeEntry = new TypeEntry(2, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 3: {
                TypeEntry typeEntry = new TypeEntry(3, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 4: {
                TypeEntry typeEntry = new TypeEntry(4, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 5: {
                TypeEntry namedEntry = new TypeEntry(9, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                ((NamedEntry)namedEntry).serialize(indexerOutput);
                break;
            }
            case 6: {
                TypeEntry typeEntry = new TypeEntry(5, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 7: {
                TypeEntry typeEntry = new TypeEntry(6, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 8: {
                TypeEntry typeEntry = new TypeEntry(7, entryKind, (char[][])name, 0, fileNumber);
                typeEntry.setNameOffset(offset, length, offsetType);
                typeEntry.serialize(indexerOutput);
                break;
            }
            case 12: {
                NamedEntry namedEntry = new NamedEntry(6, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                namedEntry.serialize(indexerOutput);
                break;
            }
            case 13: {
                NamedEntry namedEntry = new NamedEntry(7, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                namedEntry.serialize(indexerOutput);
                break;
            }
            case 14: {
                NamedEntry namedEntry = new NamedEntry(4, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                namedEntry.serialize(indexerOutput);
                break;
            }
            case 15: {
                FunctionEntry functionEntry = new FunctionEntry(3, entryKind, (char[][])name, 0, fileNumber);
                functionEntry.setNameOffset(offset, length, offsetType);
                functionEntry.serialize(indexerOutput);
                break;
            }
            case 16: {
                FunctionEntry functionEntry = new FunctionEntry(2, entryKind, (char[][])name, 0, fileNumber);
                functionEntry.setNameOffset(offset, length, offsetType);
                functionEntry.serialize(indexerOutput);
                break;
            }
            case 17: {
                NamedEntry namedEntry = new NamedEntry(5, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                namedEntry.serialize(indexerOutput);
                break;
            }
            case 18: {
                NamedEntry namedEntry = new NamedEntry(8, entryKind, (char[][])name, 0, fileNumber);
                namedEntry.setNameOffset(offset, length, offsetType);
                namedEntry.serialize(indexerOutput);
            }
        }
    }

    static class EntryType {
        private int type;

        public int toInt() {
            return this.type;
        }

        private EntryType(int type) {
            this.type = type;
        }
    }
}

